/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.table.types.inference.strategies;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.inference.InputTypeStrategiesTestBase;

import org.junit.runners.Parameterized;

import java.util.List;

import static java.util.Arrays.asList;
import static org.apache.flink.table.types.inference.InputTypeStrategies.TYPE_LITERAL;
import static org.apache.flink.table.types.inference.InputTypeStrategies.sequence;

/** Tests for {@link TypeLiteralArgumentTypeStrategy}. */
public class TypeLiteralArgumentTypeStrategyTest extends InputTypeStrategiesTestBase {

    @Parameterized.Parameters(name = "{index}: {0}")
    public static List<TestSpec> testData() {
        return asList(
                TestSpec.forStrategy("Type literal", sequence(TYPE_LITERAL))
                        .calledWithArgumentTypes(DataTypes.STRING())
                        .calledWithLiteralAt(0, DataTypes.STRING())
                        .expectArgumentTypes(DataTypes.STRING())
                        .expectSignature("f(<DATA TYPE NOT NULL>)"),
                TestSpec.forStrategy("Value literal", sequence(TYPE_LITERAL))
                        .calledWithArgumentTypes(DataTypes.STRING())
                        .calledWithLiteralAt(0, "Test")
                        .expectErrorMessage(
                                String.format(
                                        "Invalid input arguments. Expected signatures are:%nf(<DATA TYPE NOT NULL>)")));
    }
}
