/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.transforms;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeInfoDataTypeConverter;

@Internal
public class LegacyToNonLegacyTransformation
implements TypeTransformation {
    public static final TypeTransformation INSTANCE = new LegacyToNonLegacyTransformation();

    @Override
    public DataType transform(DataType typeToTransform) {
        return this.transform(null, typeToTransform);
    }

    @Override
    public DataType transform(@Nullable DataTypeFactory factory, DataType dataType2) {
        if (factory == null) {
            throw new TableException("LegacyToNonLegacyTransformation requires access to the data type factory.");
        }
        LogicalType type = dataType2.getLogicalType();
        if (type instanceof LegacyTypeInformationType) {
            return TypeInfoDataTypeConverter.toDataType(factory, ((LegacyTypeInformationType)type).getTypeInformation(), true);
        }
        return dataType2;
    }
}

