/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.nio.ByteOrder;
import org.apache.flink.api.common.typeutils.base.NormalizedKeyUtil;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemoryUtils;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryStringData;

public class SortUtil {
    private static final int BYTE_ARRAY_BASE_OFFSET = MemoryUtils.UNSAFE.arrayBaseOffset(byte[].class);
    private static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final int LONG_BYTES = 8;

    public static void minNormalizedKey(MemorySegment target, int offset, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            target.put(offset + i, (byte)0);
        }
    }

    public static void maxNormalizedKey(MemorySegment target, int offset, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            target.put(offset + i, (byte)-1);
        }
    }

    public static void putShortNormalizedKey(short value2, MemorySegment target, int offset, int numBytes) {
        NormalizedKeyUtil.putShortNormalizedKey((short)value2, (MemorySegment)target, (int)offset, (int)numBytes);
    }

    public static void putByteNormalizedKey(byte value2, MemorySegment target, int offset, int numBytes) {
        NormalizedKeyUtil.putByteNormalizedKey((byte)value2, (MemorySegment)target, (int)offset, (int)numBytes);
    }

    public static void putBooleanNormalizedKey(boolean value2, MemorySegment target, int offset, int numBytes) {
        NormalizedKeyUtil.putBooleanNormalizedKey((boolean)value2, (MemorySegment)target, (int)offset, (int)numBytes);
    }

    public static void putStringNormalizedKey(StringData value2, MemorySegment target, int offset, int numBytes) {
        int i;
        BinaryStringData binaryString = (BinaryStringData)value2;
        int limit = offset + numBytes;
        int end = binaryString.getSizeInBytes();
        for (i = 0; i < end && offset < limit; ++i) {
            target.put(offset++, binaryString.byteAt(i));
        }
        for (i = offset; i < limit; ++i) {
            target.put(i, (byte)0);
        }
    }

    public static void putDecimalNormalizedKey(DecimalData record, MemorySegment target, int offset, int len) {
        assert (record.isCompact());
        SortUtil.putLongNormalizedKey(record.toUnscaledLong(), target, offset, len);
    }

    public static void putIntNormalizedKey(int value2, MemorySegment target, int offset, int numBytes) {
        NormalizedKeyUtil.putIntNormalizedKey((int)value2, (MemorySegment)target, (int)offset, (int)numBytes);
    }

    public static void putLongNormalizedKey(long value2, MemorySegment target, int offset, int numBytes) {
        NormalizedKeyUtil.putLongNormalizedKey((long)value2, (MemorySegment)target, (int)offset, (int)numBytes);
    }

    public static void putFloatNormalizedKey(float value2, MemorySegment target, int offset, int numBytes) {
        int iValue = Float.floatToIntBits(value2);
        iValue ^= iValue >> 31 | Integer.MIN_VALUE;
        NormalizedKeyUtil.putUnsignedIntegerNormalizedKey((int)iValue, (MemorySegment)target, (int)offset, (int)numBytes);
    }

    public static void putDoubleNormalizedKey(double value2, MemorySegment target, int offset, int numBytes) {
        long lValue = Double.doubleToLongBits(value2);
        lValue ^= lValue >> 63 | Long.MIN_VALUE;
        NormalizedKeyUtil.putUnsignedLongNormalizedKey((long)lValue, (MemorySegment)target, (int)offset, (int)numBytes);
    }

    public static void putBinaryNormalizedKey(byte[] value2, MemorySegment target, int offset, int numBytes) {
        int i;
        int limit = offset + numBytes;
        int end = value2.length;
        for (i = 0; i < end && offset < limit; ++i) {
            target.put(offset++, value2[i]);
        }
        for (i = offset; i < limit; ++i) {
            target.put(i, (byte)0);
        }
    }

    public static void putTimestampNormalizedKey(TimestampData value2, MemorySegment target, int offset, int numBytes) {
        assert (value2.getNanoOfMillisecond() == 0);
        SortUtil.putLongNormalizedKey(value2.getMillisecond(), target, offset, numBytes);
    }

    public static int compareBinary(byte[] a, byte[] b) {
        return SortUtil.compareBinary(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBinary(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        int i;
        if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int minLength = Math.min(length1, length2);
        int minWords = minLength / 8;
        int offset1Adj = offset1 + BYTE_ARRAY_BASE_OFFSET;
        int offset2Adj = offset2 + BYTE_ARRAY_BASE_OFFSET;
        for (i = 0; i < minWords * 8; i += 8) {
            int y;
            long rw;
            long lw = MemoryUtils.UNSAFE.getLong(buffer1, (long)offset1Adj + (long)i);
            long diff = lw ^ (rw = MemoryUtils.UNSAFE.getLong(buffer2, (long)offset2Adj + (long)i));
            if (diff == 0L) continue;
            if (!LITTLE_ENDIAN) {
                return SortUtil.lessThanUnsigned(lw, rw) ? -1 : 1;
            }
            int n = 0;
            int x = (int)diff;
            if (x == 0) {
                x = (int)(diff >>> 32);
                n = 32;
            }
            if ((y = x << 16) == 0) {
                n += 16;
            } else {
                x = y;
            }
            y = x << 8;
            if (y == 0) {
                n += 8;
            }
            return (int)((lw >>> n & 0xFFL) - (rw >>> n & 0xFFL));
        }
        for (i = minWords * 8; i < minLength; ++i) {
            int result = SortUtil.unsignedByteToInt(buffer1[offset1 + i]) - SortUtil.unsignedByteToInt(buffer2[offset2 + i]);
            if (result == 0) continue;
            return result;
        }
        return length1 - length2;
    }

    private static int unsignedByteToInt(byte value2) {
        return value2 & 0xFF;
    }

    private static boolean lessThanUnsigned(long x1, long x2) {
        return x1 + Long.MIN_VALUE < x2 + Long.MIN_VALUE;
    }
}

