/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext$;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSnapshot;
import org.apache.flink.table.planner.plan.utils.IntervalJoinUtil$;
import org.apache.flink.table.planner.plan.utils.JoinTypeUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil$;
import org.apache.flink.table.planner.plan.utils.WindowJoinUtil$;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinInputSideSpec;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class JoinUtil$ {
    public static final JoinUtil$ MODULE$;

    static {
        new JoinUtil$();
    }

    public JoinSpec createJoinSpec(Join join) {
        ArrayList<Boolean> filterNulls = new ArrayList<Boolean>();
        JoinInfo joinInfo = this.createJoinInfo(join.getLeft(), join.getRight(), join.getCondition(), filterNulls);
        RexNode nonEquiCondition = RexUtil.composeConjunction(join.getCluster().getRexBuilder(), joinInfo.nonEquiConditions);
        return new JoinSpec(JoinTypeUtil.getFlinkJoinType(join.getJoinType()), joinInfo.leftKeys.toIntArray(), joinInfo.rightKeys.toIntArray(), (boolean[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(filterNulls).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$1) {
                return x$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean()), nonEquiCondition);
    }

    public void validateJoinSpec(JoinSpec joinSpec, RowType leftType, RowType rightType, boolean allowEmptyKey) {
        if (Predef$.MODULE$.intArrayOps(joinSpec.getLeftKeys()).isEmpty() && !allowEmptyKey) {
            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Joins should have at least one equality condition.\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tLeft type: ", "\\n\\tright type: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftType, rightType}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"please re-check the join statement and make sure there's "})).s((Seq)Nil$.MODULE$)).append((Object)"equality condition for join.").toString());
        }
        int[] leftKeys = joinSpec.getLeftKeys();
        int[] rightKeys = joinSpec.getRightKeys();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), joinSpec.getJoinKeySize()).foreach$mVc$sp((Function1)new Serializable(leftType, rightType, leftKeys, rightKeys){
            public static final long serialVersionUID = 0L;
            private final RowType leftType$1;
            private final RowType rightType$1;
            private final int[] leftKeys$1;
            private final int[] rightKeys$1;

            public final void apply(int idx) {
                this.apply$mcVI$sp(idx);
            }

            public void apply$mcVI$sp(int idx) {
                LogicalType rightKeyType;
                LogicalType leftKeyType = this.leftType$1.getTypeAt(this.leftKeys$1[idx]);
                if (PlannerTypeUtils.isInteroperable(leftKeyType, rightKeyType = this.rightType$1.getTypeAt(this.rightKeys$1[idx]))) {
                    return;
                }
                throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Join: Equality join predicate on incompatible types. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\tLeft type: ", "\\n\\tright type: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.leftType$1, this.rightType$1}))).append((Object)"please re-check the join statement.").toString());
            }
            {
                this.leftType$1 = leftType$1;
                this.rightType$1 = rightType$1;
                this.leftKeys$1 = leftKeys$1;
                this.rightKeys$1 = rightKeys$1;
            }
        });
    }

    public boolean validateJoinSpec$default$4() {
        return false;
    }

    public JoinInfo createJoinInfo(RelNode left, RelNode right, RexNode condition, List<Boolean> filterNulls) {
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RexNode remaining = RelOptUtil.splitJoinCondition(left, right, condition, leftKeys, rightKeys, filterNulls);
        return remaining.isAlwaysTrue() ? JoinInfo.of(ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys)) : JoinInfo.of(left, right, condition);
    }

    public GeneratedJoinCondition generateConditionFunction(TableConfig config, JoinSpec joinSpec, LogicalType leftType, LogicalType rightType) {
        return this.generateConditionFunction(config, (RexNode)joinSpec.getNonEquiCondition().orElse(null), leftType, rightType);
    }

    public GeneratedJoinCondition generateConditionFunction(TableConfig config, RexNode nonEquiCondition, LogicalType leftType, LogicalType rightType) {
        String string2;
        CodeGeneratorContext ctx = CodeGeneratorContext$.MODULE$.apply(config);
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        LogicalType x$3 = leftType;
        String x$4 = qual$1.bindInput$default$2();
        Option<int[]> x$5 = qual$1.bindInput$default$3();
        ExprCodeGenerator qual$2 = qual$1.bindInput(x$3, x$4, x$5);
        LogicalType x$6 = rightType;
        String x$7 = qual$2.bindSecondInput$default$2();
        Option<int[]> x$8 = qual$2.bindSecondInput$default$3();
        ExprCodeGenerator exprGenerator = qual$2.bindSecondInput(x$6, x$7, x$8);
        if (nonEquiCondition == null) {
            string2 = "return true;";
        } else {
            GeneratedExpression condition = exprGenerator.generateExpression(nonEquiCondition);
            string2 = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |return ", ";\n         |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{condition.code(), condition.resultTerm()})))).stripMargin();
        }
        String body = string2;
        return FunctionCodeGenerator$.MODULE$.generateJoinCondition(ctx, "ConditionFunction", body, FunctionCodeGenerator$.MODULE$.generateJoinCondition$default$4(), FunctionCodeGenerator$.MODULE$.generateJoinCondition$default$5());
    }

    public JoinInputSideSpec analyzeJoinInput(InternalTypeInfo<RowData> inputTypeInfo, int[] joinKeys, List<int[]> uniqueKeys) {
        JoinInputSideSpec joinInputSideSpec;
        if (uniqueKeys == null || uniqueKeys.isEmpty()) {
            joinInputSideSpec = JoinInputSideSpec.withoutUniqueKey();
        } else {
            HashSet joinKeySet = new HashSet();
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(joinKeys).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Integer apply(int x) {
                    return BoxesRunTime.boxToInteger((int)x);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class)))).foreach((Function1)new Serializable(joinKeySet){
                public static final long serialVersionUID = 0L;
                private final HashSet joinKeySet$1;

                public final boolean apply(Integer x$1) {
                    return this.joinKeySet$1.add(x$1);
                }
                {
                    this.joinKeySet$1 = joinKeySet$1;
                }
            });
            Buffer uniqueKeysContainedByJoinKey = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(uniqueKeys).filter((Function1)new Serializable(joinKeySet){
                public static final long serialVersionUID = 0L;
                private final HashSet joinKeySet$1;

                public final boolean apply(int[] uk) {
                    return this.joinKeySet$1.containsAll(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.intArrayOps(uk).toList()));
                }
                {
                    this.joinKeySet$1 = joinKeySet$1;
                }
            });
            if (uniqueKeysContainedByJoinKey.isEmpty()) {
                int[] smallestUniqueKey = this.getSmallestKey(uniqueKeys);
                RowDataKeySelector uniqueKeySelector = KeySelectorUtil.getRowDataSelector(smallestUniqueKey, inputTypeInfo);
                TypeInformation uniqueKeyTypeInfo = uniqueKeySelector.getProducedType();
                joinInputSideSpec = JoinInputSideSpec.withUniqueKey((InternalTypeInfo<RowData>)uniqueKeyTypeInfo, uniqueKeySelector);
            } else {
                int[] smallestUniqueKey = this.getSmallestKey(JavaConversions$.MODULE$.bufferAsJavaList(uniqueKeysContainedByJoinKey));
                RowDataKeySelector uniqueKeySelector = KeySelectorUtil.getRowDataSelector(smallestUniqueKey, inputTypeInfo);
                TypeInformation uniqueKeyTypeInfo = uniqueKeySelector.getProducedType();
                joinInputSideSpec = JoinInputSideSpec.withUniqueKeyContainedByJoinKey((InternalTypeInfo<RowData>)uniqueKeyTypeInfo, uniqueKeySelector);
            }
        }
        return joinInputSideSpec;
    }

    private int[] getSmallestKey(List<int[]> keys) {
        return (int[])JavaConversions$.MODULE$.asScalaBuffer(keys).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int[] apply(int[] k1, int[] k2) {
                return k1.length <= k2.length ? k1 : k2;
            }
        });
    }

    public boolean accessesTimeAttribute(RexNode expr, RelDataType inputType) {
        boolean bl;
        RexNode rexNode = expr;
        if (rexNode instanceof RexInputRef) {
            RexInputRef rexInputRef = (RexInputRef)rexNode;
            RelDataType accessedType = inputType.getFieldList().get(rexInputRef.getIndex()).getType();
            bl = FlinkTypeFactory$.MODULE$.isTimeIndicatorType(accessedType);
        } else if (rexNode instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode;
            bl = JavaConversions$.MODULE$.asScalaBuffer(rexCall.operands).exists((Function1)new Serializable(inputType){
                public static final long serialVersionUID = 0L;
                private final RelDataType inputType$1;

                public final boolean apply(RexNode x$2) {
                    return JoinUtil$.MODULE$.accessesTimeAttribute(x$2, this.inputType$1);
                }
                {
                    this.inputType$1 = inputType$1;
                }
            });
        } else {
            bl = false;
        }
        return bl;
    }

    public RelDataType combineJoinInputsRowType(Join join) {
        JoinRelType joinRelType = join.getJoinType();
        boolean bl = ((Object)((Object)JoinRelType.SEMI)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.ANTI)).equals((Object)joinRelType);
        RelDataType relDataType = bl ? SqlValidatorUtil.createJoinType(join.getCluster().getTypeFactory(), join.getLeft().getRowType(), join.getRight().getRowType(), null, Collections.emptyList()) : join.getRowType();
        return relDataType;
    }

    public boolean satisfyRegularJoin(FlinkLogicalJoin join) {
        return this.satisfyRegularJoin(join, join.getRight());
    }

    public boolean satisfyRegularJoin(FlinkLogicalJoin join, RelNode right) {
        return right instanceof FlinkLogicalSnapshot ? false : (TemporalJoinUtil$.MODULE$.satisfyTemporalJoin(join) ? false : (IntervalJoinUtil$.MODULE$.satisfyIntervalJoin(join) ? false : !WindowJoinUtil$.MODULE$.satisfyWindowJoin(join)));
    }

    private JoinUtil$() {
        MODULE$ = this;
    }
}

