/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWindowJoin;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWindowTableFunction;
import org.apache.flink.table.planner.plan.rules.physical.stream.SimplifyWindowTableFunctionRuleBase;

abstract class SimplifyWindowTableFunctionWithWindowJoinRuleBase
extends SimplifyWindowTableFunctionRuleBase {
    SimplifyWindowTableFunctionWithWindowJoinRuleBase(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        StreamPhysicalWindowTableFunction leftWindowTVF = this.getLeftWindowTVF(call);
        List<RelNode> rels = call.getRelList();
        StreamPhysicalWindowTableFunction rightWindowTVF = (StreamPhysicalWindowTableFunction)rels.get(rels.size() - 1);
        return this.needSimplify(leftWindowTVF) || this.needSimplify(rightWindowTVF);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        StreamPhysicalWindowJoin join = (StreamPhysicalWindowJoin)call.rel(0);
        RelNode newLeft = this.buildNewLeftTree(call);
        RelNode newRight = this.buildNewRightTree(call);
        Join newJoin = join.copy(join.getTraitSet(), join.getCondition(), newLeft, newRight, join.getJoinType(), join.isSemiJoinDone());
        call.transformTo(newJoin);
    }

    abstract StreamPhysicalWindowTableFunction getLeftWindowTVF(RelOptRuleCall var1);

    abstract RelNode buildNewLeftTree(RelOptRuleCall var1);

    abstract RelNode buildNewRightTree(RelOptRuleCall var1);
}

