/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContext$class;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverterFactory;
import org.apache.flink.table.planner.delegation.StreamPlanner;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.calcite.LegacySink;
import org.apache.flink.table.planner.plan.nodes.calcite.Sink;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalDataStreamScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalIntermediateTableScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.optimize.CommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlock;
import org.apache.flink.table.planner.plan.optimize.RelNodeBlockPlanBuilder$;
import org.apache.flink.table.planner.plan.optimize.StreamCommonSubGraphBasedOptimizer$;
import org.apache.flink.table.planner.plan.optimize.program.FlinkChainedProgram;
import org.apache.flink.table.planner.plan.optimize.program.FlinkStreamProgram$;
import org.apache.flink.table.planner.plan.optimize.program.StreamOptimizeContext;
import org.apache.flink.table.planner.plan.schema.IntermediateRelTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.plan.trait.MiniBatchInterval;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTrait;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTrait$;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTraitDef$;
import org.apache.flink.table.planner.plan.trait.MiniBatchMode;
import org.apache.flink.table.planner.plan.trait.ModifyKindSet;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTrait;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTraitDef$;
import org.apache.flink.table.planner.plan.trait.RelModifiedMonotonicity;
import org.apache.flink.table.planner.plan.trait.RelWindowProperties;
import org.apache.flink.table.planner.plan.trait.UpdateKind;
import org.apache.flink.table.planner.plan.trait.UpdateKindTrait;
import org.apache.flink.table.planner.plan.trait.UpdateKindTraitDef$;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ub\u0001B\u0001\u0003\u0001E\u0011!e\u0015;sK\u0006l7i\\7n_:\u001cVOY$sCBD')Y:fI>\u0003H/[7ju\u0016\u0014(BA\u0002\u0005\u0003!y\u0007\u000f^5nSj,'BA\u0003\u0007\u0003\u0011\u0001H.\u00198\u000b\u0005\u001dA\u0011a\u00029mC:tWM\u001d\u0006\u0003\u0013)\tQ\u0001^1cY\u0016T!a\u0003\u0007\u0002\u000b\u0019d\u0017N\\6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ta2i\\7n_:\u001cVOY$sCBD')Y:fI>\u0003H/[7ju\u0016\u0014\b\u0002C\u0004\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0011\u0005aYR\"A\r\u000b\u0005i1\u0011A\u00033fY\u0016<\u0017\r^5p]&\u0011A$\u0007\u0002\u000e'R\u0014X-Y7QY\u0006tg.\u001a:\t\u000by\u0001A\u0011A\u0010\u0002\rqJg.\u001b;?)\t\u0001\u0013\u0005\u0005\u0002\u0014\u0001!)q!\ba\u0001/!)1\u0005\u0001C)I\u0005QAm\\(qi&l\u0017N_3\u0015\u0005\u00152\u0004c\u0001\u00141g9\u0011q%\f\b\u0003Q-j\u0011!\u000b\u0006\u0003UA\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059z\u0013a\u00029bG.\fw-\u001a\u0006\u0002Y%\u0011\u0011G\r\u0002\u0004'\u0016\f(B\u0001\u00180!\t\u0019B'\u0003\u00026\u0005\ta!+\u001a7O_\u0012,'\t\\8dW\")qG\ta\u0001q\u0005)!o\\8ugB\u0019a\u0005M\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014a\u0001:fY*\u0011a\bD\u0001\bG\u0006d7-\u001b;f\u0013\t\u00015HA\u0004SK2tu\u000eZ3\t\u000b\t\u0003A\u0011B\"\u0002\u001b=\u0004H/[7ju\u0016\u0014En\\2l)\r!\u0005J\u0013\t\u0003\u000b\u001ak\u0011aL\u0005\u0003\u000f>\u0012A!\u00168ji\")\u0011*\u0011a\u0001g\u0005)!\r\\8dW\")1*\u0011a\u0001\u0019\u0006Y\u0011n]*j].\u0014En\\2l!\t)U*\u0003\u0002O_\t9!i\\8mK\u0006t\u0007\"\u0002)\u0001\t\u0013\t\u0016\u0001D8qi&l\u0017N_3Ue\u0016,G#B\u001dS)Zs\u0006\"B*P\u0001\u0004I\u0014a\u0002:fY:{G-\u001a\u0005\u0006+>\u0003\r\u0001T\u0001\u0015kB$\u0017\r^3CK\u001a|'/\u001a*fcVL'/\u001a3\t\u000b]{\u0005\u0019\u0001-\u0002#5Lg.\u001b\"bi\u000eD\u0017J\u001c;feZ\fG\u000e\u0005\u0002Z96\t!L\u0003\u0002\\\t\u0005)AO]1ji&\u0011QL\u0017\u0002\u0012\u001b&t\u0017NQ1uG\"Le\u000e^3sm\u0006d\u0007\"B&P\u0001\u0004a\u0005\"\u00021\u0001\t\u0013\t\u0017a\n9s_B\fw-\u0019;f+B$\u0017\r^3LS:$\u0017I\u001c3NS:L')\u0019;dQ&sG/\u001a:wC2$R\u0001\u00122dI\u0016DQ!S0A\u0002MBQ!V0A\u00021CQaV0A\u0002aCQaS0A\u00021CQa\u001a\u0001\u0005\n!\fqC]3tKRLe\u000e^3s[\u0016$\u0017.\u0019;f%\u0016\u001cX\u000f\u001c;\u0015\u0005\u0011K\u0007\"B%g\u0001\u0004\u0019\u0004\"B6\u0001\t\u0013a\u0017AG2sK\u0006$X-\u00138uKJlW\rZ5bi\u0016\u0014V\r\u001c+bE2,GCB7tyv\f)\u0001\u0005\u0002oc6\tqN\u0003\u0002q\t\u000511o\u00195f[\u0006L!A]8\u0003)%sG/\u001a:nK\u0012L\u0017\r^3SK2$\u0016M\u00197f\u0011\u0015!(\u000e1\u0001v\u0003\u0011q\u0017-\\3\u0011\u0005YLhBA#x\u0013\tAx&\u0001\u0004Qe\u0016$WMZ\u0005\u0003un\u0014aa\u0015;sS:<'B\u0001=0\u0011\u0015\u0019&\u000e1\u0001:\u0011\u0015q(\u000e1\u0001\u0000\u00035iw\u000eZ5gs.Kg\u000eZ*fiB\u0019\u0011,!\u0001\n\u0007\u0005\r!LA\u0007N_\u0012Lg-_&j]\u0012\u001cV\r\u001e\u0005\u0007\u0003\u000fQ\u0007\u0019\u0001'\u0002-%\u001cX\u000b\u001d3bi\u0016\u0014UMZ8sKJ+\u0017/^5sK\u0012Dq!a\u0003\u0001\t\u0013\ti!A\u0007hKR,f.[9vK.+\u0017p\u001d\u000b\u0005\u0003\u001f\t\u0019\u0004\r\u0003\u0002\u0012\u0005\u0015\u0002CBA\n\u0003;\t\t#\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003\u0011)H/\u001b7\u000b\u0005\u0005m\u0011\u0001\u00026bm\u0006LA!a\b\u0002\u0016\t\u00191+\u001a;\u0011\t\u0005\r\u0012Q\u0005\u0007\u0001\t1\t9#!\u0003\u0002\u0002\u0003\u0005)\u0011AA\u0015\u0005\ryF%M\t\u0005\u0003W\t\t\u0004E\u0002F\u0003[I1!a\f0\u0005\u001dqu\u000e\u001e5j]\u001e\u0004R!a\u0005\u0002\u001eUDaaUA\u0005\u0001\u0004I\u0004")
public class StreamCommonSubGraphBasedOptimizer
extends CommonSubGraphBasedOptimizer {
    public final StreamPlanner org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner;

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<RelNodeBlock> doOptimize(Seq<RelNode> roots) {
        void var3_3;
        TableConfig config = this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getTableConfig();
        Seq<RelNodeBlock> sinkBlocks = RelNodeBlockPlanBuilder$.MODULE$.buildRelNodeBlockPlan(roots, config);
        sinkBlocks.foreach((Function1)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final TableConfig config$1;

            public final void apply(RelNodeBlock sinkBlock) {
                MiniBatchInterval miniBatchInterval;
                sinkBlock.setUpdateBeforeRequired(false);
                if (this.config$1.getConfiguration().getBoolean(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ENABLED)) {
                    long miniBatchLatency = ((Duration)this.config$1.getConfiguration().get(ExecutionConfigOptions.TABLE_EXEC_MINIBATCH_ALLOW_LATENCY)).toMillis();
                    Preconditions.checkArgument((miniBatchLatency > 0L ? 1 : 0) != 0, (String)"MiniBatch Latency must be greater than 0 ms.", (Object[])new Object[]{null});
                    miniBatchInterval = new MiniBatchInterval(miniBatchLatency, MiniBatchMode.ProcTime);
                } else {
                    miniBatchInterval = MiniBatchIntervalTrait$.MODULE$.NONE().getMiniBatchInterval();
                }
                MiniBatchInterval miniBatchInterval2 = miniBatchInterval;
                sinkBlock.setMiniBatchInterval(miniBatchInterval2);
            }
            {
                this.config$1 = config$1;
            }
        });
        if (sinkBlocks.size() == 1) {
            RelNodeBlock block = (RelNodeBlock)sinkBlocks.head();
            RelNode optimizedTree = this.optimizeTree(block.getPlan(), block.isUpdateBeforeRequired(), block.getMiniBatchInterval(), true);
            block.setOptimizedPlan(optimizedTree);
            return sinkBlocks;
        }
        sinkBlocks.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamCommonSubGraphBasedOptimizer $outer;

            public final void apply(RelNodeBlock b) {
                this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$optimizeBlock(b, true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        sinkBlocks.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamCommonSubGraphBasedOptimizer $outer;

            public final void apply(RelNodeBlock b) {
                this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$propagateUpdateKindAndMiniBatchInterval(b, b.isUpdateBeforeRequired(), b.getMiniBatchInterval(), true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        sinkBlocks.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamCommonSubGraphBasedOptimizer $outer;

            public final void apply(RelNodeBlock block) {
                this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$resetIntermediateResult(block);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        sinkBlocks.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamCommonSubGraphBasedOptimizer $outer;

            public final void apply(RelNodeBlock b) {
                this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$optimizeBlock(b, true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return var3_3;
    }

    public void org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$optimizeBlock(RelNodeBlock block, boolean isSinkBlock) {
        RelNode blockLogicalPlan;
        block.children().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamCommonSubGraphBasedOptimizer $outer;

            public final void apply(RelNodeBlock child) {
                if (child.getNewOutputNode().isEmpty()) {
                    this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$optimizeBlock(child, false);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        RelNode relNode = blockLogicalPlan = block.getPlan();
        boolean bl = relNode instanceof LegacySink ? true : relNode instanceof Sink;
        if (bl) {
            Predef$.MODULE$.require(isSinkBlock);
            RelNode optimizedTree = this.optimizeTree(blockLogicalPlan, block.isUpdateBeforeRequired(), block.getMiniBatchInterval(), true);
            block.setOptimizedPlan(optimizedTree);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            RelNode optimizedPlan = this.optimizeTree(relNode, block.isUpdateBeforeRequired(), block.getMiniBatchInterval(), isSinkBlock);
            ModifyKindSetTrait modifyKindSetTrait = optimizedPlan.getTraitSet().getTrait(ModifyKindSetTraitDef$.MODULE$.INSTANCE());
            String name = this.createUniqueIntermediateRelTableName();
            IntermediateRelTable intermediateRelTable = this.createIntermediateRelTable(name, optimizedPlan, modifyKindSetTrait.modifyKindSet(), block.isUpdateBeforeRequired());
            TableScan newTableScan = this.wrapIntermediateRelTableToTableScan(intermediateRelTable, name);
            block.setNewOutputNode(newTableScan);
            block.setOutputTableName(name);
            block.setOptimizedPlan(optimizedPlan);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private RelNode optimizeTree(RelNode relNode, boolean updateBeforeRequired, MiniBatchInterval miniBatchInterval, boolean isSinkBlock) {
        TableConfig config = this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getTableConfig();
        CalciteConfig calciteConfig = TableConfigUtils.getCalciteConfig(config);
        FlinkChainedProgram programs = (FlinkChainedProgram)calciteConfig.getStreamProgram().getOrElse((Function0)new Serializable(this, config){
            public static final long serialVersionUID = 0L;
            private final TableConfig config$2;

            public final FlinkChainedProgram<StreamOptimizeContext> apply() {
                return FlinkStreamProgram$.MODULE$.buildProgram(this.config$2.getConfiguration());
            }
            {
                this.config$2 = config$2;
            }
        });
        Preconditions.checkNotNull((Object)programs);
        FlinkContext context = relNode.getCluster().getPlanner().getContext().unwrap(FlinkContext.class);
        return programs.optimize(relNode, new StreamOptimizeContext(this, updateBeforeRequired, miniBatchInterval, isSinkBlock, config, context){
            private final /* synthetic */ StreamCommonSubGraphBasedOptimizer $outer;
            private final boolean updateBeforeRequired$1;
            private final MiniBatchInterval miniBatchInterval$1;
            private final boolean isSinkBlock$1;
            private final TableConfig config$2;
            private final FlinkContext context$1;

            public <C> C unwrap(Class<C> clazz) {
                return (C)FlinkContext$class.unwrap(this, clazz);
            }

            public boolean isBatchMode() {
                return false;
            }

            public TableConfig getTableConfig() {
                return this.config$2;
            }

            public FunctionCatalog getFunctionCatalog() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.functionCatalog();
            }

            public CatalogManager getCatalogManager() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.catalogManager();
            }

            public SqlExprToRexConverterFactory getSqlExprToRexConverterFactory() {
                return this.context$1.getSqlExprToRexConverterFactory();
            }

            public RexBuilder getRexBuilder() {
                return this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getRelBuilder().getRexBuilder();
            }

            public boolean isUpdateBeforeRequired() {
                return this.updateBeforeRequired$1;
            }

            public MiniBatchInterval getMiniBatchInterval() {
                return this.miniBatchInterval$1;
            }

            public boolean needFinalTimeIndicatorConversion() {
                return this.isSinkBlock$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.updateBeforeRequired$1 = updateBeforeRequired$1;
                this.miniBatchInterval$1 = miniBatchInterval$1;
                this.isSinkBlock$1 = isSinkBlock$1;
                this.config$2 = config$2;
                this.context$1 = context$1;
                FlinkContext$class.$init$(this);
            }
        });
    }

    public void org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$propagateUpdateKindAndMiniBatchInterval(RelNodeBlock block, boolean updateBeforeRequired, MiniBatchInterval miniBatchInterval, boolean isSinkBlock) {
        RelNode blockLogicalPlan = block.getPlan();
        RelNode optimizedPlan = this.optimizeTree(blockLogicalPlan, updateBeforeRequired, miniBatchInterval, isSinkBlock);
        this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$propagateTraits$1(optimizedPlan, block);
        block.children().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamCommonSubGraphBasedOptimizer $outer;

            public final void apply(RelNodeBlock child) {
                this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$propagateUpdateKindAndMiniBatchInterval(child, child.isUpdateBeforeRequired(), child.getMiniBatchInterval(), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$resetIntermediateResult(RelNodeBlock block) {
        block.setNewOutputNode(null);
        block.setOutputTableName(null);
        block.setOptimizedPlan(null);
        block.children().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamCommonSubGraphBasedOptimizer $outer;

            public final void apply(RelNodeBlock child) {
                if (child.getNewOutputNode().nonEmpty()) {
                    this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$resetIntermediateResult(child);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private IntermediateRelTable createIntermediateRelTable(String name, RelNode relNode, ModifyKindSet modifyKindSet, boolean isUpdateBeforeRequired) {
        Set<? extends Set<String>> uniqueKeys = this.getUniqueKeys(relNode);
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getRelBuilder().getCluster().getMetadataQuery());
        RelModifiedMonotonicity monotonicity = fmq.getRelModifiedMonotonicity(relNode);
        RelWindowProperties windowProperties = fmq.getRelWindowProperties(relNode);
        FlinkStatistic statistic2 = FlinkStatistic$.MODULE$.builder().uniqueKeys(uniqueKeys).relModifiedMonotonicity(monotonicity).relWindowProperties(windowProperties).build();
        return new IntermediateRelTable(Collections.singletonList(name), relNode, modifyKindSet, isUpdateBeforeRequired, fmq.getUpsertKeys(relNode), statistic2);
    }

    private Set<? extends Set<String>> getUniqueKeys(RelNode relNode) {
        RelDataType rowType = relNode.getRowType();
        FlinkRelMetadataQuery fmq = FlinkRelMetadataQuery.reuseOrCreate(this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner.getRelBuilder().getCluster().getMetadataQuery());
        Set<ImmutableBitSet> uniqueKeys = fmq.getUniqueKeys(relNode);
        return uniqueKeys == null ? null : JavaConversions$.MODULE$.mutableSetAsJavaSet((scala.collection.mutable.Set)((SetLike)JavaConversions$.MODULE$.asScalaSet(uniqueKeys).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ImmutableBitSet x$1) {
                return JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)x$1).nonEmpty();
            }
        })).map((Function1)new Serializable(this, rowType){
            public static final long serialVersionUID = 0L;
            public final RelDataType rowType$1;

            /*
             * WARNING - void declaration
             */
            public final HashSet<String> apply(ImmutableBitSet uniqueKey) {
                void var2_2;
                HashSet<E> keys = new HashSet<E>();
                JavaConversions$.MODULE$.asScalaBuffer(uniqueKey.asList()).foreach((Function1)new Serializable(this, keys){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$getUniqueKeys$2 $outer;
                    private final HashSet keys$1;

                    public final boolean apply(Integer idx) {
                        return this.keys$1.add(this.$outer.rowType$1.getFieldNames().get(Predef$.MODULE$.Integer2int(idx)));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.keys$1 = keys$1;
                    }
                });
                return var2_2;
            }
            {
                this.rowType$1 = rowType$1;
            }
        }, Set$.MODULE$.canBuildFrom()));
    }

    public final void org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$propagateTraits$1(RelNode rel, RelNodeBlock block$1) {
        RelNode relNode = rel;
        boolean bl = relNode instanceof StreamPhysicalDataStreamScan ? true : (relNode instanceof StreamPhysicalIntermediateTableScan ? true : (relNode instanceof StreamPhysicalLegacyTableSourceScan ? true : relNode instanceof StreamPhysicalTableSourceScan));
        if (bl) {
            BoxedUnit boxedUnit;
            TableScan scan = (TableScan)rel;
            UpdateKindTrait updateKindTrait = scan.getTraitSet().getTrait(UpdateKindTraitDef$.MODULE$.INSTANCE());
            MiniBatchIntervalTrait miniBatchIntervalTrait = scan.getTraitSet().getTrait(MiniBatchIntervalTraitDef$.MODULE$.INSTANCE());
            String tableName = JavaConversions$.MODULE$.asScalaBuffer(scan.getTable().getQualifiedName()).mkString(".");
            Seq inputBlocks = (Seq)block$1.children().filter((Function1)new Serializable(this, tableName){
                public static final long serialVersionUID = 0L;
                private final String tableName$1;

                public final boolean apply(RelNodeBlock b) {
                    return this.tableName$1.equals(b.getOutputTableName());
                }
                {
                    this.tableName$1 = tableName$1;
                }
            });
            Preconditions.checkArgument((inputBlocks.size() <= 1 ? 1 : 0) != 0);
            if (inputBlocks.size() == 1) {
                RelNodeBlock childBlock = (RelNodeBlock)inputBlocks.head();
                childBlock.setMiniBatchInterval(miniBatchIntervalTrait.getMiniBatchInterval());
                UpdateKind updateKind = updateKindTrait.updateKind();
                UpdateKind updateKind2 = UpdateKind.BEFORE_AND_AFTER;
                boolean requireUB = !(updateKind != null ? !((Object)((Object)updateKind)).equals((Object)updateKind2) : updateKind2 != null);
                childBlock.setUpdateBeforeRequired(requireUB || childBlock.isUpdateBeforeRequired());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (relNode instanceof StreamPhysicalRel) {
            StreamPhysicalRel streamPhysicalRel = (StreamPhysicalRel)relNode;
            JavaConversions$.MODULE$.asScalaBuffer(streamPhysicalRel.getInputs()).foreach((Function1)new Serializable(this, block$1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StreamCommonSubGraphBasedOptimizer $outer;
                private final RelNodeBlock block$1;

                public final void apply(RelNode e) {
                    this.$outer.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$propagateTraits$1(e, this.block$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.block$1 = block$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public StreamCommonSubGraphBasedOptimizer(StreamPlanner planner) {
        this.org$apache$flink$table$planner$plan$optimize$StreamCommonSubGraphBasedOptimizer$$planner = planner;
    }
}

