/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.ImperativeAggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.module.CoreModule;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlAggFunction;
import org.apache.flink.table.planner.functions.utils.AggSqlFunction;
import org.apache.flink.table.planner.plan.nodes.exec.serde.FlinkDeserializationContext;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

public class AggregateCallJsonDeserializer
extends StdDeserializer<AggregateCall> {
    private static final long serialVersionUID = 1L;

    public AggregateCallJsonDeserializer() {
        super(AggregateCall.class);
    }

    public AggregateCall deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException, JsonProcessingException {
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        JsonNode aggFunNode = jsonNode.get("aggFunction");
        SqlAggFunction aggFunction = this.toSqlAggFunction(aggFunNode, ((FlinkDeserializationContext)ctx).getSerdeContext());
        ArrayList<Integer> argList = new ArrayList<Integer>();
        JsonNode argListNode = jsonNode.get("argList");
        for (JsonNode argNode : argListNode) {
            argList.add(argNode.intValue());
        }
        int filterArg = jsonNode.get("filterArg").intValue();
        boolean distinct = jsonNode.get("distinct").asBoolean();
        boolean approximate = jsonNode.get("approximate").asBoolean();
        boolean ignoreNulls = jsonNode.get("ignoreNulls").asBoolean();
        JsonNode typeNode = jsonNode.get("type");
        RelDataType relDataType = (RelDataType)((FlinkDeserializationContext)ctx).getObjectMapper().readValue(typeNode.toPrettyString(), RelDataType.class);
        String name = jsonNode.get("name").asText();
        return AggregateCall.create(aggFunction, distinct, approximate, ignoreNulls, argList, filterArg, RelCollations.EMPTY, relDataType, name);
    }

    private SqlAggFunction toSqlAggFunction(JsonNode jsonNode, SerdeContext ctx) throws IOException {
        String name = jsonNode.get("name").asText();
        SqlKind sqlKind = SqlKind.valueOf(jsonNode.get("kind").asText());
        SqlSyntax sqlSyntax = SqlSyntax.valueOf(jsonNode.get("syntax").asText());
        ArrayList<SqlOperator> operators = new ArrayList<SqlOperator>();
        ctx.getOperatorTable().lookupOperatorOverloads(new SqlIdentifier(name, new SqlParserPos(0, 0)), null, sqlSyntax, operators, SqlNameMatchers.liberal());
        for (SqlOperator operator : operators) {
            if (operator.kind != sqlKind) continue;
            return (SqlAggFunction)operator;
        }
        DataTypeFactory dataTypeFactory = ctx.getFlinkContext().getCatalogManager().getDataTypeFactory();
        if (jsonNode.has("builtIn") && jsonNode.get("builtIn").booleanValue()) {
            Optional<FunctionDefinition> definition = CoreModule.INSTANCE.getFunctionDefinition(name);
            Preconditions.checkArgument((boolean)definition.isPresent());
            TypeInference typeInference = definition.get().getTypeInference(dataTypeFactory);
            return BridgingSqlAggFunction.of(dataTypeFactory, ctx.getTypeFactory(), sqlKind, FunctionIdentifier.of(name), definition.get(), typeInference);
        }
        if (jsonNode.has("functionKind") && jsonNode.has("instance")) {
            FunctionKind functionKind = FunctionKind.valueOf(jsonNode.get("functionKind").asText().toUpperCase());
            String instanceStr = jsonNode.get("instance").asText();
            if (functionKind != FunctionKind.AGGREGATE) {
                throw new TableException("Unknown function kind: " + (Object)((Object)functionKind));
            }
            if (jsonNode.has("bridging") && jsonNode.get("bridging").booleanValue()) {
                FunctionDefinition definition = (FunctionDefinition)EncodingUtils.decodeStringToObject(instanceStr, ctx.getClassLoader());
                TypeInference typeInference = definition.getTypeInference(dataTypeFactory);
                return BridgingSqlAggFunction.of(dataTypeFactory, ctx.getTypeFactory(), sqlKind, FunctionIdentifier.of(name), definition, typeInference);
            }
            String displayName = jsonNode.get("displayName").asText();
            boolean requiresOver = jsonNode.get("requiresOver").booleanValue();
            ImperativeAggregateFunction function = (ImperativeAggregateFunction)EncodingUtils.decodeStringToObject(instanceStr, ctx.getClassLoader());
            return AggSqlFunction.apply(FunctionIdentifier.of(name), displayName, function, TypeConversions.fromLegacyInfoToDataType(UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(function)), TypeConversions.fromLegacyInfoToDataType(UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(function)), ctx.getTypeFactory(), requiresOver);
        }
        throw new TableException("Unknown operator: " + jsonNode.toPrettyString());
    }
}

