/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExpandCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public abstract class CommonExecExpand
extends ExecNodeBase<RowData>
implements SingleTransformationTranslator<RowData> {
    public static final String FIELD_NAME_PROJECTS = "projects";
    @JsonProperty(value="projects")
    private final List<List<RexNode>> projects;
    @JsonIgnore
    private final boolean retainHeader;

    public CommonExecExpand(List<List<RexNode>> projects, boolean retainHeader, int id, List<InputProperty> inputProperties, RowType outputType, String description) {
        super(id, inputProperties, outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.projects = (List)Preconditions.checkNotNull(projects);
        Preconditions.checkArgument((projects.size() > 0 && projects.get(0).size() > 0 && projects.stream().map(List::size).distinct().count() == 1L ? 1 : 0) != 0);
        this.retainHeader = retainHeader;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        CodeGenOperatorFactory<RowData> operatorFactory = ExpandCodeGenerator.generateExpandOperator(new CodeGeneratorContext(planner.getTableConfig()), (RowType)inputEdge.getOutputType(), (RowType)this.getOutputType(), this.projects, this.retainHeader, this.getClass().getSimpleName());
        return new OneInputTransformation(inputTransform, this.getDescription(), operatorFactory, InternalTypeInfo.of(this.getOutputType()), inputTransform.getParallelism());
    }
}

