/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

@JsonTypeName(value="ReadingMetadata")
public class ReadingMetadataSpec
extends SourceAbilitySpecBase {
    public static final String FIELD_NAME_METADATA_KEYS = "metadataKeys";
    @JsonProperty(value="metadataKeys")
    private final List<String> metadataKeys;

    @JsonCreator
    public ReadingMetadataSpec(@JsonProperty(value="metadataKeys") List<String> metadataKeys, @JsonProperty(value="producedType") RowType producedType) {
        super(producedType);
        this.metadataKeys = new ArrayList<String>((Collection)Preconditions.checkNotNull(metadataKeys));
    }

    public List<String> getMetadataKeys() {
        return this.metadataKeys;
    }

    @Override
    public void apply(DynamicTableSource tableSource, SourceAbilityContext context) {
        if (!(tableSource instanceof SupportsReadingMetadata)) {
            throw new TableException(String.format("%s does not support SupportsReadingMetadata.", tableSource.getClass().getName()));
        }
        Preconditions.checkArgument((boolean)this.getProducedType().isPresent());
        DataType producedDataType = TypeConversions.fromLogicalToDataType(this.getProducedType().get());
        ((SupportsReadingMetadata)((Object)tableSource)).applyReadableMetadata(this.metadataKeys, producedDataType);
    }
}

