/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class CollectAggFunction<T>
extends BuiltInAggregateFunction<MapData, CollectAccumulator<T>> {
    private static final long serialVersionUID = -5860934997657147836L;
    private transient DataType elementDataType;

    public CollectAggFunction(LogicalType elementType) {
        this.elementDataType = DataTypeUtils.toInternalDataType(elementType);
    }

    @Override
    public List<DataType> getArgumentDataTypes() {
        return Collections.singletonList(this.elementDataType);
    }

    @Override
    public DataType getAccumulatorDataType() {
        return DataTypes.STRUCTURED(CollectAccumulator.class, DataTypes.FIELD("map", MapView.newMapViewDataType((DataType)this.elementDataType.notNull(), DataTypes.INT())));
    }

    @Override
    public DataType getOutputDataType() {
        return (DataType)DataTypes.MULTISET(this.elementDataType).bridgedTo(MapData.class);
    }

    @Override
    public CollectAccumulator<T> createAccumulator() {
        CollectAccumulator acc = new CollectAccumulator();
        acc.map = new MapView();
        return acc;
    }

    public void resetAccumulator(CollectAccumulator<T> accumulator) {
        accumulator.map.clear();
    }

    public void accumulate(CollectAccumulator<T> accumulator, T value2) throws Exception {
        if (value2 != null) {
            Integer count = accumulator.map.get(value2);
            if (count != null) {
                accumulator.map.put(value2, count + 1);
            } else {
                accumulator.map.put(value2, 1);
            }
        }
    }

    public void retract(CollectAccumulator<T> accumulator, T value2) throws Exception {
        if (value2 != null) {
            Integer count = accumulator.map.get(value2);
            if (count != null) {
                if (count == 1) {
                    accumulator.map.remove(value2);
                } else {
                    accumulator.map.put(value2, count - 1);
                }
            } else {
                accumulator.map.put(value2, -1);
            }
        }
    }

    public void merge(CollectAccumulator<T> accumulator, Iterable<CollectAccumulator<T>> others) throws Exception {
        for (CollectAccumulator<T> other : others) {
            for (Map.Entry entry : other.map.entries()) {
                Object key = entry.getKey();
                Integer newCount = entry.getValue();
                Integer oldCount = accumulator.map.get(key);
                if (oldCount == null) {
                    accumulator.map.put(key, newCount);
                    continue;
                }
                accumulator.map.put(key, oldCount + newCount);
            }
        }
    }

    @Override
    public MapData getValue(CollectAccumulator<T> accumulator) {
        return new GenericMapData(accumulator.map.getMap());
    }

    public static class CollectAccumulator<T> {
        public MapView<T, Integer> map;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectAccumulator that = (CollectAccumulator)o;
            return Objects.equals(this.map, that.map);
        }
    }
}

