/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter.converters;

import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.expressions.converter.converters.CustomizedConverter;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;

class TemporalOverlapsConverter
extends CustomizedConverter {
    TemporalOverlapsConverter() {
    }

    @Override
    public RexNode convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        TemporalOverlapsConverter.checkArgumentNumber(call, 4);
        List<RexNode> childrenRexNode = ExpressionConverter.toRexNodes(context, call.getChildren());
        RexNode leftTimePoint = childrenRexNode.get(0);
        RexNode leftTemporal = childrenRexNode.get(1);
        RexNode rightTimePoint = childrenRexNode.get(2);
        RexNode rightTemporal = childrenRexNode.get(3);
        RexNode convLeftT = TypeCheckUtils.isTimeInterval(FlinkTypeFactory.toLogicalType(leftTemporal.getType())) ? context.getRelBuilder().call(FlinkSqlOperatorTable.DATETIME_PLUS, leftTimePoint, leftTemporal) : leftTemporal;
        RexNode leftLe = context.getRelBuilder().call(FlinkSqlOperatorTable.LESS_THAN_OR_EQUAL, leftTimePoint, convLeftT);
        RexNode s0 = context.getRelBuilder().call(FlinkSqlOperatorTable.CASE, leftLe, leftTimePoint, convLeftT);
        RexNode e0 = context.getRelBuilder().call(FlinkSqlOperatorTable.CASE, leftLe, convLeftT, leftTimePoint);
        RexNode convRightT = TypeCheckUtils.isTimeInterval(FlinkTypeFactory.toLogicalType(rightTemporal.getType())) ? context.getRelBuilder().call(FlinkSqlOperatorTable.DATETIME_PLUS, rightTimePoint, rightTemporal) : rightTemporal;
        RexNode rightLe = context.getRelBuilder().call(FlinkSqlOperatorTable.LESS_THAN_OR_EQUAL, rightTimePoint, convRightT);
        RexNode s1 = context.getRelBuilder().call(FlinkSqlOperatorTable.CASE, rightLe, rightTimePoint, convRightT);
        RexNode e1 = context.getRelBuilder().call(FlinkSqlOperatorTable.CASE, rightLe, convRightT, rightTimePoint);
        RexNode leftPred = context.getRelBuilder().call(FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL, e0, s1);
        RexNode rightPred = context.getRelBuilder().call(FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL, e1, s0);
        return context.getRelBuilder().call(FlinkSqlOperatorTable.AND, leftPred, rightPred);
    }
}

