/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.filesystem.FileSystemConnectorOptions;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.TableSchemaUtils;

abstract class AbstractFileSystemTable {
    final DynamicTableFactory.Context context;
    final ObjectIdentifier tableIdentifier;
    final Configuration tableOptions;
    final TableSchema schema;
    final List<String> partitionKeys;
    final Path path;
    final String defaultPartName;

    AbstractFileSystemTable(DynamicTableFactory.Context context) {
        this.context = context;
        this.tableIdentifier = context.getObjectIdentifier();
        this.tableOptions = new Configuration();
        context.getCatalogTable().getOptions().forEach((arg_0, arg_1) -> ((Configuration)this.tableOptions).setString(arg_0, arg_1));
        this.schema = TableSchemaUtils.getPhysicalSchema(context.getCatalogTable().getSchema());
        this.partitionKeys = context.getCatalogTable().getPartitionKeys();
        this.path = new Path((String)this.tableOptions.get(FileSystemConnectorOptions.PATH));
        this.defaultPartName = (String)this.tableOptions.get(FileSystemConnectorOptions.PARTITION_DEFAULT_NAME);
    }

    ReadableConfig formatOptions(String identifier) {
        return new DelegatingConfiguration(this.tableOptions, identifier + ".");
    }

    DataType getFormatDataType() {
        TableSchema.Builder builder = TableSchema.builder();
        this.schema.getTableColumns().forEach(column -> {
            if (!this.partitionKeys.contains(column.getName())) {
                builder.add((TableColumn)column);
            }
        });
        return builder.build().toRowDataType();
    }
}

