/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.RuleExpressionVisitor;

@Internal
final class StarReferenceFlatteningRule
implements ResolverRule {
    StarReferenceFlatteningRule() {
    }

    @Override
    public List<Expression> apply(List<Expression> expression2, ResolverRule.ResolutionContext context) {
        return expression2.stream().flatMap(expr -> expr.accept(new FieldFlatteningVisitor(context)).stream()).collect(Collectors.toList());
    }

    private static class FieldFlatteningVisitor
    extends RuleExpressionVisitor<List<Expression>> {
        FieldFlatteningVisitor(ResolverRule.ResolutionContext resolutionContext) {
            super(resolutionContext);
        }

        @Override
        public List<Expression> visit(UnresolvedReferenceExpression unresolvedReference) {
            if (unresolvedReference.getName().equals("*")) {
                return new ArrayList<Expression>(this.resolutionContext.referenceLookup().getAllInputFields());
            }
            return Collections.singletonList(unresolvedReference);
        }

        @Override
        public List<Expression> visit(UnresolvedCallExpression unresolvedCall) {
            List<Expression> newArgs = unresolvedCall.getChildren().stream().flatMap(e -> e.accept(this).stream()).collect(Collectors.toList());
            return Collections.singletonList(unresolvedCall.replaceArgs(newArgs));
        }

        @Override
        protected List<Expression> defaultMethod(Expression expression2) {
            return Collections.singletonList(expression2);
        }
    }
}

