/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.vector.heap;

import java.util.Arrays;
import org.apache.flink.table.data.vector.BytesColumnVector;
import org.apache.flink.table.data.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.vector.writable.WritableBytesVector;

public class HeapBytesVector
extends AbstractHeapVector
implements WritableBytesVector {
    private static final long serialVersionUID = -8529155738773478597L;
    public int[] start;
    public int[] length;
    public byte[] buffer;
    private int elementsAppended = 0;
    private int capacity;

    public HeapBytesVector(int size) {
        super(size);
        this.capacity = size;
        this.buffer = new byte[this.capacity];
        this.start = new int[size];
        this.length = new int[size];
    }

    @Override
    public void reset() {
        super.reset();
        this.elementsAppended = 0;
    }

    @Override
    public void appendBytes(int elementNum, byte[] sourceBuf, int start, int length) {
        this.reserve(this.elementsAppended + length);
        System.arraycopy(sourceBuf, start, this.buffer, this.elementsAppended, length);
        this.start[elementNum] = this.elementsAppended;
        this.length[elementNum] = length;
        this.elementsAppended += length;
    }

    @Override
    public void fill(byte[] value2) {
        int i;
        this.reserve(this.start.length * value2.length);
        for (i = 0; i < this.start.length; ++i) {
            System.arraycopy(value2, 0, this.buffer, i * value2.length, value2.length);
        }
        for (i = 0; i < this.start.length; ++i) {
            this.start[i] = i * value2.length;
        }
        Arrays.fill(this.length, value2.length);
    }

    private void reserve(int requiredCapacity) {
        if (requiredCapacity > this.capacity) {
            int newCapacity = requiredCapacity * 2;
            try {
                byte[] newData = new byte[newCapacity];
                System.arraycopy(this.buffer, 0, newData, 0, this.elementsAppended);
                this.buffer = newData;
                this.capacity = newCapacity;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new UnsupportedOperationException(requiredCapacity + " cannot be satisfied.", outOfMemoryError);
            }
        }
    }

    @Override
    public BytesColumnVector.Bytes getBytes(int i) {
        if (this.dictionary == null) {
            return new BytesColumnVector.Bytes(this.buffer, this.start[i], this.length[i]);
        }
        byte[] bytes = this.dictionary.decodeToBinary(this.dictionaryIds.vector[i]);
        return new BytesColumnVector.Bytes(bytes, 0, bytes.length);
    }
}

