/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.codesplit;

import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.codesplit.DeclarationRewriter;
import org.apache.flink.table.codesplit.FunctionSplitter;
import org.apache.flink.table.codesplit.IfStatementRewriter;
import org.apache.flink.table.codesplit.MemberFieldRewriter;
import org.apache.flink.table.codesplit.ReturnValueRewriter;
import org.apache.flink.util.Preconditions;

@Internal
public class JavaCodeSplitter {
    public static String split(String code, int maxMethodLength, int maxClassMemberCount) {
        try {
            return JavaCodeSplitter.splitImpl(code, maxMethodLength, maxClassMemberCount);
        }
        catch (Throwable t) {
            System.out.println(code);
            throw new RuntimeException("JavaCodeSplitter failed. This is a bug. Please file an issue.", t);
        }
    }

    private static String splitImpl(String code, int maxMethodLength, int maxClassMemberCount) {
        Preconditions.checkArgument((code != null && !code.isEmpty() ? 1 : 0) != 0, (Object)"code cannot be empty");
        Preconditions.checkArgument((maxMethodLength > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxClassMemberCount > 0 ? 1 : 0) != 0);
        String returnValueRewrittenCode = new ReturnValueRewriter(code, maxMethodLength).rewrite();
        return Optional.ofNullable(new DeclarationRewriter(returnValueRewrittenCode, maxMethodLength).rewrite()).map(text -> new IfStatementRewriter((String)text, maxMethodLength).rewrite()).map(text -> new FunctionSplitter((String)text, maxMethodLength).rewrite()).map(text -> new MemberFieldRewriter((String)text, maxClassMemberCount).rewrite()).orElse(code);
    }
}

