/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

public class OutputFileConfig
implements Serializable {
    private final String partPrefix;
    private final String partSuffix;

    public OutputFileConfig(String partPrefix, String partSuffix) {
        this.partPrefix = (String)Preconditions.checkNotNull((Object)partPrefix);
        this.partSuffix = (String)Preconditions.checkNotNull((Object)partSuffix);
    }

    public String getPartPrefix() {
        return this.partPrefix;
    }

    public String getPartSuffix() {
        return this.partSuffix;
    }

    public static OutputFileConfigBuilder builder() {
        return new OutputFileConfigBuilder();
    }

    @PublicEvolving
    public static class OutputFileConfigBuilder {
        private static final String DEFAULT_PART_PREFIX = "part";
        private static final String DEFAULT_PART_SUFFIX = "";
        private String partPrefix = "part";
        private String partSuffix = "";

        private OutputFileConfigBuilder() {
        }

        public OutputFileConfigBuilder withPartPrefix(String prefix) {
            this.partPrefix = prefix;
            return this;
        }

        public OutputFileConfigBuilder withPartSuffix(String suffix) {
            this.partSuffix = suffix;
            return this;
        }

        public OutputFileConfig build() {
            return new OutputFileConfig(this.partPrefix, this.partSuffix);
        }
    }
}

