/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.Lockable;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferAccessor;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferEdge;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferNode;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferNodeSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterables;
import org.apache.flink.util.WrappingRuntimeException;

public class SharedBuffer<V> {
    private static final String legacyEntriesStateName = "sharedBuffer-entries";
    private static final String entriesStateName = "sharedBuffer-entries-with-lockable-edges";
    private static final String eventsStateName = "sharedBuffer-events";
    private static final String eventsCountStateName = "sharedBuffer-events-count";
    private final MapState<EventId, Lockable<V>> eventsBuffer;
    private final MapState<Long, Integer> eventsCount;
    private final MapState<NodeId, Lockable<SharedBufferNode>> entries;
    private final Map<EventId, Lockable<V>> eventsBufferCache = new HashMap<EventId, Lockable<V>>();
    private final Map<NodeId, Lockable<SharedBufferNode>> entryCache = new HashMap<NodeId, Lockable<SharedBufferNode>>();

    public SharedBuffer(KeyedStateStore stateStore, TypeSerializer<V> valueSerializer) {
        this.eventsBuffer = stateStore.getMapState(new MapStateDescriptor(eventsStateName, (TypeSerializer)EventId.EventIdSerializer.INSTANCE, new Lockable.LockableTypeSerializer<V>(valueSerializer)));
        this.entries = stateStore.getMapState(new MapStateDescriptor(entriesStateName, (TypeSerializer)new NodeId.NodeIdSerializer(), new Lockable.LockableTypeSerializer(new SharedBufferNodeSerializer())));
        this.eventsCount = stateStore.getMapState(new MapStateDescriptor(eventsCountStateName, (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)IntSerializer.INSTANCE));
    }

    public void migrateOldState(KeyedStateBackend<?> stateBackend, ValueState<NFAState> computationStates) throws Exception {
        stateBackend.applyToAllKeys((Object)VoidNamespace.INSTANCE, (TypeSerializer)VoidNamespaceSerializer.INSTANCE, (StateDescriptor)new MapStateDescriptor(legacyEntriesStateName, (TypeSerializer)new NodeId.NodeIdSerializer(), new Lockable.LockableTypeSerializer(new SharedBufferNode.SharedBufferNodeSerializer())), (key, state) -> {
            this.copyEntries((MapState<NodeId, Lockable<SharedBufferNode>>)state);
            state.entries().forEach(this::lockPredecessorEdges);
            state.clear();
            NFAState nfaState = (NFAState)computationStates.value();
            nfaState.getPartialMatches().forEach(computationState -> this.lockEdges(computationState.getPreviousBufferEntry(), computationState.getVersion()));
            nfaState.getCompletedMatches().forEach(computationState -> this.lockEdges(computationState.getPreviousBufferEntry(), computationState.getVersion()));
        });
    }

    private void copyEntries(MapState<NodeId, Lockable<SharedBufferNode>> state) throws Exception {
        state.entries().forEach(e -> {
            try {
                this.entries.put(e.getKey(), e.getValue());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private void lockPredecessorEdges(Map.Entry<NodeId, Lockable<SharedBufferNode>> e) {
        SharedBufferNode oldNode = e.getValue().getElement();
        oldNode.getEdges().forEach(edge -> {
            SharedBufferEdge oldEdge = (SharedBufferEdge)edge.getElement();
            this.lockEdges(oldEdge.getTarget(), oldEdge.getDeweyNumber());
        });
    }

    private void lockEdges(NodeId nodeId, DeweyNumber version) {
        if (nodeId == null) {
            return;
        }
        try {
            SharedBufferNode newNode = (SharedBufferNode)((Lockable)this.entries.get((Object)nodeId)).getElement();
            newNode.getEdges().forEach(newEdge -> {
                if (version.isCompatibleWith(((SharedBufferEdge)newEdge.getElement()).getDeweyNumber())) {
                    newEdge.lock();
                }
            });
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public SharedBufferAccessor<V> getAccessor() {
        return new SharedBufferAccessor(this);
    }

    void advanceTime(long timestamp) throws Exception {
        Iterator iterator = this.eventsCount.keys().iterator();
        while (iterator.hasNext()) {
            Long next = (Long)iterator.next();
            if (next >= timestamp) continue;
            iterator.remove();
        }
    }

    EventId registerEvent(V value2, long timestamp) throws Exception {
        Integer id = (Integer)this.eventsCount.get((Object)timestamp);
        if (id == null) {
            id = 0;
        }
        EventId eventId = new EventId(id, timestamp);
        Lockable<V> lockableValue = new Lockable<V>(value2, 1);
        this.eventsCount.put((Object)timestamp, (Object)(id + 1));
        this.eventsBufferCache.put(eventId, lockableValue);
        return eventId;
    }

    public boolean isEmpty() throws Exception {
        return Iterables.isEmpty(this.eventsBufferCache.keySet()) && Iterables.isEmpty((Iterable)this.eventsBuffer.keys());
    }

    void upsertEvent(EventId eventId, Lockable<V> event) {
        this.eventsBufferCache.put(eventId, event);
    }

    void upsertEntry(NodeId nodeId, Lockable<SharedBufferNode> entry) {
        this.entryCache.put(nodeId, entry);
    }

    void removeEvent(EventId eventId) throws Exception {
        this.eventsBufferCache.remove(eventId);
        this.eventsBuffer.remove((Object)eventId);
    }

    void removeEntry(NodeId nodeId) throws Exception {
        this.entryCache.remove(nodeId);
        this.entries.remove((Object)nodeId);
    }

    Lockable<SharedBufferNode> getEntry(NodeId nodeId) {
        return this.entryCache.computeIfAbsent(nodeId, id -> {
            try {
                return (Lockable)this.entries.get(id);
            }
            catch (Exception ex) {
                throw new WrappingRuntimeException((Throwable)ex);
            }
        });
    }

    Lockable<V> getEvent(EventId eventId) {
        return this.eventsBufferCache.computeIfAbsent(eventId, id -> {
            try {
                return (Lockable)this.eventsBuffer.get(id);
            }
            catch (Exception ex) {
                throw new WrappingRuntimeException((Throwable)ex);
            }
        });
    }

    void flushCache() throws Exception {
        if (!this.entryCache.isEmpty()) {
            this.entries.putAll(this.entryCache);
            this.entryCache.clear();
        }
        if (!this.eventsBufferCache.isEmpty()) {
            this.eventsBuffer.putAll(this.eventsBufferCache);
            this.eventsBufferCache.clear();
        }
    }

    @VisibleForTesting
    Iterator<Map.Entry<Long, Integer>> getEventCounters() throws Exception {
        return this.eventsCount.iterator();
    }

    @VisibleForTesting
    public int getEventsBufferCacheSize() {
        return this.eventsBufferCache.size();
    }

    @VisibleForTesting
    public int getEventsBufferSize() throws Exception {
        return Iterables.size((Iterable)this.eventsBuffer.entries());
    }

    @VisibleForTesting
    public int getSharedBufferNodeSize() throws Exception {
        return Iterables.size((Iterable)this.entries.entries());
    }

    @VisibleForTesting
    public int getSharedBufferNodeCacheSize() throws Exception {
        return this.entryCache.size();
    }
}

