/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import java.math.BigDecimal;
import org.apache.calcite.DataContext;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.runtime.GeoFunctions;
import org.apache.calcite.runtime.Geometries;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class SqlGeoFunctions {
    private SqlGeoFunctions() {
    }

    public static ScannableTable ST_MakeGrid(Geometries.Geom geom, BigDecimal deltaX, BigDecimal deltaY) {
        return new GridTable(geom, deltaX, deltaY, false);
    }

    public static ScannableTable ST_MakeGridPoints(Geometries.Geom geom, BigDecimal deltaX, BigDecimal deltaY) {
        return new GridTable(geom, deltaX, deltaY, true);
    }

    public static class GridTable
    implements ScannableTable {
        private final Geometries.Geom geom;
        private final BigDecimal deltaX;
        private final BigDecimal deltaY;
        private boolean point;

        GridTable(Geometries.Geom geom, BigDecimal deltaX, BigDecimal deltaY, boolean point) {
            this.geom = geom;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
            this.point = point;
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return typeFactory.builder().add("THE_GEOM", SqlTypeName.GEOMETRY).add("ID", SqlTypeName.INTEGER).add("ID_COL", SqlTypeName.INTEGER).add("ID_ROW", SqlTypeName.INTEGER).add("ABS_COL", SqlTypeName.INTEGER).add("ABS_ROW", SqlTypeName.INTEGER).build();
        }

        @Override
        public Enumerable<Object[]> scan(DataContext root2) {
            if (this.geom != null && this.deltaX != null && this.deltaY != null) {
                Geometry geometry = this.geom.g();
                Envelope envelope = new Envelope();
                geometry.queryEnvelope(envelope);
                if (this.deltaX.compareTo(BigDecimal.ZERO) > 0 && this.deltaY.compareTo(BigDecimal.ZERO) > 0) {
                    return new GeoFunctions.GridEnumerable(envelope, this.deltaX, this.deltaY, this.point);
                }
            }
            return Linq4j.emptyEnumerable();
        }

        @Override
        public Statistic getStatistic() {
            return Statistics.of(100.0, ImmutableList.of(ImmutableBitSet.of(0, 1)));
        }

        @Override
        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.OTHER;
        }

        @Override
        public boolean isRolledUp(String column) {
            return false;
        }

        @Override
        public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
            return false;
        }
    }
}

