/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.interpreter.AbstractSingleNode;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.rel.core.Uncollect;

public class UncollectNode
extends AbstractSingleNode<Uncollect> {
    public UncollectNode(Compiler compiler, Uncollect uncollect) {
        super(compiler, uncollect);
    }

    @Override
    public void run() throws InterruptedException {
        Row row = null;
        while ((row = this.source.receive()) != null) {
            for (Object value2 : row.getValues()) {
                if (value2 == null) {
                    throw new NullPointerException("NULL value for unnest.");
                }
                int i = 1;
                if (value2 instanceof List) {
                    List list = (List)value2;
                    for (Object o : list) {
                        if (((Uncollect)this.rel).withOrdinality) {
                            this.sink.send(Row.of(o, (Object)i++));
                            continue;
                        }
                        this.sink.send(Row.of(o));
                    }
                    continue;
                }
                if (value2 instanceof Map) {
                    Map map2 = (Map)value2;
                    for (Object key : map2.keySet()) {
                        if (((Uncollect)this.rel).withOrdinality) {
                            this.sink.send(Row.of(key, map2.get(key), (Object)i++));
                            continue;
                        }
                        this.sink.send(Row.of(key, map2.get(key)));
                    }
                    continue;
                }
                throw new UnsupportedOperationException(String.format(Locale.ROOT, "Invalid type: %s for unnest.", value2.getClass().getCanonicalName()));
            }
        }
    }
}

