/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliOptions;
import org.apache.flink.table.client.config.Environment;
import org.apache.flink.table.client.config.entries.ConfigurationEntry;
import org.apache.flink.table.client.gateway.context.DefaultContext;
import org.apache.flink.table.client.gateway.context.SessionContext;
import org.apache.flink.util.JarUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalContextUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LocalContextUtils.class);
    private static final String DEFAULT_ENV_FILE = "sql-client-defaults.yaml";
    private static final String DEFAULT_SESSION_ID = "default";

    public static DefaultContext buildDefaultContext(CliOptions options) {
        List<URL> jars = options.getJars() != null ? options.getJars() : Collections.emptyList();
        List<URL> libDirs = options.getLibraryDirs() != null ? options.getLibraryDirs() : Collections.emptyList();
        String flinkConfigDir = CliFrontend.getConfigurationDirectoryFromEnv();
        Configuration configuration = GlobalConfiguration.loadConfiguration((String)flinkConfigDir);
        List commandLines = CliFrontend.loadCustomCommandLines((Configuration)configuration, (String)flinkConfigDir);
        Environment defaultEnvironment = LocalContextUtils.getLocalDefaultEnvironment(flinkConfigDir, options.getDefaults());
        Environment sessionEnvironment = LocalContextUtils.getSessionEnvironment(defaultEnvironment, options.getEnvironment());
        LocalContextUtils.appendPythonConfig(sessionEnvironment, options.getPythonConfiguration());
        List<URL> dependencies = LocalContextUtils.discoverDependencies(jars, libDirs);
        return new DefaultContext(sessionEnvironment, dependencies, configuration, commandLines);
    }

    public static SessionContext buildSessionContext(@Nullable String sessionId, DefaultContext defaultContext) {
        SessionContext context = sessionId == null ? SessionContext.create(defaultContext, DEFAULT_SESSION_ID) : SessionContext.create(defaultContext, sessionId);
        return context;
    }

    private static Environment getLocalDefaultEnvironment(String flinkConfigDir, @Nullable URL defaultUrl) {
        Environment defaultEnvironment;
        URL defaultEnv = null;
        if (defaultUrl == null) {
            String defaultFilePath = flinkConfigDir + "/" + DEFAULT_ENV_FILE;
            System.out.println("No default environment specified.");
            System.out.print("Searching for '" + defaultFilePath + "'...");
            File file = new File(defaultFilePath);
            if (file.exists()) {
                System.out.println("found.");
                try {
                    defaultEnv = Path.fromLocalFile((File)file).toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new SqlClientException(e);
                }
                LOG.info("Using default environment file: {}", (Object)defaultEnv);
            } else {
                System.out.println("not found.");
            }
        }
        if (defaultEnv != null) {
            System.out.println("Reading default environment from: " + defaultEnv);
            try {
                defaultEnvironment = Environment.parse(defaultEnv);
            }
            catch (IOException e) {
                throw new SqlClientException("Could not read default environment file at: " + defaultEnv, e);
            }
        } else {
            defaultEnvironment = new Environment();
        }
        return defaultEnvironment;
    }

    private static Environment getSessionEnvironment(Environment defaultEnvironment, @Nullable URL sessionEnvironmentURL) {
        if (sessionEnvironmentURL == null) {
            return defaultEnvironment;
        }
        Environment sessionEnvironment = LocalContextUtils.readSessionEnvironment(sessionEnvironmentURL);
        return Environment.merge(defaultEnvironment, sessionEnvironment);
    }

    private static List<URL> discoverDependencies(List<URL> jars, List<URL> libraries) {
        ArrayList<URL> dependencies = new ArrayList<URL>();
        try {
            for (URL url : jars) {
                JarUtils.checkJarFile((URL)url);
                dependencies.add(url);
            }
            for (URL libUrl : libraries) {
                File dir = new File(libUrl.toURI());
                if (!dir.isDirectory()) {
                    throw new SqlClientException("Directory expected: " + dir);
                }
                if (!dir.canRead()) {
                    throw new SqlClientException("Directory cannot be read: " + dir);
                }
                File[] files = dir.listFiles();
                if (files == null) {
                    throw new SqlClientException("Directory cannot be read: " + dir);
                }
                for (File f : files) {
                    if (!f.isFile() || !f.getAbsolutePath().toLowerCase().endsWith(".jar")) continue;
                    URL url = f.toURI().toURL();
                    JarUtils.checkJarFile((URL)url);
                    dependencies.add(url);
                }
            }
        }
        catch (Exception e) {
            throw new SqlClientException("Could not load all required JAR files.", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using the following dependencies: {}", dependencies);
        }
        return dependencies;
    }

    private static Environment readSessionEnvironment(@Nullable URL envUrl) {
        if (envUrl == null) {
            System.out.println("No session environment specified.");
            return new Environment();
        }
        System.out.println("Reading session environment from: " + envUrl);
        LOG.info("Using session environment file: {}", (Object)envUrl);
        try {
            return Environment.parse(envUrl);
        }
        catch (IOException e) {
            throw new SqlClientException("Could not read session environment file at: " + envUrl, e);
        }
    }

    private static void appendPythonConfig(Environment env, Configuration pythonConfiguration) {
        HashMap<String, Object> pythonConfig = new HashMap<String, Object>(pythonConfiguration.toMap());
        HashMap<String, Object> combinedConfig = new HashMap<String, Object>(ConfigurationEntry.merge(env.getConfiguration(), ConfigurationEntry.create(pythonConfig)).asMap());
        env.setConfiguration(combinedConfig);
    }
}

