/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.context;

import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.client.config.YamlConfigUtils;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.context.DefaultContext;
import org.apache.flink.table.client.gateway.context.ExecutionContext;
import org.apache.flink.table.client.gateway.context.LegacyTableEnvironmentInitializer;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionContext {
    private static final Logger LOG = LoggerFactory.getLogger(SessionContext.class);
    private final String sessionId;
    private final DefaultContext defaultContext;
    private final Configuration sessionConfiguration;
    private final SessionState sessionState;
    private final URLClassLoader classLoader;
    private ExecutionContext executionContext;

    private SessionContext(DefaultContext defaultContext, String sessionId, Configuration sessionConfiguration, URLClassLoader classLoader, SessionState sessionState, ExecutionContext executionContext) {
        this.defaultContext = defaultContext;
        this.sessionId = sessionId;
        this.sessionConfiguration = sessionConfiguration;
        this.classLoader = classLoader;
        this.sessionState = sessionState;
        this.executionContext = executionContext;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public ReadableConfig getReadableConfig() {
        return this.sessionConfiguration;
    }

    public Map<String, String> getConfigMap() {
        return this.sessionConfiguration.toMap();
    }

    public void reset() {
        this.resetSessionConfigurationToDefault(this.defaultContext.getFlinkConfig());
        this.executionContext = new ExecutionContext(this.executionContext);
    }

    public void reset(String key) {
        Configuration configuration = this.defaultContext.getFlinkConfig();
        if (configuration.containsKey(key)) {
            String defaultValue = (String)configuration.get(ConfigOptions.key((String)key).stringType().noDefaultValue());
            this.set(key, defaultValue);
        } else {
            ConfigOption keyToDelete = ConfigOptions.key((String)key).stringType().noDefaultValue();
            this.sessionConfiguration.removeConfig(keyToDelete);
            if (YamlConfigUtils.isDeprecatedKey(key)) {
                String optionKey = YamlConfigUtils.getOptionNameWithDeprecatedKey(key);
                this.sessionConfiguration.removeConfig(ConfigOptions.key((String)optionKey).stringType().noDefaultValue());
            } else if (YamlConfigUtils.isOptionHasDeprecatedKey(key)) {
                String deprecatedKey = YamlConfigUtils.getDeprecatedNameWithOptionKey(key);
                this.sessionConfiguration.removeConfig(ConfigOptions.key((String)deprecatedKey).stringType().noDefaultValue());
            }
            this.executionContext = new ExecutionContext(this.executionContext);
        }
    }

    public void set(String key, String value) {
        Configuration originConfiguration = this.sessionConfiguration.clone();
        YamlConfigUtils.setKeyToConfiguration(this.sessionConfiguration, key, value);
        try {
            ExecutionContext newContext;
            this.executionContext = newContext = new ExecutionContext(this.executionContext);
        }
        catch (Exception e) {
            this.resetSessionConfigurationToDefault(originConfiguration);
            throw new SqlExecutionException(String.format("Failed to set key %s with value %s.", key, value), e);
        }
    }

    public void close() {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of((ClassLoader)this.classLoader);){
            for (String name : this.sessionState.catalogManager.listCatalogs()) {
                this.sessionState.catalogManager.getCatalog(name).ifPresent(Catalog::close);
            }
        }
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            LOG.debug("Error while closing class loader.", (Throwable)e);
        }
    }

    public static SessionContext create(DefaultContext defaultContext, String sessionId) {
        Configuration configuration = defaultContext.getFlinkConfig().clone();
        URLClassLoader classLoader = ClientUtils.buildUserCodeClassLoader(defaultContext.getDependencies(), Collections.emptyList(), (ClassLoader)SessionContext.class.getClassLoader(), (Configuration)configuration);
        ModuleManager moduleManager = new ModuleManager();
        EnvironmentSettings settings = EnvironmentSettings.fromConfiguration((Configuration)configuration);
        CatalogManager catalogManager = CatalogManager.newBuilder().classLoader((ClassLoader)classLoader).config((ReadableConfig)configuration).defaultCatalog(settings.getBuiltInCatalogName(), (Catalog)new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName())).build();
        FunctionCatalog functionCatalog = new FunctionCatalog((ReadableConfig)configuration, catalogManager, moduleManager);
        SessionState sessionState = new SessionState(catalogManager, moduleManager, functionCatalog);
        ExecutionContext executionContext = new ExecutionContext(configuration, classLoader, sessionState);
        LegacyTableEnvironmentInitializer.initializeSessionState(executionContext.getTableEnvironment(), defaultContext.getDefaultEnv(), classLoader);
        return new SessionContext(defaultContext, sessionId, configuration, classLoader, sessionState, executionContext);
    }

    private void resetSessionConfigurationToDefault(Configuration defaultConf) {
        for (String key : this.sessionConfiguration.toMap().keySet()) {
            ConfigOption keyToDelete = ConfigOptions.key((String)key).stringType().noDefaultValue();
            this.sessionConfiguration.removeConfig(keyToDelete);
        }
        this.sessionConfiguration.addAll(defaultConf);
    }

    public static class SessionState {
        public final CatalogManager catalogManager;
        public final FunctionCatalog functionCatalog;
        public final ModuleManager moduleManager;

        public SessionState(CatalogManager catalogManager, ModuleManager moduleManager, FunctionCatalog functionCatalog) {
            this.catalogManager = catalogManager;
            this.moduleManager = moduleManager;
            this.functionCatalog = functionCatalog;
        }
    }
}

