/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.client.config.SqlClientOptions;
import org.apache.flink.table.client.config.entries.ExecutionEntry;

@Deprecated
public class YamlConfigUtils {
    static final Map<String, String> ENTRY_TO_OPTION = new HashMap<String, String>();
    static final Map<String, String> OPTION_TO_ENTRY = new HashMap<String, String>();
    static final Set<String> REMOVED_ENTRY = new HashSet<String>();

    public static boolean isRemovedKey(String key) {
        return REMOVED_ENTRY.contains(key);
    }

    public static boolean isDeprecatedKey(String key) {
        return ENTRY_TO_OPTION.containsKey(key);
    }

    public static String getOptionNameWithDeprecatedKey(String key) {
        return ENTRY_TO_OPTION.get(key);
    }

    public static boolean isOptionHasDeprecatedKey(String key) {
        return OPTION_TO_ENTRY.containsKey(key);
    }

    public static String getDeprecatedNameWithOptionKey(String key) {
        return OPTION_TO_ENTRY.get(key);
    }

    public static void setKeyToConfiguration(Configuration configuration, String key, String value) {
        if (YamlConfigUtils.isRemovedKey(key)) {
            return;
        }
        configuration.setString(key, value);
        if (ENTRY_TO_OPTION.containsKey(key)) {
            configuration.setString(ENTRY_TO_OPTION.get(key), value);
        } else if (OPTION_TO_ENTRY.containsKey(key) && configuration.containsKey(OPTION_TO_ENTRY.get(key))) {
            configuration.setString(OPTION_TO_ENTRY.get(key), value);
        }
    }

    public static Configuration convertExecutionEntryToConfiguration(ExecutionEntry execution) {
        Configuration configuration = new Configuration();
        Map executionEntry = execution.asMap();
        for (Map.Entry entry : executionEntry.entrySet()) {
            String key = String.format("%s.%s", "execution", entry.getKey());
            if (YamlConfigUtils.isRemovedKey(key)) continue;
            configuration.setString(key, (String)entry.getValue());
            configuration.setString(ENTRY_TO_OPTION.get(key), (String)entry.getValue());
        }
        YamlConfigUtils.setRestartStrategy(execution, configuration);
        return configuration;
    }

    public static List<String> getPropertiesInPretty(Map<String, String> properties) {
        ArrayList<String> prettyConfigOptions = new ArrayList<String>();
        for (String key : properties.keySet()) {
            if (YamlConfigUtils.isRemovedKey(key) || YamlConfigUtils.isDeprecatedKey(key)) continue;
            prettyConfigOptions.add(String.format("%s=%s", key, properties.get(key)));
        }
        prettyConfigOptions.sort(String::compareTo);
        ArrayList<String> prettyEntries = new ArrayList<String>();
        for (String key : properties.keySet()) {
            if (!YamlConfigUtils.isDeprecatedKey(key)) continue;
            prettyEntries.add(String.format("[DEPRECATED] %s=%s", key, properties.get(key)));
        }
        prettyEntries.sort(String::compareTo);
        prettyConfigOptions.addAll(prettyEntries);
        return prettyConfigOptions;
    }

    private static void setRestartStrategy(ExecutionEntry execution, Configuration configuration) {
        RestartStrategies.RestartStrategyConfiguration restartStrategy = execution.getRestartStrategy();
        if (restartStrategy instanceof RestartStrategies.NoRestartStrategyConfiguration) {
            configuration.setString(OPTION_TO_ENTRY.get(RestartStrategyOptions.RESTART_STRATEGY.key()), "none");
            configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"none");
        } else if (restartStrategy instanceof RestartStrategies.FixedDelayRestartStrategyConfiguration) {
            configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"fixed-delay");
            RestartStrategies.FixedDelayRestartStrategyConfiguration fixedDelay = (RestartStrategies.FixedDelayRestartStrategyConfiguration)restartStrategy;
            configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, (Object)fixedDelay.getRestartAttempts());
            configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)Duration.ofMillis(fixedDelay.getDelayBetweenAttemptsInterval().toMilliseconds()));
            configuration.setString(OPTION_TO_ENTRY.get(RestartStrategyOptions.RESTART_STRATEGY.key()), "fixed-delay");
        } else if (restartStrategy instanceof RestartStrategies.FailureRateRestartStrategyConfiguration) {
            configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"failure-rate");
            RestartStrategies.FailureRateRestartStrategyConfiguration failureRate = (RestartStrategies.FailureRateRestartStrategyConfiguration)restartStrategy;
            configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_MAX_FAILURES_PER_INTERVAL, (Object)failureRate.getMaxFailureRate());
            configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_FAILURE_RATE_INTERVAL, (Object)Duration.ofMillis(failureRate.getFailureInterval().toMilliseconds()));
            configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_DELAY, (Object)Duration.ofMillis(failureRate.getDelayBetweenAttemptsInterval().toMilliseconds()));
            configuration.setString(OPTION_TO_ENTRY.get(RestartStrategyOptions.RESTART_STRATEGY.key()), "failure-rate");
        } else if (restartStrategy instanceof RestartStrategies.FallbackRestartStrategyConfiguration) {
            configuration.removeConfig(RestartStrategyOptions.RESTART_STRATEGY);
        }
    }

    static {
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "type"), ExecutionOptions.RUNTIME_MODE.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "planner"), TableConfigOptions.TABLE_PLANNER.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "periodic-watermarks-interval"), PipelineOptions.AUTO_WATERMARK_INTERVAL.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "min-idle-state-retention"), ExecutionConfigOptions.IDLE_STATE_RETENTION.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "parallelism"), CoreOptions.DEFAULT_PARALLELISM.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "max-parallelism"), PipelineOptions.MAX_PARALLELISM.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "result-mode"), SqlClientOptions.EXECUTION_RESULT_MODE.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "max-table-result-rows"), SqlClientOptions.EXECUTION_MAX_TABLE_RESULT_ROWS.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "restart-strategy.type"), RestartStrategyOptions.RESTART_STRATEGY.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "restart-strategy.delay"), RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "restart-strategy.attempts"), RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "restart-strategy.failure-rate-interval"), RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_FAILURE_RATE_INTERVAL.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "restart-strategy.max-failures-per-interval"), RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_MAX_FAILURES_PER_INTERVAL.key());
        ENTRY_TO_OPTION.put(String.format("%s.%s", "execution", "restart-strategy.failure-rate-interval"), RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_DELAY.key());
        for (String key : ENTRY_TO_OPTION.keySet()) {
            OPTION_TO_ENTRY.put(ENTRY_TO_OPTION.get(key), key);
        }
        REMOVED_ENTRY.add(String.format("%s.%s", "execution", "time-characteristic"));
        REMOVED_ENTRY.add(String.format("%s.%s", "execution", "max-idle-state-retention"));
        REMOVED_ENTRY.add(String.format("%s.%s", "execution", "current-catalog"));
        REMOVED_ENTRY.add(String.format("%s.%s", "execution", "current-database"));
    }
}

