/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config;

import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.table.client.config.ResultMode;

public class SqlClientOptions {
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<Integer> EXECUTION_MAX_TABLE_RESULT_ROWS = ConfigOptions.key((String)"sql-client.execution.max-table-result.rows").intType().defaultValue((Object)1000000).withDescription("The number of rows to cache when in the table mode. If the number of rows exceeds the specified value, it retries the row in the FIFO style.");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<ResultMode> EXECUTION_RESULT_MODE = ConfigOptions.key((String)"sql-client.execution.result-mode").enumType(ResultMode.class).defaultValue((Object)ResultMode.TABLE).withDescription("Determine the mode when display the query result. The available values are ['table', 'tableau', 'changelog']. The 'table' mode materializes results in memory and visualizes them in a regular, paginated table representation. The 'changelog' mode does not materialize results and visualizes the result stream that is produced by a continuous query. The 'tableau' mode is more like a traditional way which will display the results in the screen directly with a tableau format. ");
    @Documentation.TableOption(execMode=Documentation.ExecMode.BATCH_STREAMING)
    public static final ConfigOption<Boolean> VERBOSE = ConfigOptions.key((String)"sql-client.verbose").booleanType().defaultValue((Object)false).withDescription("Determine whether to output the verbose output to the console. If set the option true, it will print the exception stack. Otherwise, it only output the cause.");

    private SqlClientOptions() {
    }
}

