/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.generated.GeneratedNormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.TableStreamOperator;
import org.apache.flink.table.runtime.operators.sort.BinaryExternalSorter;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.util.StreamRecordCollector;
import org.apache.flink.util.MutableObjectIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortOperator
extends TableStreamOperator<RowData>
implements OneInputStreamOperator<RowData, RowData>,
BoundedOneInput {
    private static final Logger LOG = LoggerFactory.getLogger(SortOperator.class);
    private GeneratedNormalizedKeyComputer gComputer;
    private GeneratedRecordComparator gComparator;
    private transient BinaryExternalSorter sorter;
    private transient StreamRecordCollector<RowData> collector;
    private transient BinaryRowDataSerializer binarySerializer;

    public SortOperator(GeneratedNormalizedKeyComputer gComputer, GeneratedRecordComparator gComparator) {
        this.gComputer = gComputer;
        this.gComparator = gComparator;
    }

    @Override
    public void open() throws Exception {
        super.open();
        LOG.info("Opening SortOperator");
        ClassLoader cl = this.getContainingTask().getUserCodeClassLoader();
        AbstractRowDataSerializer inputSerializer = (AbstractRowDataSerializer)this.getOperatorConfig().getTypeSerializerIn1(this.getUserCodeClassloader());
        this.binarySerializer = new BinaryRowDataSerializer(inputSerializer.getArity());
        NormalizedKeyComputer computer = (NormalizedKeyComputer)this.gComputer.newInstance(cl);
        RecordComparator comparator = (RecordComparator)this.gComparator.newInstance(cl);
        this.gComputer = null;
        this.gComparator = null;
        MemoryManager memManager = this.getContainingTask().getEnvironment().getMemoryManager();
        this.sorter = new BinaryExternalSorter(this.getContainingTask(), memManager, this.computeMemorySize(), this.getContainingTask().getEnvironment().getIOManager(), inputSerializer, this.binarySerializer, computer, comparator, this.getContainingTask().getJobConfiguration());
        this.sorter.startThreads();
        this.collector = new StreamRecordCollector(this.output);
        this.getMetricGroup().gauge("memoryUsedSizeInBytes", this.sorter::getUsedMemoryInBytes);
        this.getMetricGroup().gauge("numSpillFiles", this.sorter::getNumSpillFiles);
        this.getMetricGroup().gauge("spillInBytes", this.sorter::getSpillInBytes);
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        this.sorter.write((RowData)element.getValue());
    }

    public void endInput() throws Exception {
        BinaryRowData row = this.binarySerializer.createInstance();
        MutableObjectIterator<BinaryRowData> iterator = this.sorter.getIterator();
        while ((row = (BinaryRowData)iterator.next((Object)row)) != null) {
            this.collector.collect(row);
        }
    }

    @Override
    public void close() throws Exception {
        LOG.info("Closing SortOperator");
        super.close();
        if (this.sorter != null) {
            this.sorter.close();
        }
    }
}

