/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.streaming.api.functions.async.RichAsyncFunction;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.collector.TableFunctionResultFuture;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.generated.GeneratedResultFuture;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;

public class AsyncLookupJoinRunner
extends RichAsyncFunction<RowData, RowData> {
    private static final long serialVersionUID = -6664660022391632480L;
    private final GeneratedFunction<AsyncFunction<RowData, Object>> generatedFetcher;
    private final DataStructureConverter<RowData, Object> fetcherConverter;
    private final GeneratedResultFuture<TableFunctionResultFuture<RowData>> generatedResultFuture;
    private final boolean isLeftOuterJoin;
    private final int asyncBufferCapacity;
    private transient AsyncFunction<RowData, Object> fetcher;
    protected final RowDataSerializer rightRowSerializer;
    private transient BlockingQueue<JoinedRowResultFuture> resultFutureBuffer;
    private transient List<JoinedRowResultFuture> allResultFutures;

    public AsyncLookupJoinRunner(GeneratedFunction<AsyncFunction<RowData, Object>> generatedFetcher, DataStructureConverter<RowData, Object> fetcherConverter, GeneratedResultFuture<TableFunctionResultFuture<RowData>> generatedResultFuture, RowDataSerializer rightRowSerializer, boolean isLeftOuterJoin, int asyncBufferCapacity) {
        this.generatedFetcher = generatedFetcher;
        this.fetcherConverter = fetcherConverter;
        this.generatedResultFuture = generatedResultFuture;
        this.rightRowSerializer = rightRowSerializer;
        this.isLeftOuterJoin = isLeftOuterJoin;
        this.asyncBufferCapacity = asyncBufferCapacity;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.fetcher = (AsyncFunction)this.generatedFetcher.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext(this.fetcher, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.fetcher, (Configuration)parameters);
        this.generatedResultFuture.compile(this.getRuntimeContext().getUserCodeClassLoader());
        this.fetcherConverter.open(this.getRuntimeContext().getUserCodeClassLoader());
        this.resultFutureBuffer = new ArrayBlockingQueue<JoinedRowResultFuture>(this.asyncBufferCapacity + 1);
        this.allResultFutures = new ArrayList<JoinedRowResultFuture>();
        for (int i = 0; i < this.asyncBufferCapacity + 1; ++i) {
            JoinedRowResultFuture rf = new JoinedRowResultFuture(this.resultFutureBuffer, this.createFetcherResultFuture(parameters), this.fetcherConverter, this.isLeftOuterJoin, this.rightRowSerializer.getArity());
            this.resultFutureBuffer.add(rf);
            this.allResultFutures.add(rf);
        }
    }

    public void asyncInvoke(RowData input, ResultFuture<RowData> resultFuture) throws Exception {
        JoinedRowResultFuture outResultFuture = this.resultFutureBuffer.take();
        outResultFuture.reset(input, resultFuture);
        this.fetcher.asyncInvoke((Object)input, (ResultFuture)outResultFuture);
    }

    public TableFunctionResultFuture<RowData> createFetcherResultFuture(Configuration parameters) throws Exception {
        TableFunctionResultFuture resultFuture = (TableFunctionResultFuture)((Object)this.generatedResultFuture.newInstance(this.getRuntimeContext().getUserCodeClassLoader()));
        FunctionUtils.setFunctionRuntimeContext((Function)resultFuture, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction((Function)resultFuture, (Configuration)parameters);
        return resultFuture;
    }

    public void close() throws Exception {
        super.close();
        if (this.fetcher != null) {
            FunctionUtils.closeFunction(this.fetcher);
        }
        if (this.allResultFutures != null) {
            for (JoinedRowResultFuture rf : this.allResultFutures) {
                rf.close();
            }
        }
    }

    @VisibleForTesting
    public List<JoinedRowResultFuture> getAllResultFutures() {
        return this.allResultFutures;
    }

    private static final class JoinedRowResultFuture
    implements ResultFuture<Object> {
        private final BlockingQueue<JoinedRowResultFuture> resultFutureBuffer;
        private final TableFunctionResultFuture<RowData> joinConditionResultFuture;
        private final DataStructureConverter<RowData, Object> resultConverter;
        private final boolean isLeftOuterJoin;
        private final DelegateResultFuture delegate;
        private final GenericRowData nullRow;
        private RowData leftRow;
        private ResultFuture<RowData> realOutput;

        private JoinedRowResultFuture(BlockingQueue<JoinedRowResultFuture> resultFutureBuffer, TableFunctionResultFuture<RowData> joinConditionResultFuture, DataStructureConverter<RowData, Object> resultConverter, boolean isLeftOuterJoin, int rightArity) {
            this.resultFutureBuffer = resultFutureBuffer;
            this.joinConditionResultFuture = joinConditionResultFuture;
            this.resultConverter = resultConverter;
            this.isLeftOuterJoin = isLeftOuterJoin;
            this.delegate = new DelegateResultFuture();
            this.nullRow = new GenericRowData(rightArity);
        }

        public void reset(RowData row, ResultFuture<RowData> realOutput) {
            this.realOutput = realOutput;
            this.leftRow = row;
            this.joinConditionResultFuture.setInput(row);
            this.joinConditionResultFuture.setResultFuture(this.delegate);
            this.delegate.reset();
        }

        public void complete(Collection<Object> result) {
            Collection<Object> rowDataCollection;
            if (this.resultConverter.isIdentityConversion()) {
                rowDataCollection = result;
            } else {
                rowDataCollection = new ArrayList<Object>(result.size());
                for (Object element : result) {
                    rowDataCollection.add(this.resultConverter.toInternal(element));
                }
            }
            try {
                this.joinConditionResultFuture.complete(rowDataCollection);
            }
            catch (Throwable t) {
                this.completeExceptionally(t);
                return;
            }
            Collection rightRows = this.delegate.collection;
            if (rightRows == null || rightRows.isEmpty()) {
                if (this.isLeftOuterJoin) {
                    JoinedRowData outRow = new JoinedRowData(this.leftRow.getRowKind(), this.leftRow, this.nullRow);
                    this.realOutput.complete(Collections.singleton(outRow));
                } else {
                    this.realOutput.complete(Collections.emptyList());
                }
            } else {
                ArrayList<JoinedRowData> outRows = new ArrayList<JoinedRowData>();
                for (RowData rightRow : rightRows) {
                    JoinedRowData outRow = new JoinedRowData(this.leftRow.getRowKind(), this.leftRow, rightRow);
                    outRows.add(outRow);
                }
                this.realOutput.complete(outRows);
            }
            try {
                this.resultFutureBuffer.put(this);
            }
            catch (InterruptedException e) {
                this.completeExceptionally(e);
            }
        }

        public void completeExceptionally(Throwable error) {
            this.realOutput.completeExceptionally(error);
        }

        public void close() throws Exception {
            this.joinConditionResultFuture.close();
        }

        private final class DelegateResultFuture
        implements ResultFuture<RowData> {
            private Collection<RowData> collection;

            private DelegateResultFuture() {
            }

            public void reset() {
                this.collection = null;
            }

            public void complete(Collection<RowData> result) {
                this.collection = result;
            }

            public void completeExceptionally(Throwable error) {
                JoinedRowResultFuture.this.completeExceptionally(error);
            }
        }
    }
}

