/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionRequirement;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class BuiltInScalarFunction
extends ScalarFunction {
    @Nullable
    private transient BuiltInFunctionDefinition definition;
    private transient List<DataType> argumentDataTypes;
    private transient DataType outputDataType;

    protected BuiltInScalarFunction(BuiltInFunctionDefinition definition, SpecializedFunction.SpecializedContext context) {
        this.definition = definition;
        CallContext callContext = context.getCallContext();
        this.argumentDataTypes = callContext.getArgumentDataTypes().stream().map(DataTypeUtils::toInternalDataType).collect(Collectors.toList());
        this.outputDataType = callContext.getOutputDataType().map(DataTypeUtils::toInternalDataType).orElseThrow(IllegalStateException::new);
    }

    protected BuiltInScalarFunction() {
    }

    public List<DataType> getArgumentDataTypes() {
        Preconditions.checkNotNull(this.argumentDataTypes, (String)"Argument data types not set.");
        return this.argumentDataTypes;
    }

    public DataType getOutputDataType() {
        Preconditions.checkNotNull((Object)this.outputDataType, (String)"Output data type not set.");
        return this.outputDataType;
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        return TypeInference.newBuilder().typedArguments(this.getArgumentDataTypes()).outputTypeStrategy(TypeStrategies.explicit(this.getOutputDataType())).build();
    }

    @Override
    public Set<FunctionRequirement> getRequirements() {
        if (this.definition != null) {
            this.definition.getRequirements();
        }
        return super.getRequirements();
    }

    @Override
    public boolean isDeterministic() {
        if (this.definition != null) {
            this.definition.getRequirements();
        }
        return super.isDeterministic();
    }
}

