/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Collections;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.expressions.PlannerNamedWindowProperty;
import org.apache.flink.table.planner.expressions.PlannerProctimeAttribute;
import org.apache.flink.table.planner.expressions.PlannerRowtimeAttribute;
import org.apache.flink.table.planner.expressions.PlannerWindowEnd;
import org.apache.flink.table.planner.expressions.PlannerWindowProperty;
import org.apache.flink.table.planner.expressions.PlannerWindowStart;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.sql.SqlWindowTableFunction;
import org.apache.flink.table.planner.plan.logical.CumulativeWindowSpec;
import org.apache.flink.table.planner.plan.logical.HoppingWindowSpec;
import org.apache.flink.table.planner.plan.logical.TimeAttributeWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.TumblingWindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.trait.RelWindowProperties;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil$;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil$;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy$;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class WindowUtil$ {
    public static WindowUtil$ MODULE$;

    static {
        new WindowUtil$();
    }

    public boolean groupingContainsWindowStartEnd(ImmutableBitSet grouping, RelWindowProperties windowProperties) {
        boolean bl;
        if (windowProperties != null) {
            boolean hasWindowEnd;
            ImmutableBitSet windowStarts = windowProperties.getWindowStartColumns();
            ImmutableBitSet windowEnds = windowProperties.getWindowEndColumns();
            boolean hasWindowStart = !windowStarts.intersect(grouping).isEmpty();
            boolean bl2 = hasWindowEnd = !windowEnds.intersect(grouping).isEmpty();
            bl = hasWindowStart && hasWindowEnd;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isWindowTableFunctionCall(RexNode node) {
        boolean bl;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode;
            bl = rexCall.getOperator() instanceof SqlWindowTableFunction;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean calcContainsCallsOnWindowColumns(Calc calc, FlinkRelMetadataQuery fmq) {
        RexNode predicate;
        RelNode calcInput = calc.getInput();
        ImmutableBitSet calcInputWindowColumns = fmq.getRelWindowProperties(calcInput).getWindowColumns();
        RexProgram calcProgram = calc.getProgram();
        RexLocalRef condition = calcProgram.getCondition();
        if (condition != null && FlinkRexUtil$.MODULE$.containsExpectedInputRef(predicate = calcProgram.expandLocalRef(condition), calcInputWindowColumns)) {
            return true;
        }
        boolean callsContainProps = ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(calcProgram.getProjectList()).map((Function1 & Serializable & scala.Serializable)x$1 -> calcProgram.expandLocalRef((RexLocalRef)x$1), Buffer$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WindowUtil$.$anonfun$calcContainsCallsOnWindowColumns$2(calcInputWindowColumns, x0$1)));
        return callsContainProps;
    }

    public Tuple4<RexProgram, int[], Object, Object> buildNewProgramWithoutWindowColumns(RexBuilder rexBuilder, RexProgram oldProgram, RelDataType inputRowType, int inputTimeAttributeIndex, int[] windowColumns) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
        BooleanRef containsTimeAttribute = BooleanRef.create((boolean)false);
        IntRef newTimeAttributeIndex = IntRef.create((int)-1);
        ArrayBuffer calcFieldShifting = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(oldProgram.getNamedProjects()).foreach((Function1 & Serializable & scala.Serializable)namedProject -> {
            RexInputRef rexInputRef;
            RexLocalRef rexLocalRef;
            RexNode expr = oldProgram.expandLocalRef((RexLocalRef)namedProject.left);
            String name = (String)namedProject.right;
            RexNode rexNode = expr;
            if (rexNode instanceof RexInputRef) {
                RexInputRef rexInputRef2 = (RexInputRef)rexNode;
                if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(windowColumns)).contains((Object)BoxesRunTime.boxToInteger((int)rexInputRef2.getIndex()))) {
                    return calcFieldShifting.$plus$eq((Object)BoxesRunTime.boxToInteger((int)-1));
                }
            }
            try {
                rexLocalRef = programBuilder.addProject(expr, name);
            }
            catch (Throwable e) {
                e.printStackTrace();
                rexLocalRef = BoxedUnit.UNIT;
            }
            int fieldIndex = programBuilder.getProjectList().size() - 1;
            calcFieldShifting.$plus$eq((Object)BoxesRunTime.boxToInteger((int)fieldIndex));
            RexNode rexNode2 = expr;
            if (rexNode2 instanceof RexInputRef && (rexInputRef = (RexInputRef)rexNode2).getIndex() == inputTimeAttributeIndex) {
                containsTimeAttribute$1.elem = true;
                newTimeAttributeIndex$1.elem = fieldIndex;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        if (!containsTimeAttribute.elem) {
            programBuilder.addProject(inputTimeAttributeIndex, inputRowType.getFieldNames().get(inputTimeAttributeIndex));
            newTimeAttributeIndex.elem = programBuilder.getProjectList().size() - 1;
        }
        if (oldProgram.getCondition() != null) {
            RexNode condition = oldProgram.expandLocalRef(oldProgram.getCondition());
            programBuilder.addCondition(condition);
        }
        RexProgram program = programBuilder.getProgram();
        return new Tuple4((Object)program, calcFieldShifting.toArray(ClassTag$.MODULE$.Int()), (Object)BoxesRunTime.boxToInteger((int)newTimeAttributeIndex.elem), (Object)BoxesRunTime.boxToBoolean((!containsTimeAttribute.elem ? 1 : 0) != 0));
    }

    public TimeAttributeWindowingStrategy convertToWindowingStrategy(RexCall windowCall, RelDataType inputRowType) {
        WindowSpec windowSpec;
        SqlWindowTableFunction windowFunction;
        if (!this.isWindowTableFunctionCall(windowCall)) {
            throw new IllegalArgumentException(new StringBuilder(87).append("RexCall ").append(windowCall).append(" is not a window table-valued ").append("function, can't convert it into WindowingStrategy").toString());
        }
        int timeIndex = this.getTimeAttributeIndex((RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(windowCall.operands).apply(1));
        RelDataType fieldType = inputRowType.getFieldList().get(timeIndex).getType();
        if (!FlinkTypeFactory$.MODULE$.isTimeIndicatorType(fieldType)) {
            throw new ValidationException(new StringBuilder(70).append("Window can only be defined on a time attribute column, but is type of ").append(fieldType).toString());
        }
        LogicalType timeAttributeType = FlinkTypeFactory$.MODULE$.toLogicalType(fieldType);
        if (!LogicalTypeChecks.canBeTimeAttributeType(timeAttributeType)) {
            throw new ValidationException(new StringBuilder(74).append("The supported time indicator type are TIMESTAMP and TIMESTAMP_LTZ, but is ").append(FlinkTypeFactory$.MODULE$.toLogicalType(fieldType)).toString());
        }
        SqlWindowTableFunction sqlWindowTableFunction = windowFunction = (SqlWindowTableFunction)windowCall.getOperator();
        SqlFunction sqlFunction = FlinkSqlOperatorTable.TUMBLE;
        SqlWindowTableFunction sqlWindowTableFunction2 = sqlWindowTableFunction;
        if (!(sqlFunction != null ? !((Object)sqlFunction).equals(sqlWindowTableFunction2) : sqlWindowTableFunction2 != null)) {
            long interval = this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(windowCall.operands).apply(2));
            windowSpec = new TumblingWindowSpec(Duration.ofMillis(interval));
        } else {
            SqlFunction sqlFunction2 = FlinkSqlOperatorTable.HOP;
            SqlWindowTableFunction sqlWindowTableFunction3 = sqlWindowTableFunction;
            if (!(sqlFunction2 != null ? !((Object)sqlFunction2).equals(sqlWindowTableFunction3) : sqlWindowTableFunction3 != null)) {
                long slide = this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(windowCall.operands).apply(2));
                long size = this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(windowCall.operands).apply(3));
                windowSpec = new HoppingWindowSpec(Duration.ofMillis(size), Duration.ofMillis(slide));
            } else {
                SqlFunction sqlFunction3 = FlinkSqlOperatorTable.CUMULATE;
                SqlWindowTableFunction sqlWindowTableFunction4 = sqlWindowTableFunction;
                if (!(sqlFunction3 != null ? !((Object)sqlFunction3).equals(sqlWindowTableFunction4) : sqlWindowTableFunction4 != null)) {
                    long step = this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(windowCall.operands).apply(2));
                    long maxSize = this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(windowCall.operands).apply(3));
                    windowSpec = new CumulativeWindowSpec(Duration.ofMillis(maxSize), Duration.ofMillis(step));
                } else {
                    throw new MatchError((Object)sqlWindowTableFunction);
                }
            }
        }
        TumblingWindowSpec windowSpec2 = windowSpec;
        return new TimeAttributeWindowingStrategy((WindowSpec)windowSpec2, timeAttributeType, timeIndex);
    }

    public void checkEmitConfiguration(TableConfig tableConfig) {
        Configuration conf = tableConfig.getConfiguration();
        if (conf.getBoolean(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED()) || conf.getBoolean(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED())) {
            throw new TableException(new StringBuilder(104).append("Currently, window table function based aggregate doesn't ").append("support early-fire and late-fire configuration ").append(new StringBuilder(7).append("'").append(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED().key()).append("' and ").toString()).append(new StringBuilder(3).append("'").append(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED().key()).append("'.").toString()).toString());
        }
    }

    public RelDataType deriveWindowAggregateRowType(int[] grouping, Seq<AggregateCall> aggCalls, WindowingStrategy windowing, Seq<PlannerNamedWindowProperty> namedWindowProperties, RelDataType inputRowType, FlinkTypeFactory typeFactory) {
        ImmutableBitSet groupSet = ImmutableBitSet.of(grouping);
        RelDataType baseType = Aggregate.deriveRowType(typeFactory, inputRowType, false, groupSet, Collections.singletonList(groupSet), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(aggCalls));
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        builder.addAll(baseType.getFieldList());
        namedWindowProperties.foreach((Function1 & Serializable & scala.Serializable)namedProp -> {
            LogicalType logicalType;
            PlannerWindowProperty plannerWindowProperty = namedProp.getProperty();
            boolean bl = plannerWindowProperty instanceof PlannerWindowStart ? true : plannerWindowProperty instanceof PlannerWindowEnd;
            if (bl) {
                logicalType = new TimestampType(false, 3);
            } else {
                boolean bl2 = plannerWindowProperty instanceof PlannerRowtimeAttribute ? true : plannerWindowProperty instanceof PlannerProctimeAttribute;
                if (bl2) {
                    logicalType = windowing.getTimeAttributeType().copy(false);
                } else {
                    throw new MatchError((Object)plannerWindowProperty);
                }
            }
            TimestampType timeType = logicalType;
            return builder.add(namedProp.getName(), typeFactory.createFieldTypeFromLogicalType(timeType));
        });
        return builder.build();
    }

    public RelDataType deriveLocalWindowAggregateRowType(AggregateInfoList aggInfoList, int[] grouping, String endPropertyName, RelDataType inputRowType, FlinkTypeFactory typeFactory) {
        DataType[] accTypes = aggInfoList.getAccTypes();
        LogicalType[] groupingTypes = (LogicalType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(grouping)).map((Function1 & Serializable & scala.Serializable)x$1 -> WindowUtil$.$anonfun$deriveLocalWindowAggregateRowType$1(inputRowType, BoxesRunTime.unboxToInt((Object)x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class))))).map((Function1 & Serializable & scala.Serializable)relDataType -> FlinkTypeFactory$.MODULE$.toLogicalType((RelDataType)relDataType), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
        LogicalType[] sliceEndType = (LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType()});
        String[] groupingNames = (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(grouping)).map((Function1 & Serializable & scala.Serializable)x$2 -> WindowUtil$.$anonfun$deriveLocalWindowAggregateRowType$3(inputRowType, BoxesRunTime.unboxToInt((Object)x$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] accFieldNames = AggregateUtil$.MODULE$.inferAggAccumulatorNames(aggInfoList);
        String[] sliceEndName = (String[])((Object[])new String[]{new StringBuilder(1).append("$").append(endPropertyName).toString()});
        return typeFactory.buildRelNodeRowType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groupingNames)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])accFieldNames)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sliceEndName)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groupingTypes)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])accTypes)).map((Function1 & Serializable & scala.Serializable)x$1 -> LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sliceEndType)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)))));
    }

    /*
     * Unable to fully structure code
     */
    private int getTimeAttributeIndex(RexNode operand) {
        var5_2 = operand;
        if (!(var5_2 instanceof RexCall)) ** GOTO lbl-1000
        var6_3 = (RexCall)var5_2;
        v0 = var6_3.getKind();
        var7_4 = SqlKind.DESCRIPTOR;
        if (!(v0 != null ? v0.equals((Object)var7_4) == false : var7_4 != null)) {
            var8_5 = (RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(var6_3.operands).apply(0);
            if (var8_5 instanceof RexInputRef) {
                var9_6 = (RexInputRef)var8_5;
                var3_7 = var9_6.getIndex();
            } else {
                var3_7 = -1;
            }
            var2_8 = var3_7;
        } else lbl-1000:
        // 2 sources

        {
            var2_8 = -1;
        }
        timeAttributeIndex = var2_8;
        if (timeAttributeIndex == -1) {
            throw new TableException(new StringBuilder(82).append("Failed to get time attribute index from ").append(operand).append(". ").append("This is a bug, please file a JIRA issue.").toString());
        }
        return timeAttributeIndex;
    }

    private long getOperandAsLong(RexNode operand) {
        RexLiteral rexLiteral;
        block5: {
            boolean bl;
            block4: {
                bl = false;
                rexLiteral = null;
                RexNode rexNode = operand;
                if (!(rexNode instanceof RexLiteral)) break block4;
                bl = true;
                rexLiteral = (RexLiteral)rexNode;
                SqlTypeFamily sqlTypeFamily = rexLiteral.getTypeName().getFamily();
                SqlTypeFamily sqlTypeFamily2 = SqlTypeFamily.INTERVAL_DAY_TIME;
                if (!(sqlTypeFamily != null ? !sqlTypeFamily.equals(sqlTypeFamily2) : sqlTypeFamily2 != null)) break block5;
            }
            if (bl) {
                throw new TableException("Window aggregate only support SECOND, MINUTE, HOUR, DAY as the time unit. MONTH and YEAR time unit are not supported yet.");
            }
            throw new TableException("Only constant window descriptors are supported.");
        }
        long l = ((BigDecimal)rexLiteral.getValue()).longValue();
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$calcContainsCallsOnWindowColumns$2(ImmutableBitSet calcInputWindowColumns$1, RexNode x0$1) {
        boolean bl;
        RexNode rexNode = x0$1;
        if (rexNode instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode;
            bl = FlinkRexUtil$.MODULE$.containsExpectedInputRef(rexCall, calcInputWindowColumns$1);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ RelDataType $anonfun$deriveLocalWindowAggregateRowType$1(RelDataType inputRowType$1, int x$1) {
        return inputRowType$1.getFieldList().get(x$1).getType();
    }

    public static final /* synthetic */ String $anonfun$deriveLocalWindowAggregateRowType$3(RelDataType inputRowType$1, int x$2) {
        return inputRowType$1.getFieldNames().get(x$2);
    }

    private WindowUtil$() {
        MODULE$ = this;
    }
}

