/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.time.Duration;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsSourceWatermark;
import org.apache.flink.table.connector.source.abilities.SupportsWatermarkPushDown;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;
import org.apache.flink.table.planner.plan.abilities.source.SourceWatermarkSpec;
import org.apache.flink.table.planner.plan.abilities.source.WatermarkPushDownSpec;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalWatermarkAssigner;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.utils.ShortcutUtils;
import org.apache.flink.table.types.logical.RowType;

public abstract class PushWatermarkIntoTableSourceScanRuleBase
extends RelOptRule {
    public PushWatermarkIntoTableSourceScanRuleBase(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    protected FlinkLogicalTableSourceScan getNewScan(FlinkLogicalWatermarkAssigner watermarkAssigner, RexNode watermarkExpr, FlinkLogicalTableSourceScan scan, TableConfig tableConfig, boolean useWatermarkAssignerRowType) {
        SourceAbilitySpecBase abilitySpec;
        String digest = String.format("watermark=[%s]", watermarkExpr);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        DynamicTableSource newDynamicTableSource = tableSourceTable.tableSource().copy();
        boolean isSourceWatermark = newDynamicTableSource instanceof SupportsSourceWatermark && this.hasSourceWatermarkDeclaration(watermarkExpr);
        RelDataType newType = useWatermarkAssignerRowType ? watermarkAssigner.getRowType() : scan.getRowType();
        RowType producedType = (RowType)FlinkTypeFactory.toLogicalType(newType);
        SourceAbilityContext abilityContext = SourceAbilityContext.from(scan);
        if (isSourceWatermark) {
            SourceWatermarkSpec sourceWatermarkSpec = new SourceWatermarkSpec(true, producedType);
            sourceWatermarkSpec.apply(newDynamicTableSource, abilityContext);
            abilitySpec = sourceWatermarkSpec;
        } else {
            long idleTimeoutMillis;
            Duration idleTimeout = (Duration)tableConfig.getConfiguration().get(ExecutionConfigOptions.TABLE_EXEC_SOURCE_IDLE_TIMEOUT);
            if (!idleTimeout.isZero() && !idleTimeout.isNegative()) {
                idleTimeoutMillis = idleTimeout.toMillis();
                digest = String.format("%s, idletimeout=[%s]", digest, idleTimeoutMillis);
            } else {
                idleTimeoutMillis = -1L;
            }
            WatermarkPushDownSpec watermarkPushDownSpec = new WatermarkPushDownSpec(watermarkExpr, idleTimeoutMillis, producedType);
            watermarkPushDownSpec.apply(newDynamicTableSource, abilityContext);
            abilitySpec = watermarkPushDownSpec;
        }
        TableSourceTable newTableSourceTable = tableSourceTable.copy(newDynamicTableSource, newType, new String[]{digest}, new SourceAbilitySpec[]{abilitySpec});
        return FlinkLogicalTableSourceScan.create(scan.getCluster(), scan.getHints(), newTableSourceTable);
    }

    protected boolean supportsWatermarkPushDown(FlinkLogicalTableSourceScan scan) {
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        if (tableSourceTable == null) {
            return false;
        }
        DynamicTableSource tableSource = tableSourceTable.tableSource();
        return tableSource instanceof SupportsWatermarkPushDown || tableSource instanceof SupportsSourceWatermark && this.hasSourceWatermarkDeclaration(tableSourceTable);
    }

    private boolean hasSourceWatermarkDeclaration(TableSourceTable table) {
        ResolvedSchema schema = table.catalogTable().getResolvedSchema();
        List<WatermarkSpec> specs = schema.getWatermarkSpecs();
        if (specs.size() != 1) {
            return false;
        }
        ResolvedExpression watermarkExpr = specs.get(0).getWatermarkExpression();
        FunctionDefinition function = ShortcutUtils.unwrapFunctionDefinition(watermarkExpr);
        return function == BuiltInFunctionDefinitions.SOURCE_WATERMARK;
    }

    private boolean hasSourceWatermarkDeclaration(RexNode rexNode) {
        FunctionDefinition function = ShortcutUtils.unwrapFunctionDefinition(rexNode);
        return function == BuiltInFunctionDefinitions.SOURCE_WATERMARK;
    }
}

