/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlGroupedWindowFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.planner.expressions.PlannerNamedWindowProperty;
import org.apache.flink.table.planner.expressions.PlannerWindowReference;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate$;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uf!B\u0001\u0003\u0003\u0003\u0019\"A\b'pO&\u001c\u0017\r\\,j]\u0012|w/Q4he\u0016<\u0017\r^3Sk2,')Y:f\u0015\t\u0019A!A\u0004m_\u001eL7-\u00197\u000b\u0005\u00151\u0011!\u0002:vY\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001635\taC\u0003\u0002\b/)\u0011\u0001DD\u0001\bG\u0006d7-\u001b;f\u0013\tQbC\u0001\u0006SK2|\u0005\u000f\u001e*vY\u0016D\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\fI\u0016\u001c8M]5qi&|g\u000e\u0005\u0002\u001fO9\u0011q$\n\t\u0003A\rj\u0011!\t\u0006\u0003EI\ta\u0001\u0010:p_Rt$\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a\u0013A\u0002)sK\u0012,g-\u0003\u0002)S\t11\u000b\u001e:j]\u001eT!AJ\u0012\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\tis\u0006\u0005\u0002/\u00015\t!\u0001C\u0003\u001dU\u0001\u0007Q\u0004C\u00032\u0001\u0011\u0005#'A\u0004nCR\u001c\u0007.Z:\u0015\u0005M:\u0004C\u0001\u001b6\u001b\u0005\u0019\u0013B\u0001\u001c$\u0005\u001d\u0011un\u001c7fC:DQ\u0001\u000f\u0019A\u0002e\nAaY1mYB\u0011QCO\u0005\u0003wY\u0011aBU3m\u001fB$(+\u001e7f\u0007\u0006dG\u000eC\u0003>\u0001\u0011\u0005c(A\u0004p]6\u000bGo\u00195\u0015\u0005}\u0012\u0005C\u0001\u001bA\u0013\t\t5E\u0001\u0003V]&$\b\"\u0002\u001d=\u0001\u0004I\u0004\"\u0002#\u0001\t\u0013)\u0015a\u0002;sS6DU\r\u001d\u000b\u0003\r2\u0003\"a\u0012&\u000e\u0003!S!!S\f\u0002\u0007I,G.\u0003\u0002L\u0011\n9!+\u001a7O_\u0012,\u0007\"B'D\u0001\u00041\u0015\u0001\u00028pI\u0016DQa\u0014\u0001\u0005\nA\u000baC]3xe&$X\r\u0015:pGRLW.Z,j]\u0012|wo\u001d\u000b\u0004#ZC\u0006C\u0001*U\u001b\u0005\u0019&BA\u0002I\u0013\t)6K\u0001\bM_\u001eL7-\u00197Qe>TWm\u0019;\t\u000b]s\u0005\u0019A)\u0002\u000fA\u0014xN[3di\")\u0011L\u0014a\u00015\u0006Q!/\u001a7Ck&dG-\u001a:\u0011\u0005msV\"\u0001/\u000b\u0005u;\u0012!\u0002;p_2\u001c\u0018BA0]\u0005)\u0011V\r\u001c\"vS2$WM\u001d\u0005\u0006C\u0002!\tAY\u0001\u000fSN\u0004&o\\2uS6,7)\u00197m)\t\u00194\rC\u0003eA\u0002\u0007Q-A\u0004sKbtu\u000eZ3\u0011\u0005\u0019LW\"A4\u000b\u0005!<\u0012a\u0001:fq&\u0011!n\u001a\u0002\b%\u0016Dhj\u001c3f\u0011\u0015a\u0007\u0001\"\u0001n\u00031I7oV5oI><8)\u00197m)\t\u0019d\u000eC\u00039W\u0002\u0007q\u000e\u0005\u0002ga&\u0011\u0011o\u001a\u0002\b%\u0016D8)\u00197m\u0011\u0015\u0019\b\u0001\"\u0003u\u0003-\tGM[;tiRK\b/Z:\u0015\u000bU\f9!!\u0005\u0011\u0007Y\\X0D\u0001x\u0015\tA\u00180A\u0004nkR\f'\r\\3\u000b\u0005i\u001c\u0013AC2pY2,7\r^5p]&\u0011Ap\u001e\u0002\u0007\u0005V4g-\u001a:\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t\u0001S\u0001\u0005G>\u0014X-C\u0002\u0002\u0006}\u0014Q\"Q4he\u0016<\u0017\r^3DC2d\u0007bBA\u0005e\u0002\u0007\u00111B\u0001\u0004C\u001e<\u0007c\u0001*\u0002\u000e%\u0019\u0011qB*\u0003!1{w-[2bY\u0006;wM]3hCR,\u0007bBA\ne\u0002\u0007\u0011QC\u0001\u000eS:$W\r_!oIRK\b/Z:\u0011\u000fy\t9\"a\u0007\u0002\"%\u0019\u0011\u0011D\u0015\u0003\u00075\u000b\u0007\u000fE\u00025\u0003;I1!a\b$\u0005\rIe\u000e\u001e\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005%\u0002\tQL\b/Z\u0005\u0005\u0003W\t)CA\u0006SK2$\u0015\r^1UsB,\u0007bBA\u0018\u0001\u0011%\u0011\u0011G\u0001\"O\u0016$\u0018J\u001c3fq\u0006sG-\u00138gKJ\u0014X\r\u001a+za\u0016\u001c\u0018JZ\"iC:<W\r\u001a\u000b\u0005\u0003+\t\u0019\u0004\u0003\u0005\u0002\n\u00055\u0002\u0019AA\u0006\u0011!\t9\u0004\u0001C\u0001\u0015\u0005e\u0012\u0001F4fi^Kg\u000eZ8x\u000bb\u0004(/Z:tS>t7\u000f\u0006\u0004\u0002<\u0005M\u0013Q\u000b\t\u0007\u0003{\t9%!\u0014\u000f\t\u0005}\u00121\t\b\u0004A\u0005\u0005\u0013\"\u0001\u0013\n\u0007\u0005\u00153%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00131\n\u0002\u0004'\u0016\f(bAA#GA1A'a\u0014p\u00037I1!!\u0015$\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011BA\u001b\u0001\u0004\tY\u0001\u0003\u0004X\u0003k\u0001\r!\u0015\u0005\t\u00033\u0002a\u0011\u0001\u0006\u0002\\\u0005ir-\u001a;J]\u0006;wM]3hCR,wI]8va\u0016C\bO]3tg&|g\u000eF\u0003f\u0003;\n9\u0007\u0003\u0005\u0002`\u0005]\u0003\u0019AA1\u0003)\u0011X\r\u001f\"vS2$WM\u001d\t\u0004M\u0006\r\u0014bAA3O\nQ!+\u001a=Ck&dG-\u001a:\t\u000f\u0005%\u0014q\u000ba\u0001_\u0006\u0001r/\u001b8e_^,\u0005\u0010\u001d:fgNLwN\u001c\u0005\t\u0003[\u0002a\u0011\u0001\u0006\u0002p\u0005qr-\u001a;PkR\fum\u001a:fO\u0006$Xm\u0012:pkB,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0006K\u0006E\u00141\u000f\u0005\t\u0003?\nY\u00071\u0001\u0002b!9\u0011\u0011NA6\u0001\u0004y\u0007\u0002CA<\u0001\u0011\u0005!\"!\u001f\u0002\u001fQ\u0014\u0018M\\:mCR,w+\u001b8e_^$\u0002\"a\u001f\u0002\u0006\u0006%\u0015Q\u0012\t\u0005\u0003{\n\t)\u0004\u0002\u0002\u0000)\u00111AB\u0005\u0005\u0003\u0007\u000byHA\u0007M_\u001eL7-\u00197XS:$wn\u001e\u0005\b\u0003\u000f\u000b)\b1\u0001p\u0003)9\u0018N\u001c3po\u0016C\bO\u001d\u0005\t\u0003\u0017\u000b)\b1\u0001\u0002\u001c\u0005iq/\u001b8e_^,\u0005\u0010\u001d:JIbD\u0001\"a$\u0002v\u0001\u0007\u0011\u0011E\u0001\be><H+\u001f9f\u0011!\t\u0019\n\u0001D\u0001\u0015\u0005U\u0015!F4fiRKW.\u001a$jK2$'+\u001a4fe\u0016t7-\u001a\u000b\t\u0003/\u000b\u0019+a*\u0002*B!\u0011\u0011TAP\u001b\t\tYJC\u0002\u0002\u001e*\t1\"\u001a=qe\u0016\u001c8/[8og&!\u0011\u0011UAN\u0005a1\u0015.\u001a7e%\u00164WM]3oG\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u0003K\u000b\t\n1\u0001f\u0003\u001dy\u0007/\u001a:b]\u0012D\u0001\"a#\u0002\u0012\u0002\u0007\u00111\u0004\u0005\t\u0003\u001f\u000b\t\n1\u0001\u0002\"!9\u0011Q\u0016\u0001\u0007\u0002\u0005=\u0016\u0001E4fi>\u0003XM]1oI\u0006\u001bHj\u001c8h)\u0019\t\t,a.\u0002:B\u0019A'a-\n\u0007\u0005U6E\u0001\u0003M_:<\u0007B\u0002\u001d\u0002,\u0002\u0007q\u000e\u0003\u0005\u0002<\u0006-\u0006\u0019AA\u000e\u0003\rIG\r\u001f")
public abstract class LogicalWindowAggregateRuleBase
extends RelOptRule {
    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalAggregate agg = (LogicalAggregate)call.rel(0);
        Seq<Tuple2<RexCall, Object>> windowExpressions = this.getWindowExpressions(agg, (LogicalProject)this.trimHep(agg.getInput()));
        if (windowExpressions.length() > 1) {
            throw new TableException("Only a single window group function may be used in GROUP BY");
        }
        Aggregate.Group group = agg.getGroupType();
        Aggregate.Group group2 = Aggregate.Group.SIMPLE;
        boolean groupSets = group == null ? group2 != null : !((Object)((Object)group)).equals((Object)group2);
        return !groupSets && windowExpressions.nonEmpty();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalProject project;
        RelBuilder builder = call.builder();
        LogicalAggregate agg = (LogicalAggregate)call.rel(0);
        Tuple2 tuple2 = (Tuple2)this.getWindowExpressions(agg, project = this.rewriteProctimeWindows((LogicalProject)call.rel(1), builder)).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RexCall windowExpr = (RexCall)tuple2._1();
        int windowExprIdx = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)windowExpr, (Object)BoxesRunTime.boxToInteger((int)windowExprIdx));
        Tuple2 tuple23 = tuple22;
        RexCall windowExpr2 = (RexCall)tuple23._1();
        int windowExprIdx2 = tuple23._2$mcI$sp();
        RexBuilder rexBuilder = agg.getCluster().getRexBuilder();
        RexNode inAggGroupExpression = this.getInAggregateGroupExpression(rexBuilder, windowExpr2);
        ImmutableBitSet newGroupSet = agg.getGroupSet().except(ImmutableBitSet.of(windowExprIdx2));
        RelNode newProject = builder.push(project.getInput()).project(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(project.getProjects()).updated(windowExprIdx2, (Object)inAggGroupExpression, Buffer$.MODULE$.canBuildFrom()))).build();
        LogicalWindow window = this.translateWindow(windowExpr2, windowExprIdx2, newProject.getRowType());
        scala.collection.immutable.Map<Object, RelDataType> indexAndTypes = this.getIndexAndInferredTypesIfChanged(agg);
        Buffer<AggregateCall> finalCalls = this.adjustTypes(agg, indexAndTypes);
        LogicalAggregate newAgg = LogicalAggregate.create(newProject, false, newGroupSet, ImmutableList.of(newGroupSet), (List<AggregateCall>)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(finalCalls));
        RelBuilder transformed = call.builder();
        LogicalWindowAggregate windowAgg = LogicalWindowAggregate$.MODULE$.create(window, (Seq<PlannerNamedWindowProperty>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), newAgg);
        transformed.push(windowAgg);
        RexNode outAggGroupExpression0 = this.getOutAggregateGroupExpression(rexBuilder, windowExpr2);
        RexNode outAggGroupExpression = windowExpr2.getType().isNullable() != outAggGroupExpression0.getType().isNullable() ? builder.getRexBuilder().makeAbstractCast(builder.getRexBuilder().matchNullability(outAggGroupExpression0.getType(), windowExpr2), outAggGroupExpression0) : outAggGroupExpression0;
        Buffer projectsEnsureGroupKeyTypes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(transformed.fields()).patch(windowExprIdx2, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{outAggGroupExpression})), 0, Buffer$.MODULE$.canBuildFrom());
        Buffer projectsEnsureAggCallTypes = (Buffer)((TraversableLike)projectsEnsureGroupKeyTypes.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RexNode aggCall = (RexNode)tuple2._1();
            int index = tuple2._2$mcI$sp();
            int aggCallIndex = index - agg.getGroupCount();
            RexNode rexNode = JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)indexAndTypes).containsKey(BoxesRunTime.boxToInteger((int)aggCallIndex)) ? rexBuilder.makeCast(agg$1.getAggCallList().get((int)aggCallIndex).type, aggCall, true) : aggCall;
            return rexNode;
        }, Buffer$.MODULE$.canBuildFrom());
        transformed.project(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(projectsEnsureAggCallTypes));
        RelNode result = transformed.build();
        call.transformTo(result);
    }

    private RelNode trimHep(RelNode node) {
        RelNode relNode;
        RelNode relNode2 = node;
        if (relNode2 instanceof HepRelVertex) {
            HepRelVertex hepRelVertex = (HepRelVertex)relNode2;
            relNode = hepRelVertex.getCurrentRel();
        } else {
            relNode = node;
        }
        return relNode;
    }

    private LogicalProject rewriteProctimeWindows(LogicalProject project, RelBuilder relBuilder) {
        LogicalProject logicalProject;
        RelNode projectInput = this.trimHep(project.getInput());
        BooleanRef hasWindowOnProctimeCall = BooleanRef.create((boolean)false);
        Buffer newProjectExprs = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(project.getProjects()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            RexNode rexNode;
            RexCall rexCall;
            RexNode rexNode2 = x0$3;
            if (rexNode2 instanceof RexCall && this.isWindowCall(rexCall = (RexCall)rexNode2) && this.isProctimeCall((RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.getOperands()).head())) {
                hasWindowOnProctimeCall$1.elem = true;
                rexNode = rexCall.accept(new RexShuttle(this, relBuilder, projectInput){
                    private final /* synthetic */ LogicalWindowAggregateRuleBase $outer;
                    private final RelBuilder relBuilder$1;
                    private final RelNode projectInput$1;

                    public RexNode visitCall(RexCall call) {
                        return this.$outer.isProctimeCall(call) ? this.relBuilder$1.getRexBuilder().makeInputRef(call.getType(), this.projectInput$1.getRowType().getFieldCount()) : super.visitCall(call);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.relBuilder$1 = relBuilder$1;
                        this.projectInput$1 = projectInput$1;
                    }
                });
            } else if (rexNode2 != null) {
                RexNode rexNode3;
                rexNode = rexNode3 = rexNode2;
            } else {
                throw new MatchError((Object)rexNode2);
            }
            return rexNode;
        }, Buffer$.MODULE$.canBuildFrom());
        if (hasWindowOnProctimeCall.elem) {
            RelNode newInput = relBuilder.push(projectInput).projectPlus(relBuilder.call((SqlOperator)FlinkSqlOperatorTable.PROCTIME, new RexNode[0])).build();
            logicalProject = (LogicalProject)RelFactories.DEFAULT_PROJECT_FACTORY.createProject(newInput, Collections.emptyList(), JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(newProjectExprs), project.getRowType().getFieldNames());
        } else {
            logicalProject = project;
        }
        return logicalProject;
    }

    public boolean isProctimeCall(RexNode rexNode) {
        boolean bl;
        RexNode rexNode2 = rexNode;
        if (rexNode2 instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlFunction sqlFunction = FlinkSqlOperatorTable.PROCTIME;
            bl = !(sqlOperator != null ? !((Object)sqlOperator).equals(sqlFunction) : sqlFunction != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isWindowCall(RexCall call) {
        boolean bl;
        SqlOperator sqlOperator = call.getOperator();
        SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.SESSION_OLD;
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
            bl = true;
        } else {
            SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_OLD;
            SqlOperator sqlOperator3 = sqlOperator;
            if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                bl = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.TUMBLE_OLD;
                SqlOperator sqlOperator4 = sqlOperator;
                bl = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
            }
        }
        boolean bl2 = bl;
        return bl2;
    }

    private Buffer<AggregateCall> adjustTypes(LogicalAggregate agg, scala.collection.immutable.Map<Object, RelDataType> indexAndTypes) {
        return (Buffer)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(agg.getAggCallList()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AggregateCall aggCall = (AggregateCall)tuple2._1();
            int index = tuple2._2$mcI$sp();
            AggregateCall aggregateCall = JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)indexAndTypes).containsKey(BoxesRunTime.boxToInteger((int)index)) ? AggregateCall.create(aggCall.getAggregation(), aggCall.isDistinct(), aggCall.isApproximate(), aggCall.ignoreNulls(), aggCall.getArgList(), aggCall.filterArg, aggCall.collation, agg.getGroupCount(), agg.getInput(), (RelDataType)indexAndTypes.apply((Object)BoxesRunTime.boxToInteger((int)index)), aggCall.name) : aggCall;
            return aggregateCall;
        }, Buffer$.MODULE$.canBuildFrom());
    }

    private scala.collection.immutable.Map<Object, RelDataType> getIndexAndInferredTypesIfChanged(LogicalAggregate agg) {
        return ((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(agg.getAggCallList()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AggregateCall aggCall = (AggregateCall)tuple2._1();
            int index = tuple2._2$mcI$sp();
            RelDataType origType = aggCall.type;
            Aggregate.AggCallBinding aggCallBinding = new Aggregate.AggCallBinding(agg.getCluster().getTypeFactory(), aggCall.getAggregation(), SqlTypeUtil.projectTypes(agg.getInput().getRowType(), aggCall.getArgList()), 0, aggCall.hasFilter());
            RelDataType inferredType = aggCall.getAggregation().inferReturnType(aggCallBinding);
            RelDataType relDataType = origType;
            RelDataType relDataType2 = inferredType;
            Iterable iterable = (relDataType == null ? relDataType2 != null : !relDataType.equals(relDataType2)) && agg.getGroupCount() == 1 ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), (Object)inferredType))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            return iterable;
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Tuple2<RexCall, Object>> getWindowExpressions(LogicalAggregate agg, LogicalProject project) {
        ImmutableBitSet groupKeys = agg.getGroupSet();
        Buffer groupExpr = (Buffer)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(project.getProjects()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)groupKeys.get(p._2$mcI$sp())));
        return (Seq)((TraversableLike)groupExpr.filter((Function1 & Serializable & scala.Serializable)g -> BoxesRunTime.boxToBoolean((boolean)LogicalWindowAggregateRuleBase.$anonfun$getWindowExpressions$2(g)))).map((Function1 & Serializable & scala.Serializable)w -> new Tuple2((Object)((RexCall)w._1()), (Object)BoxesRunTime.boxToInteger((int)w._2$mcI$sp())), Buffer$.MODULE$.canBuildFrom());
    }

    public abstract RexNode getInAggregateGroupExpression(RexBuilder var1, RexCall var2);

    public abstract RexNode getOutAggregateGroupExpression(RexBuilder var1, RexCall var2);

    public LogicalWindow translateWindow(RexCall windowExpr, int windowExprIdx, RelDataType rowType) {
        LogicalWindow logicalWindow;
        FieldReferenceExpression timeField = this.getTimeFieldReference(windowExpr.getOperands().get(0), windowExprIdx, rowType);
        LogicalType resultType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(timeField.getOutputDataType());
        PlannerWindowReference windowRef = new PlannerWindowReference("w$", resultType);
        SqlOperator sqlOperator = windowExpr.getOperator();
        SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE_OLD;
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
            long interval = this.getOperandAsLong(windowExpr, 1);
            logicalWindow = new TumblingGroupWindow(windowRef, timeField, ApiExpressionUtils.intervalOfMillis(interval));
        } else {
            SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_OLD;
            SqlOperator sqlOperator3 = sqlOperator;
            if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(this.getOperandAsLong(windowExpr, 1), this.getOperandAsLong(windowExpr, 2));
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                long slide = sp2._1$mcJ$sp();
                long size = sp2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(slide, size);
                Tuple2.mcJJ.sp sp4 = sp3;
                long slide2 = sp4._1$mcJ$sp();
                long size2 = sp4._2$mcJ$sp();
                logicalWindow = new SlidingGroupWindow(windowRef, timeField, ApiExpressionUtils.intervalOfMillis(size2), ApiExpressionUtils.intervalOfMillis(slide2));
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION_OLD;
                SqlOperator sqlOperator4 = sqlOperator;
                if (!(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null)) {
                    long gap = this.getOperandAsLong(windowExpr, 1);
                    logicalWindow = new SessionGroupWindow(windowRef, timeField, ApiExpressionUtils.intervalOfMillis(gap));
                } else {
                    throw new MatchError((Object)sqlOperator);
                }
            }
        }
        return logicalWindow;
    }

    public abstract FieldReferenceExpression getTimeFieldReference(RexNode var1, int var2, RelDataType var3);

    public abstract long getOperandAsLong(RexCall var1, int var2);

    public static final /* synthetic */ boolean $anonfun$getWindowExpressions$2(Tuple2 g) {
        boolean bl;
        RexNode rexNode = (RexNode)g._1();
        if (rexNode instanceof RexCall) {
            boolean bl2;
            RexCall rexCall = (RexCall)rexNode;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE_OLD;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                if (rexCall.getOperands().size() != 2) {
                    throw new TableException("TUMBLE window with alignment is not supported yet.");
                }
                bl2 = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_OLD;
                SqlOperator sqlOperator3 = sqlOperator;
                if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                    if (rexCall.getOperands().size() != 3) {
                        throw new TableException("HOP window with alignment is not supported yet.");
                    }
                    bl2 = true;
                } else {
                    SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION_OLD;
                    SqlOperator sqlOperator4 = sqlOperator;
                    if (!(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null)) {
                        if (rexCall.getOperands().size() != 2) {
                            throw new TableException("SESSION window with alignment is not supported yet.");
                        }
                        bl2 = true;
                    } else {
                        bl2 = false;
                    }
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public LogicalWindowAggregateRuleBase(String description) {
        super(RelOptRule.operand(LogicalAggregate.class, RelOptRule.operand(LogicalProject.class, RelOptRule.none()), new RelOptRuleOperand[0]), description);
    }
}

