/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.List;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.utils.JoinUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.runtime.operators.join.stream.AbstractStreamingJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.StreamingJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.StreamingSemiAntiJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinInputSideSpec;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamExecJoin
extends ExecNodeBase<RowData>
implements StreamExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String FIELD_NAME_JOIN_SPEC = "joinSpec";
    public static final String FIELD_NAME_LEFT_UNIQUE_KEYS = "leftUniqueKeys";
    public static final String FIELD_NAME_RIGHT_UNIQUE_KEYS = "rightUniqueKeys";
    @JsonProperty(value="joinSpec")
    private final JoinSpec joinSpec;
    @JsonProperty(value="leftUniqueKeys")
    private final List<int[]> leftUniqueKeys;
    @JsonProperty(value="rightUniqueKeys")
    private final List<int[]> rightUniqueKeys;

    public StreamExecJoin(JoinSpec joinSpec, List<int[]> leftUniqueKeys, List<int[]> rightUniqueKeys, InputProperty leftInputProperty, InputProperty rightInputProperty, RowType outputType, String description) {
        this(joinSpec, leftUniqueKeys, rightUniqueKeys, StreamExecJoin.getNewNodeId(), Lists.newArrayList((Object[])new InputProperty[]{leftInputProperty, rightInputProperty}), outputType, description);
    }

    @JsonCreator
    public StreamExecJoin(@JsonProperty(value="joinSpec") JoinSpec joinSpec, @JsonProperty(value="leftUniqueKeys") List<int[]> leftUniqueKeys, @JsonProperty(value="rightUniqueKeys") List<int[]> rightUniqueKeys, @JsonProperty(value="id") int id, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, inputProperties, outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 2 ? 1 : 0) != 0);
        this.joinSpec = (JoinSpec)Preconditions.checkNotNull((Object)joinSpec);
        this.leftUniqueKeys = leftUniqueKeys;
        this.rightUniqueKeys = rightUniqueKeys;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        AbstractStreamingJoinOperator operator;
        ExecEdge leftInputEdge = this.getInputEdges().get(0);
        ExecEdge rightInputEdge = this.getInputEdges().get(1);
        Transformation<?> leftTransform = leftInputEdge.translateToPlan(planner);
        Transformation<?> rightTransform = rightInputEdge.translateToPlan(planner);
        RowType leftType = (RowType)leftInputEdge.getOutputType();
        RowType rightType = (RowType)rightInputEdge.getOutputType();
        JoinUtil.validateJoinSpec(this.joinSpec, leftType, rightType, true);
        int[] leftJoinKey = this.joinSpec.getLeftKeys();
        int[] rightJoinKey = this.joinSpec.getRightKeys();
        InternalTypeInfo<RowData> leftTypeInfo = InternalTypeInfo.of(leftType);
        JoinInputSideSpec leftInputSpec = JoinUtil.analyzeJoinInput(leftTypeInfo, leftJoinKey, this.leftUniqueKeys);
        InternalTypeInfo<RowData> rightTypeInfo = InternalTypeInfo.of(rightType);
        JoinInputSideSpec rightInputSpec = JoinUtil.analyzeJoinInput(rightTypeInfo, rightJoinKey, this.rightUniqueKeys);
        TableConfig tableConfig = planner.getTableConfig();
        GeneratedJoinCondition generatedCondition = JoinUtil.generateConditionFunction(tableConfig, this.joinSpec, (LogicalType)leftType, (LogicalType)rightType);
        long minRetentionTime = tableConfig.getMinIdleStateRetentionTime();
        FlinkJoinType joinType = this.joinSpec.getJoinType();
        if (joinType == FlinkJoinType.ANTI || joinType == FlinkJoinType.SEMI) {
            operator = new StreamingSemiAntiJoinOperator(joinType == FlinkJoinType.ANTI, leftTypeInfo, rightTypeInfo, generatedCondition, leftInputSpec, rightInputSpec, this.joinSpec.getFilterNulls(), minRetentionTime);
        } else {
            boolean leftIsOuter = joinType == FlinkJoinType.LEFT || joinType == FlinkJoinType.FULL;
            boolean rightIsOuter = joinType == FlinkJoinType.RIGHT || joinType == FlinkJoinType.FULL;
            operator = new StreamingJoinOperator(leftTypeInfo, rightTypeInfo, generatedCondition, leftInputSpec, rightInputSpec, leftIsOuter, rightIsOuter, this.joinSpec.getFilterNulls(), minRetentionTime);
        }
        RowType returnType = (RowType)this.getOutputType();
        TwoInputTransformation transform = new TwoInputTransformation(leftTransform, rightTransform, this.getDescription(), (TwoInputStreamOperator)operator, InternalTypeInfo.of(returnType), leftTransform.getParallelism());
        RowDataKeySelector leftSelect = KeySelectorUtil.getRowDataSelector(leftJoinKey, leftTypeInfo);
        RowDataKeySelector rightSelect = KeySelectorUtil.getRowDataSelector(rightJoinKey, rightTypeInfo);
        transform.setStateKeySelectors((KeySelector)leftSelect, (KeySelector)rightSelect);
        transform.setStateKeyType(leftSelect.getProducedType());
        return transform;
    }
}

