/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexWindowBoundJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexWindowBoundJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.spec.PartitionSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.util.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public class OverSpec {
    public static final String FIELD_NAME_PARTITION = "partition";
    public static final String FIELD_NAME_GROUPS = "groups";
    public static final String FIELD_NAME_CONSTANTS = "constants";
    public static final String FIELD_NAME_ORIGINAL_INPUT_FIELDS = "originalInputFields";
    @JsonProperty(value="partition")
    private final PartitionSpec partition;
    @JsonProperty(value="groups")
    private final List<GroupSpec> groups;
    @JsonProperty(value="constants")
    private final List<RexLiteral> constants;
    @JsonProperty(value="originalInputFields")
    private final int originalInputFields;

    @JsonCreator
    public OverSpec(@JsonProperty(value="partition") PartitionSpec partition, @JsonProperty(value="groups") List<GroupSpec> groups, @JsonProperty(value="constants") List<RexLiteral> constants, @JsonProperty(value="originalInputFields") int originalInputFields) {
        this.partition = (PartitionSpec)Preconditions.checkNotNull((Object)partition);
        this.groups = (List)Preconditions.checkNotNull(groups);
        this.constants = (List)Preconditions.checkNotNull(constants);
        this.originalInputFields = originalInputFields;
    }

    @JsonIgnore
    public PartitionSpec getPartition() {
        return this.partition;
    }

    @JsonIgnore
    public List<GroupSpec> getGroups() {
        return this.groups;
    }

    @JsonIgnore
    public List<RexLiteral> getConstants() {
        return this.constants;
    }

    @JsonIgnore
    public int getOriginalInputFields() {
        return this.originalInputFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OverSpec overSpec = (OverSpec)o;
        return this.originalInputFields == overSpec.originalInputFields && this.partition.equals(overSpec.partition) && this.groups.equals(overSpec.groups) && this.constants.equals(overSpec.constants);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.groups, this.constants, this.originalInputFields);
    }

    public String toString() {
        return "Over{partition=" + this.partition + ", groups=" + this.groups + ", constants=" + this.constants + ", originalInputFields=" + this.originalInputFields + '}';
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class GroupSpec {
        public static final String FIELD_NAME_SORT_SPEC = "orderBy";
        public static final String FIELD_NAME_IS_ROWS = "isRows";
        public static final String FIELD_NAME_LOWER_BOUND = "lowerBound";
        public static final String FIELD_NAME_UPPER_BOUND = "upperBound";
        public static final String FIELD_NAME_AGG_CALLS = "aggCalls";
        @JsonProperty(value="orderBy")
        private final SortSpec sort;
        @JsonProperty(value="isRows")
        private final boolean isRows;
        @JsonProperty(value="lowerBound")
        @JsonSerialize(using=RexWindowBoundJsonSerializer.class)
        @JsonDeserialize(using=RexWindowBoundJsonDeserializer.class)
        private final RexWindowBound lowerBound;
        @JsonProperty(value="upperBound")
        @JsonSerialize(using=RexWindowBoundJsonSerializer.class)
        @JsonDeserialize(using=RexWindowBoundJsonDeserializer.class)
        private final RexWindowBound upperBound;
        @JsonProperty(value="aggCalls")
        private final List<AggregateCall> aggCalls;

        @JsonCreator
        public GroupSpec(@JsonProperty(value="orderBy") SortSpec sort, @JsonProperty(value="isRows") boolean isRows, @JsonProperty(value="lowerBound") RexWindowBound lowerBound, @JsonProperty(value="upperBound") RexWindowBound upperBound, @JsonProperty(value="aggCalls") List<AggregateCall> aggCalls) {
            this.sort = (SortSpec)Preconditions.checkNotNull((Object)sort);
            this.isRows = isRows;
            this.lowerBound = (RexWindowBound)Preconditions.checkNotNull((Object)lowerBound);
            this.upperBound = (RexWindowBound)Preconditions.checkNotNull((Object)upperBound);
            this.aggCalls = (List)Preconditions.checkNotNull(aggCalls);
        }

        @JsonIgnore
        public SortSpec getSort() {
            return this.sort;
        }

        @JsonIgnore
        public boolean isRows() {
            return this.isRows;
        }

        @JsonIgnore
        public RexWindowBound getLowerBound() {
            return this.lowerBound;
        }

        @JsonIgnore
        public RexWindowBound getUpperBound() {
            return this.upperBound;
        }

        @JsonIgnore
        public List<AggregateCall> getAggCalls() {
            return this.aggCalls;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupSpec groupSpec = (GroupSpec)o;
            return this.isRows == groupSpec.isRows && this.sort.equals(groupSpec.sort) && this.lowerBound.equals(groupSpec.lowerBound) && this.upperBound.equals(groupSpec.upperBound) && this.aggCalls.equals(groupSpec.aggCalls);
        }

        public int hashCode() {
            return Objects.hash(this.sort, this.isRows, this.lowerBound, this.upperBound, this.aggCalls);
        }

        public String toString() {
            return "Group{sort=" + this.sort + ", isRows=" + this.isRows + ", lowerBound=" + this.lowerBound + ", upperBound=" + this.upperBound + ", aggCalls=" + this.aggCalls + '}';
        }
    }
}

