/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.util.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JoinSpec {
    public static final String FIELD_NAME_JOIN_TYPE = "joinType";
    public static final String FIELD_NAME_LEFT_KEYS = "leftKeys";
    public static final String FIELD_NAME_RIGHT_KEYS = "rightKeys";
    public static final String FIELD_NAME_FILTER_NULLS = "filterNulls";
    public static final String FIELD_NAME_NON_EQUI_CONDITION = "nonEquiCondition";
    @JsonProperty(value="joinType")
    private final FlinkJoinType joinType;
    @JsonProperty(value="leftKeys")
    private final int[] leftKeys;
    @JsonProperty(value="rightKeys")
    private final int[] rightKeys;
    @JsonProperty(value="filterNulls")
    private final boolean[] filterNulls;
    @JsonProperty(value="nonEquiCondition")
    @Nullable
    private final RexNode nonEquiCondition;

    @JsonCreator
    public JoinSpec(@JsonProperty(value="joinType") FlinkJoinType joinType, @JsonProperty(value="leftKeys") int[] leftKeys, @JsonProperty(value="rightKeys") int[] rightKeys, @JsonProperty(value="filterNulls") boolean[] filterNulls, @JsonProperty(value="nonEquiCondition") @Nullable RexNode nonEquiCondition) {
        this.joinType = (FlinkJoinType)((Object)Preconditions.checkNotNull((Object)((Object)joinType)));
        this.leftKeys = (int[])Preconditions.checkNotNull((Object)leftKeys);
        this.rightKeys = (int[])Preconditions.checkNotNull((Object)rightKeys);
        this.filterNulls = (boolean[])Preconditions.checkNotNull((Object)filterNulls);
        Preconditions.checkArgument((leftKeys.length == rightKeys.length ? 1 : 0) != 0);
        Preconditions.checkArgument((leftKeys.length == filterNulls.length ? 1 : 0) != 0);
        this.nonEquiCondition = null != nonEquiCondition && nonEquiCondition.isAlwaysTrue() ? null : nonEquiCondition;
    }

    @JsonIgnore
    public FlinkJoinType getJoinType() {
        return this.joinType;
    }

    @JsonIgnore
    public int[] getLeftKeys() {
        return this.leftKeys;
    }

    @JsonIgnore
    public int[] getRightKeys() {
        return this.rightKeys;
    }

    @JsonIgnore
    public boolean[] getFilterNulls() {
        return this.filterNulls;
    }

    @JsonIgnore
    public Optional<RexNode> getNonEquiCondition() {
        return Optional.ofNullable(this.nonEquiCondition);
    }

    @JsonIgnore
    public int getJoinKeySize() {
        return this.leftKeys.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinSpec joinSpec = (JoinSpec)o;
        return this.joinType == joinSpec.joinType && Arrays.equals(this.leftKeys, joinSpec.leftKeys) && Arrays.equals(this.rightKeys, joinSpec.rightKeys) && Arrays.equals(this.filterNulls, joinSpec.filterNulls) && Objects.equals(this.nonEquiCondition, joinSpec.nonEquiCondition);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.joinType, this.nonEquiCondition});
        result = 31 * result + Arrays.hashCode(this.leftKeys);
        result = 31 * result + Arrays.hashCode(this.rightKeys);
        result = 31 * result + Arrays.hashCode(this.filterNulls);
        return result;
    }
}

