/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.Sarg;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.calcite.shaded.com.google.common.collect.BoundType;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableRangeSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.Range;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.module.CoreModule;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction;
import org.apache.flink.table.planner.plan.nodes.exec.serde.FlinkDeserializationContext;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

public class RexNodeJsonDeserializer
extends StdDeserializer<RexNode> {
    private static final long serialVersionUID = 1L;

    public RexNodeJsonDeserializer() {
        super(RexNode.class);
    }

    public RexNode deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException, JsonProcessingException {
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        return this.deserializeRexNode(jsonNode, (FlinkDeserializationContext)ctx);
    }

    private RexNode deserializeRexNode(JsonNode jsonNode, FlinkDeserializationContext ctx) throws IOException {
        String kind;
        switch (kind = jsonNode.get("kind").asText().toUpperCase()) {
            case "INPUT_REF": {
                return this.deserializeInputRef(jsonNode, ctx);
            }
            case "LITERAL": {
                return this.deserializeLiteral(jsonNode, ctx);
            }
            case "FIELD_ACCESS": {
                return this.deserializeFieldAccess(jsonNode, ctx);
            }
            case "CORREL_VARIABLE": {
                return this.deserializeCorrelVariable(jsonNode, ctx);
            }
            case "REX_CALL": {
                return this.deserializeCall(jsonNode, ctx);
            }
            case "PATTERN_INPUT_REF": {
                return this.deserializePatternInputRef(jsonNode, ctx);
            }
        }
        throw new TableException("Cannot convert to RexNode: " + jsonNode.toPrettyString());
    }

    private RexNode deserializeInputRef(JsonNode jsonNode, FlinkDeserializationContext ctx) throws JsonProcessingException {
        int inputIndex = jsonNode.get("inputIndex").intValue();
        JsonNode typeNode = jsonNode.get("type");
        RelDataType fieldType = (RelDataType)ctx.getObjectMapper().readValue(typeNode.toPrettyString(), RelDataType.class);
        return ctx.getSerdeContext().getRexBuilder().makeInputRef(fieldType, inputIndex);
    }

    private RexNode deserializePatternInputRef(JsonNode jsonNode, FlinkDeserializationContext ctx) throws JsonProcessingException {
        int inputIndex = jsonNode.get("inputIndex").intValue();
        String alpha = jsonNode.get("alpha").asText();
        JsonNode typeNode = jsonNode.get("type");
        RelDataType fieldType = (RelDataType)ctx.getObjectMapper().readValue(typeNode.toPrettyString(), RelDataType.class);
        return ctx.getSerdeContext().getRexBuilder().makePatternFieldRef(alpha, fieldType, inputIndex);
    }

    private RexNode deserializeLiteral(JsonNode jsonNode, FlinkDeserializationContext ctx) throws IOException {
        RexBuilder rexBuilder = ctx.getSerdeContext().getRexBuilder();
        JsonNode typeNode = jsonNode.get("type");
        RelDataType literalType = (RelDataType)ctx.getObjectMapper().readValue(typeNode.toPrettyString(), RelDataType.class);
        if (jsonNode.has("sarg")) {
            Sarg<?> sarg = this.toSarg(jsonNode.get("sarg"), literalType.getSqlTypeName(), ctx);
            return rexBuilder.makeSearchArgumentLiteral(sarg, literalType);
        }
        if (jsonNode.has("value")) {
            JsonNode literalNode = jsonNode.get("value");
            if (literalNode.isNull()) {
                return rexBuilder.makeNullLiteral(literalType);
            }
            Object literal = this.toLiteralValue(jsonNode, literalType.getSqlTypeName(), ctx);
            return rexBuilder.makeLiteral(literal, literalType, true);
        }
        throw new TableException("Unknown literal: " + jsonNode.toPrettyString());
    }

    private Object toLiteralValue(JsonNode literalNode, SqlTypeName sqlTypeName, FlinkDeserializationContext ctx) throws IOException {
        JsonNode valueNode = literalNode.get("value");
        if (valueNode.isNull()) {
            return null;
        }
        switch (sqlTypeName) {
            case BOOLEAN: {
                return valueNode.booleanValue();
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: 
            case REAL: 
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                return new BigDecimal(valueNode.asText());
            }
            case DATE: {
                return new DateString(valueNode.asText());
            }
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: {
                return new TimeString(valueNode.asText());
            }
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new TimestampString(valueNode.asText());
            }
            case BINARY: 
            case VARBINARY: {
                return ByteString.ofBase64(valueNode.asText());
            }
            case CHAR: 
            case VARCHAR: {
                return ctx.getSerdeContext().getRexBuilder().makeLiteral(valueNode.asText()).getValue();
            }
            case SYMBOL: {
                JsonNode classNode = literalNode.get("class");
                return RexNodeJsonDeserializer.getEnum(classNode.asText(), valueNode.asText(), ctx.getSerdeContext().getClassLoader());
            }
            case ROW: 
            case MULTISET: {
                ArrayNode valuesNode = (ArrayNode)valueNode;
                ArrayList<RexNode> list = new ArrayList<RexNode>();
                for (int i = 0; i < valuesNode.size(); ++i) {
                    list.add(this.deserializeRexNode(valuesNode.get(i), ctx));
                }
                return list;
            }
        }
        throw new TableException("Unknown literal: " + valueNode);
    }

    private static <T extends Enum<T>> T getEnum(String clazz, String name, ClassLoader classLoader) {
        try {
            Class<?> c = Class.forName(clazz, true, classLoader);
            return (T)Enum.valueOf(c, name);
        }
        catch (ClassNotFoundException e) {
            throw new TableException("Unknown class: " + clazz);
        }
    }

    private Sarg<?> toSarg(JsonNode jsonNode, SqlTypeName sqlTypeName, FlinkDeserializationContext ctx) throws IOException {
        ArrayNode rangesNode = (ArrayNode)jsonNode.get("ranges");
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (JsonNode rangeNode : rangesNode) {
            Range<Comparable> r;
            BoundType boundType;
            Comparable boundValue;
            Range<Object> range = Range.all();
            if (rangeNode.has("lower")) {
                JsonNode lowerNode = rangeNode.get("lower");
                boundValue = (Comparable)Preconditions.checkNotNull((Object)((Comparable)this.toLiteralValue(lowerNode, sqlTypeName, ctx)));
                boundType = BoundType.valueOf(lowerNode.get("boundType").asText().toUpperCase());
                r = boundType == BoundType.OPEN ? Range.greaterThan(boundValue) : Range.atLeast(boundValue);
                range = range.intersection(r);
            }
            if (rangeNode.has("upper")) {
                JsonNode upperNode = rangeNode.get("upper");
                boundValue = (Comparable)Preconditions.checkNotNull((Object)((Comparable)this.toLiteralValue(upperNode, sqlTypeName, ctx)));
                boundType = BoundType.valueOf(upperNode.get("boundType").asText().toUpperCase());
                r = boundType == BoundType.OPEN ? Range.lessThan(boundValue) : Range.atMost(boundValue);
                range = range.intersection(r);
            }
            if (!range.hasUpperBound() && !range.hasLowerBound()) continue;
            builder.add(range);
        }
        boolean containsNull = jsonNode.get("containsNull").booleanValue();
        return Sarg.of(containsNull, builder.build());
    }

    private RexNode deserializeFieldAccess(JsonNode jsonNode, FlinkDeserializationContext ctx) throws IOException {
        String fieldName = jsonNode.get("name").asText();
        JsonNode exprNode = jsonNode.get("expr");
        RexNode refExpr = this.deserializeRexNode(exprNode, ctx);
        return ctx.getSerdeContext().getRexBuilder().makeFieldAccess(refExpr, fieldName, true);
    }

    private RexNode deserializeCorrelVariable(JsonNode jsonNode, FlinkDeserializationContext ctx) throws JsonProcessingException {
        String correl = jsonNode.get("correl").asText();
        JsonNode typeNode = jsonNode.get("type");
        RelDataType fieldType = (RelDataType)ctx.getObjectMapper().readValue(typeNode.toPrettyString(), RelDataType.class);
        return ctx.getSerdeContext().getRexBuilder().makeCorrel(fieldType, new CorrelationId(correl));
    }

    private RexNode deserializeCall(JsonNode jsonNode, FlinkDeserializationContext ctx) throws IOException {
        RelDataType callType;
        RexBuilder rexBuilder = ctx.getSerdeContext().getRexBuilder();
        SqlOperator operator = this.toOperator(jsonNode.get("operator"), ctx.getSerdeContext());
        ArrayNode operandNodes = (ArrayNode)jsonNode.get("operands");
        ArrayList<RexNode> rexOperands = new ArrayList<RexNode>();
        for (JsonNode node : operandNodes) {
            rexOperands.add(this.deserializeRexNode(node, ctx));
        }
        if (jsonNode.has("type")) {
            JsonNode typeNode = jsonNode.get("type");
            callType = (RelDataType)ctx.getObjectMapper().readValue(typeNode.toPrettyString(), RelDataType.class);
        } else {
            callType = rexBuilder.deriveReturnType(operator, rexOperands);
        }
        return rexBuilder.makeCall(callType, operator, rexOperands);
    }

    private SqlOperator toOperator(JsonNode jsonNode, SerdeContext ctx) throws IOException {
        String name = jsonNode.get("name").asText();
        SqlKind sqlKind = SqlKind.valueOf(jsonNode.get("kind").asText());
        SqlSyntax sqlSyntax = SqlSyntax.valueOf(jsonNode.get("syntax").asText());
        ArrayList<SqlOperator> operators = new ArrayList<SqlOperator>();
        ctx.getOperatorTable().lookupOperatorOverloads(new SqlIdentifier(name, new SqlParserPos(0, 0)), null, sqlSyntax, operators, SqlNameMatchers.liberal());
        for (SqlOperator operator : operators) {
            if (operator.kind != sqlKind) continue;
            return operator;
        }
        SqlStdOperatorTable.instance().lookupOperatorOverloads(new SqlIdentifier(name, new SqlParserPos(0, 0)), null, sqlSyntax, operators, SqlNameMatchers.liberal());
        for (SqlOperator operator : operators) {
            if (operator.kind != sqlKind) continue;
            return operator;
        }
        if (jsonNode.has("builtIn") && jsonNode.get("builtIn").booleanValue()) {
            Optional<FunctionDefinition> function = CoreModule.INSTANCE.getFunctionDefinition(name);
            Preconditions.checkArgument((boolean)function.isPresent());
            return BridgingSqlFunction.of(ctx.getFlinkContext(), ctx.getTypeFactory(), FunctionIdentifier.of(name), function.get());
        }
        if (jsonNode.has("functionKind") && jsonNode.has("instance")) {
            FunctionKind functionKind = FunctionKind.valueOf(jsonNode.get("functionKind").asText().toUpperCase());
            String instanceStr = jsonNode.get("instance").asText();
            if (functionKind != FunctionKind.SCALAR) {
                throw new TableException("Unknown function kind: " + (Object)((Object)functionKind));
            }
            if (jsonNode.has("bridging") && jsonNode.get("bridging").booleanValue()) {
                FunctionDefinition function = (FunctionDefinition)EncodingUtils.decodeStringToObject(instanceStr, ctx.getClassLoader());
                return BridgingSqlFunction.of(ctx.getFlinkContext(), ctx.getTypeFactory(), FunctionIdentifier.of(name), function);
            }
            String displayName = jsonNode.get("displayName").asText();
            ScalarFunction function = (ScalarFunction)EncodingUtils.decodeStringToObject(instanceStr, ctx.getClassLoader());
            return new ScalarSqlFunction(FunctionIdentifier.of(name), displayName, function, ctx.getTypeFactory(), JavaScalaConversionUtil.toScala(Optional.empty()));
        }
        throw new TableException("Unknown operator: " + jsonNode.toPrettyString());
    }
}

