/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.planner.plan.schema.GenericRelDataType;
import org.apache.flink.table.planner.plan.schema.RawRelDataType;
import org.apache.flink.table.planner.plan.schema.StructuredRelDataType;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.utils.EncodingUtils;

public class RelDataTypeJsonSerializer
extends StdSerializer<RelDataType> {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_NAME_TYPE_NAME = "typeName";
    public static final String FIELD_NAME_FILED_NAME = "fieldName";
    public static final String FIELD_NAME_NULLABLE = "nullable";
    public static final String FIELD_NAME_PRECISION = "precision";
    public static final String FIELD_NAME_SCALE = "scale";
    public static final String FIELD_NAME_FIELDS = "fields";
    public static final String FIELD_NAME_STRUCT_KIND = "structKind";
    public static final String FIELD_NAME_TIMESTAMP_KIND = "timestampKind";
    public static final String FIELD_NAME_ELEMENT = "element";
    public static final String FIELD_NAME_KEY = "key";
    public static final String FIELD_NAME_VALUE = "value";
    public static final String FIELD_NAME_TYPE_INFO = "typeInfo";
    public static final String FIELD_NAME_RAW_TYPE = "rawType";
    public static final String FIELD_NAME_STRUCTURED_TYPE = "structuredType";

    public RelDataTypeJsonSerializer() {
        super(RelDataType.class);
    }

    public void serialize(RelDataType relDataType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        this.serialize(relDataType, jsonGenerator);
        jsonGenerator.writeEndObject();
    }

    private void serialize(RelDataType relDataType, JsonGenerator gen) throws IOException {
        if (relDataType instanceof TimeIndicatorRelDataType) {
            TimeIndicatorRelDataType timeIndicatorType = (TimeIndicatorRelDataType)relDataType;
            gen.writeStringField(FIELD_NAME_TIMESTAMP_KIND, timeIndicatorType.isEventTime() ? TimestampKind.ROWTIME.name() : TimestampKind.PROCTIME.name());
            gen.writeStringField(FIELD_NAME_TYPE_NAME, timeIndicatorType.originalType().getSqlTypeName().name());
            gen.writeBooleanField(FIELD_NAME_NULLABLE, relDataType.isNullable());
        } else if (relDataType instanceof StructuredRelDataType) {
            StructuredRelDataType structuredType = (StructuredRelDataType)relDataType;
            gen.writeObjectField(FIELD_NAME_STRUCTURED_TYPE, (Object)structuredType.getStructuredType());
        } else if (relDataType.isStruct()) {
            gen.writeStringField(FIELD_NAME_STRUCT_KIND, relDataType.getStructKind().name());
            gen.writeBooleanField(FIELD_NAME_NULLABLE, relDataType.isNullable());
            gen.writeFieldName(FIELD_NAME_FIELDS);
            gen.writeStartArray();
            for (RelDataTypeField field : relDataType.getFieldList()) {
                gen.writeStartObject();
                this.serialize(field.getType(), gen);
                gen.writeStringField(FIELD_NAME_FILED_NAME, field.getName());
                gen.writeEndObject();
            }
            gen.writeEndArray();
        } else if (relDataType.getSqlTypeName() == SqlTypeName.ARRAY) {
            this.serializeCommon(relDataType, gen);
            ArraySqlType arraySqlType = (ArraySqlType)relDataType;
            gen.writeFieldName(FIELD_NAME_ELEMENT);
            gen.writeStartObject();
            this.serialize(arraySqlType.getComponentType(), gen);
            gen.writeEndObject();
        } else if (relDataType.getSqlTypeName() == SqlTypeName.MULTISET) {
            assert (relDataType instanceof MultisetSqlType);
            this.serializeCommon(relDataType, gen);
            MultisetSqlType multisetSqlType = (MultisetSqlType)relDataType;
            gen.writeFieldName(FIELD_NAME_ELEMENT);
            gen.writeStartObject();
            this.serialize(multisetSqlType.getComponentType(), gen);
            gen.writeEndObject();
        } else if (relDataType.getSqlTypeName() == SqlTypeName.MAP) {
            assert (relDataType instanceof MapSqlType);
            this.serializeCommon(relDataType, gen);
            MapSqlType mapSqlType = (MapSqlType)relDataType;
            gen.writeFieldName(FIELD_NAME_KEY);
            gen.writeStartObject();
            this.serialize(mapSqlType.getKeyType(), gen);
            gen.writeEndObject();
            gen.writeFieldName(FIELD_NAME_VALUE);
            gen.writeStartObject();
            this.serialize(mapSqlType.getValueType(), gen);
            gen.writeEndObject();
        } else if (relDataType instanceof GenericRelDataType) {
            assert (relDataType.getSqlTypeName() == SqlTypeName.ANY);
            this.serializeCommon(relDataType, gen);
            TypeInformationRawType<?> rawType = ((GenericRelDataType)relDataType).genericType();
            gen.writeFieldName(FIELD_NAME_RAW_TYPE);
            gen.writeStartObject();
            gen.writeBooleanField(FIELD_NAME_NULLABLE, rawType.isNullable());
            gen.writeStringField(FIELD_NAME_TYPE_INFO, EncodingUtils.encodeObjectToString(rawType.getTypeInformation()));
            gen.writeEndObject();
        } else if (relDataType instanceof RawRelDataType) {
            assert (relDataType.getSqlTypeName() == SqlTypeName.OTHER);
            this.serializeCommon(relDataType, gen);
            RawRelDataType rawType = (RawRelDataType)relDataType;
            gen.writeStringField(FIELD_NAME_RAW_TYPE, rawType.getRawType().asSerializableString());
        } else {
            this.serializeCommon(relDataType, gen);
        }
    }

    private void serializeCommon(RelDataType relDataType, JsonGenerator gen) throws IOException {
        SqlTypeName typeName = relDataType.getSqlTypeName();
        gen.writeStringField(FIELD_NAME_TYPE_NAME, typeName.name());
        gen.writeBooleanField(FIELD_NAME_NULLABLE, relDataType.isNullable());
        if (relDataType.getSqlTypeName().allowsPrec()) {
            gen.writeNumberField(FIELD_NAME_PRECISION, relDataType.getPrecision());
        }
        if (relDataType.getSqlTypeName().allowsScale()) {
            gen.writeNumberField(FIELD_NAME_SCALE, relDataType.getScale());
        }
    }
}

