/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.planner.plan.nodes.exec.serde.FlinkDeserializationContext;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ObjectIdentifierJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.typeutils.DataViewUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.SymbolType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.ZonedTimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.LogicalTypeDataTypeConverter;
import org.apache.flink.table.utils.EncodingUtils;

public class LogicalTypeJsonDeserializer
extends StdDeserializer<LogicalType> {
    private static final long serialVersionUID = 1L;

    public LogicalTypeJsonDeserializer() {
        super(LogicalType.class);
    }

    public LogicalType deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException, JsonProcessingException {
        JsonNode logicalTypeNode = (JsonNode)jsonParser.readValueAsTree();
        SerdeContext serdeCtx = ((FlinkDeserializationContext)ctx).getSerdeContext();
        return this.deserialize(logicalTypeNode, serdeCtx);
    }

    public LogicalType deserialize(JsonNode logicalTypeNode, SerdeContext serdeCtx) {
        if (logicalTypeNode.get("type") != null) {
            String typeName = logicalTypeNode.get("type").asText().toUpperCase();
            LogicalTypeRoot root = LogicalTypeRoot.valueOf(typeName);
            switch (root) {
                case CHAR: {
                    return this.deserializeCharType(logicalTypeNode);
                }
                case VARCHAR: {
                    return this.deserializeVarCharType(logicalTypeNode);
                }
                case BINARY: {
                    return this.deserializeBinaryType(logicalTypeNode);
                }
                case VARBINARY: {
                    return this.deserializeVarBinaryType(logicalTypeNode);
                }
                case DISTINCT_TYPE: {
                    return this.deserializeDistinctType(logicalTypeNode, serdeCtx);
                }
                case STRUCTURED_TYPE: {
                    return this.deserializeStructuredType(logicalTypeNode, serdeCtx);
                }
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    return this.deserializeTimestampType(logicalTypeNode);
                }
                case TIMESTAMP_WITH_TIME_ZONE: {
                    return this.deserializeZonedTimestampType(logicalTypeNode);
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    return this.deserializeLocalZonedTimestampType(logicalTypeNode);
                }
                case ROW: {
                    return this.deserializeRowType(logicalTypeNode, serdeCtx);
                }
                case MAP: {
                    return this.deserializeMapType(logicalTypeNode, serdeCtx);
                }
                case ARRAY: {
                    return this.deserializeArrayType(logicalTypeNode, serdeCtx);
                }
                case MULTISET: {
                    return this.deserializeMultisetType(logicalTypeNode, serdeCtx);
                }
                case RAW: {
                    return this.deserializeRawType(logicalTypeNode, serdeCtx);
                }
            }
            throw new TableException("Unsupported type name:" + typeName);
        }
        if (logicalTypeNode.get("symbolClass") != null) {
            return this.deserializeSymbolType(logicalTypeNode);
        }
        if (logicalTypeNode.get("typeInfo") != null) {
            return this.deserializeTypeInformationRawType(logicalTypeNode, serdeCtx);
        }
        return LogicalTypeParser.parse(logicalTypeNode.asText());
    }

    private RowType deserializeRowType(JsonNode logicalTypeNode, SerdeContext serdeCtx) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        ArrayList<RowType.RowField> rowFields = new ArrayList<RowType.RowField>();
        Iterator elements = logicalTypeNode.get("fields").elements();
        while (elements.hasNext()) {
            JsonNode node = (JsonNode)elements.next();
            String filedName = (String)node.fieldNames().next();
            LogicalType fieldType = this.deserialize(node.get(filedName), serdeCtx);
            if (node.has("description")) {
                rowFields.add(new RowType.RowField(filedName, fieldType, node.get("description").asText()));
                continue;
            }
            rowFields.add(new RowType.RowField(filedName, fieldType));
        }
        return new RowType(nullable, rowFields);
    }

    private MapType deserializeMapType(JsonNode logicalTypeNode, SerdeContext serdeCtx) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        LogicalType keyLogicalType = this.deserialize(logicalTypeNode.get("keyType"), serdeCtx);
        LogicalType valueLogicalType = this.deserialize(logicalTypeNode.get("valueType"), serdeCtx);
        return new MapType(nullable, keyLogicalType, valueLogicalType);
    }

    private ArrayType deserializeArrayType(JsonNode logicalTypeNode, SerdeContext serdeCtx) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        LogicalType elementType = this.deserialize(logicalTypeNode.get("elementType"), serdeCtx);
        return new ArrayType(nullable, elementType);
    }

    private MultisetType deserializeMultisetType(JsonNode logicalTypeNode, SerdeContext serdeCtx) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        LogicalType elementType = this.deserialize(logicalTypeNode.get("elementType"), serdeCtx);
        return new MultisetType(nullable, elementType);
    }

    private CharType deserializeCharType(JsonNode logicalTypeNode) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        int length = logicalTypeNode.get("length").asInt();
        if (length == 0) {
            return (CharType)CharType.ofEmptyLiteral().copy(nullable);
        }
        return new CharType(nullable, length);
    }

    private VarCharType deserializeVarCharType(JsonNode logicalTypeNode) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        int length = logicalTypeNode.get("length").asInt();
        if (length == 0) {
            return (VarCharType)VarCharType.ofEmptyLiteral().copy(nullable);
        }
        return new VarCharType(nullable, length);
    }

    private BinaryType deserializeBinaryType(JsonNode logicalTypeNode) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        int length = logicalTypeNode.get("length").asInt();
        if (length == 0) {
            return (BinaryType)BinaryType.ofEmptyLiteral().copy(nullable);
        }
        return new BinaryType(nullable, length);
    }

    private VarBinaryType deserializeVarBinaryType(JsonNode logicalTypeNode) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        int length = logicalTypeNode.get("length").asInt();
        if (length == 0) {
            return (VarBinaryType)VarBinaryType.ofEmptyLiteral().copy(nullable);
        }
        return new VarBinaryType(nullable, length);
    }

    private SymbolType<?> deserializeSymbolType(JsonNode logicalTypeNode) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        String className = logicalTypeNode.get("symbolClass").asText();
        try {
            Class<?> clazz = Class.forName(className);
            return new SymbolType(nullable, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new TableException("Failed to deserialize symbol type", e);
        }
    }

    private TypeInformationRawType<?> deserializeTypeInformationRawType(JsonNode logicalTypeNode, SerdeContext serdeCtx) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        String typeInfoString = logicalTypeNode.get("typeInfo").asText();
        TypeInformation typeInfo = EncodingUtils.decodeStringToObject(typeInfoString, TypeInformation.class, serdeCtx.getClassLoader());
        return new TypeInformationRawType(nullable, typeInfo);
    }

    private StructuredType deserializeStructuredType(JsonNode logicalTypeNode, SerdeContext serdeCtx) {
        String description;
        StructuredType.Builder builder;
        Class<?> implementationClass;
        ObjectIdentifier identifier;
        if (logicalTypeNode.get("identifier") != null) {
            JsonNode identifierNode = logicalTypeNode.get("identifier");
            identifier = ObjectIdentifierJsonDeserializer.deserialize(identifierNode);
        } else {
            identifier = null;
        }
        if (logicalTypeNode.get("implementationClass") != null) {
            String classString = logicalTypeNode.get("implementationClass").asText();
            try {
                implementationClass = Class.forName(classString, true, serdeCtx.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new TableException(classString + " is not found.");
            }
        } else {
            implementationClass = null;
        }
        if (identifier != null && implementationClass != null) {
            builder = StructuredType.newBuilder(identifier, implementationClass);
        } else if (identifier != null) {
            builder = StructuredType.newBuilder(identifier);
        } else if (implementationClass != null) {
            builder = StructuredType.newBuilder(implementationClass);
        } else {
            throw new TableException("This should not happen.");
        }
        ArrayList<StructuredType.StructuredAttribute> attributes = new ArrayList<StructuredType.StructuredAttribute>();
        for (JsonNode attributeNode : logicalTypeNode.get("attributes")) {
            String name = attributeNode.get("name").asText();
            LogicalType logicalType = this.deserialize(attributeNode.get("logicalType"), serdeCtx);
            description = attributeNode.get("description") != null ? attributeNode.get("description").asText() : null;
            attributes.add(new StructuredType.StructuredAttribute(name, logicalType, description));
        }
        builder.attributes(attributes);
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        builder.setNullable(nullable);
        boolean isFinal = logicalTypeNode.get("final").asBoolean();
        builder.setFinal(isFinal);
        boolean isInstantiable = logicalTypeNode.get("instantiable").asBoolean();
        builder.setInstantiable(isInstantiable);
        StructuredType.StructuredComparision comparision = StructuredType.StructuredComparision.valueOf(logicalTypeNode.get("comparision").asText().toUpperCase());
        builder.comparision(comparision);
        if (logicalTypeNode.get("supperType") != null) {
            StructuredType supperType = this.deserializeStructuredType(logicalTypeNode.get("supperType"), serdeCtx);
            builder.superType(supperType);
        }
        if (logicalTypeNode.get("description") != null) {
            description = logicalTypeNode.get("description").asText();
            builder.description(description);
        }
        return builder.build();
    }

    private DistinctType deserializeDistinctType(JsonNode logicalTypeNode, SerdeContext serdeCtx) {
        JsonNode identifierNode = logicalTypeNode.get("identifier");
        ObjectIdentifier identifier = ObjectIdentifierJsonDeserializer.deserialize(identifierNode);
        LogicalType sourceType = this.deserialize(logicalTypeNode.get("sourceType"), serdeCtx);
        DistinctType.Builder builder = DistinctType.newBuilder(identifier, sourceType);
        if (logicalTypeNode.get("description") != null) {
            String description = logicalTypeNode.get("description").asText();
            builder.description(description);
        }
        return builder.build();
    }

    private TimestampType deserializeTimestampType(JsonNode logicalTypeNode) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        int precision = logicalTypeNode.get("precision").asInt();
        TimestampKind timestampKind = TimestampKind.valueOf(logicalTypeNode.get("kind").asText());
        return new TimestampType(nullable, timestampKind, precision);
    }

    private ZonedTimestampType deserializeZonedTimestampType(JsonNode logicalTypeNode) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        int precision = logicalTypeNode.get("precision").asInt();
        TimestampKind timestampKind = TimestampKind.valueOf(logicalTypeNode.get("kind").asText());
        return new ZonedTimestampType(nullable, timestampKind, precision);
    }

    private LocalZonedTimestampType deserializeLocalZonedTimestampType(JsonNode logicalTypeNode) {
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        int precision = logicalTypeNode.get("precision").asInt();
        TimestampKind timestampKind = TimestampKind.valueOf(logicalTypeNode.get("kind").asText());
        return new LocalZonedTimestampType(nullable, timestampKind, precision);
    }

    private RawType<?> deserializeRawType(JsonNode logicalTypeNode, SerdeContext serdeCtx) {
        DataType dataViewDataType;
        if (!logicalTypeNode.has("dataViewClass")) {
            throw new TableException("Only RowType for DataView class is supported now");
        }
        boolean nullable = logicalTypeNode.get("nullable").asBoolean();
        String dataViewClass = logicalTypeNode.get("dataViewClass").asText();
        if (MapView.class.getName().equals(dataViewClass)) {
            DataType keyDataType = this.deserializeDataTypeForDataView(logicalTypeNode, "keyType", serdeCtx);
            DataType valueDataType = this.deserializeDataTypeForDataView(logicalTypeNode, "valueType", serdeCtx);
            dataViewDataType = MapView.newMapViewDataType(keyDataType, valueDataType);
        } else if (ListView.class.getName().equals(dataViewClass)) {
            DataType elementDataType = this.deserializeDataTypeForDataView(logicalTypeNode, "elementType", serdeCtx);
            dataViewDataType = ListView.newListViewDataType(elementDataType);
        } else {
            throw new TableException("Only MapView and ListView are supported now");
        }
        DataType dataType = DataViewUtils.adjustDataViews(dataViewDataType, false);
        RawType rawType = (RawType)LogicalTypeDataTypeConverter.toLogicalType(dataType);
        return (RawType)rawType.copy(nullable);
    }

    private DataType deserializeDataTypeForDataView(JsonNode logicalTypeNode, String key, SerdeContext serdeCtx) {
        JsonNode jsonNode = logicalTypeNode.get(key);
        LogicalType logicalType = this.deserialize(jsonNode.get("type"), serdeCtx);
        DataType dataType = LogicalTypeDataTypeConverter.toDataType(logicalType);
        boolean isInternalType = jsonNode.get("isInternal").asBoolean();
        if (isInternalType) {
            dataType = DataTypeUtils.toInternalDataType(dataType);
        }
        return dataType;
    }
}

