/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.Collections;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.table.connector.source.DataStreamScanProvider;
import org.apache.flink.table.connector.source.InputFormatProvider;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.SourceProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.connectors.TransformationScanProvider;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSourceSpec;
import org.apache.flink.table.runtime.connector.source.ScanRuntimeProviderContext;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public abstract class CommonExecTableSourceScan
extends ExecNodeBase<RowData>
implements MultipleTransformationTranslator<RowData> {
    public static final String FIELD_NAME_SCAN_TABLE_SOURCE = "scanTableSource";
    @JsonProperty(value="scanTableSource")
    private final DynamicTableSourceSpec tableSourceSpec;

    protected CommonExecTableSourceScan(DynamicTableSourceSpec tableSourceSpec, int id, LogicalType outputType, String description) {
        super(id, Collections.emptyList(), outputType, description);
        this.tableSourceSpec = tableSourceSpec;
    }

    public DynamicTableSourceSpec getTableSourceSpec() {
        return this.tableSourceSpec;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        StreamExecutionEnvironment env = planner.getExecEnv();
        String operatorName = this.getDescription();
        InternalTypeInfo<RowData> outputTypeInfo = InternalTypeInfo.of((RowType)this.getOutputType());
        ScanTableSource tableSource = this.tableSourceSpec.getScanTableSource(planner);
        ScanTableSource.ScanRuntimeProvider provider = tableSource.getScanRuntimeProvider(ScanRuntimeProviderContext.INSTANCE);
        if (provider instanceof SourceFunctionProvider) {
            SourceFunction<RowData> sourceFunction = ((SourceFunctionProvider)provider).createSourceFunction();
            return env.addSource(sourceFunction, operatorName, outputTypeInfo).getTransformation();
        }
        if (provider instanceof InputFormatProvider) {
            InputFormat<RowData, ?> inputFormat = ((InputFormatProvider)provider).createInputFormat();
            return this.createInputFormatTransformation(env, inputFormat, outputTypeInfo, operatorName);
        }
        if (provider instanceof SourceProvider) {
            Source<RowData, ?, ?> source = ((SourceProvider)provider).createSource();
            return env.fromSource(source, WatermarkStrategy.noWatermarks(), operatorName, outputTypeInfo).getTransformation();
        }
        if (provider instanceof DataStreamScanProvider) {
            Transformation transformation = ((DataStreamScanProvider)provider).produceDataStream(env).getTransformation();
            transformation.setOutputType(outputTypeInfo);
            return transformation;
        }
        if (provider instanceof TransformationScanProvider) {
            Transformation<RowData> transformation = ((TransformationScanProvider)provider).createTransformation();
            transformation.setOutputType(outputTypeInfo);
            return transformation;
        }
        throw new UnsupportedOperationException(provider.getClass().getSimpleName() + " is unsupported now.");
    }

    protected abstract Transformation<RowData> createInputFormatTransformation(StreamExecutionEnvironment var1, InputFormat<RowData, ?> var2, InternalTypeInfo<RowData> var3, String var4);
}

