/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.lang.reflect.Modifier;
import javax.annotation.Nullable;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecLegacySink;
import org.apache.flink.table.runtime.types.ClassLogicalTypeConverter;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecLegacySink<T>
extends CommonExecLegacySink<T>
implements BatchExecNode<Object> {
    public BatchExecLegacySink(TableSink<T> tableSink, @Nullable String[] upsertKeys, InputProperty inputProperty, LogicalType outputType, String description) {
        super(tableSink, upsertKeys, false, false, inputProperty, outputType, description);
    }

    @Override
    protected RowType checkAndConvertInputTypeIfNeeded(RowType inputRowType) {
        DataType resultDataType = this.tableSink.getConsumedDataType();
        this.validateType(resultDataType);
        return inputRowType;
    }

    private void validateType(DataType dataType) {
        Class clazz = dataType.getConversionClass();
        if (clazz == null) {
            clazz = ClassLogicalTypeConverter.getDefaultExternalClassForType(dataType.getLogicalType());
        }
        if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers()) || clazz.getCanonicalName() == null) {
            throw new TableException(String.format("Class '%s' described in type information '%s' must be static and globally accessible.", clazz, dataType));
        }
    }
}

