/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.agg.batch.AggWithoutKeysCodeGenerator;
import org.apache.flink.table.planner.codegen.agg.batch.HashAggCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedOperator;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecHashAggregate
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    private final int[] grouping;
    private final int[] auxGrouping;
    private final AggregateCall[] aggCalls;
    private final RowType aggInputRowType;
    private final boolean isMerge;
    private final boolean isFinal;

    public BatchExecHashAggregate(int[] grouping, int[] auxGrouping, AggregateCall[] aggCalls, RowType aggInputRowType, boolean isMerge, boolean isFinal, InputProperty inputProperty, RowType outputType, String description) {
        super(Collections.singletonList(inputProperty), outputType, description);
        this.grouping = grouping;
        this.auxGrouping = auxGrouping;
        this.aggCalls = aggCalls;
        this.aggInputRowType = aggInputRowType;
        this.isMerge = isMerge;
        this.isFinal = isFinal;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        GeneratedOperator<OneInputStreamOperator<RowData, RowData>> generatedOperator;
        long managedMemory;
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        RowType outputRowType = (RowType)this.getOutputType();
        TableConfig config = planner.getTableConfig();
        CodeGeneratorContext ctx = new CodeGeneratorContext(config);
        AggregateInfoList aggInfos = AggregateUtil.transformToBatchAggregateInfoList(this.aggInputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), null, null);
        if (this.grouping.length == 0) {
            managedMemory = 0L;
            generatedOperator = AggWithoutKeysCodeGenerator.genWithoutKeys(ctx, planner.getRelBuilder(), aggInfos, inputRowType, outputRowType, this.isMerge, this.isFinal, "NoGrouping");
        } else {
            managedMemory = ((MemorySize)config.getConfiguration().get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_HASH_AGG_MEMORY)).getBytes();
            generatedOperator = new HashAggCodeGenerator(ctx, planner.getRelBuilder(), aggInfos, inputRowType, outputRowType, this.grouping, this.auxGrouping, this.isMerge, this.isFinal).genWithKeys();
        }
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.getDescription(), new CodeGenOperatorFactory(generatedOperator), InternalTypeInfo.of(outputRowType), inputTransform.getParallelism(), managedMemory);
    }
}

