/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.logical;

import java.time.Duration;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;

@JsonTypeName(value="HoppingWindow")
public class HoppingWindowSpec
implements WindowSpec {
    public static final String FIELD_NAME_SIZE = "size";
    public static final String FIELD_NAME_SLIDE = "slide";
    @JsonProperty(value="size")
    private final Duration size;
    @JsonProperty(value="slide")
    private final Duration slide;

    @JsonCreator
    public HoppingWindowSpec(@JsonProperty(value="size") Duration size, @JsonProperty(value="slide") Duration slide) {
        this.size = (Duration)Preconditions.checkNotNull((Object)size);
        this.slide = (Duration)Preconditions.checkNotNull((Object)slide);
    }

    @Override
    public String toSummaryString(String windowing) {
        return String.format("HOP(%s, size=[%s], slide=[%s])", windowing, TimeUtils.formatWithHighestUnit((Duration)this.size), TimeUtils.formatWithHighestUnit((Duration)this.slide));
    }

    public Duration getSize() {
        return this.size;
    }

    public Duration getSlide() {
        return this.slide;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoppingWindowSpec that = (HoppingWindowSpec)o;
        return this.size.equals(that.size) && this.slide.equals(that.slide);
    }

    public int hashCode() {
        return Objects.hash(HoppingWindowSpec.class, this.size, this.slide);
    }

    public String toString() {
        return String.format("HOP(size=[%s], slide=[%s])", TimeUtils.formatWithHighestUnit((Duration)this.size), TimeUtils.formatWithHighestUnit((Duration)this.slide));
    }
}

