/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public final class ListAggWsWithRetractAggFunction
extends BuiltInAggregateFunction<StringData, ListAggWsWithRetractAccumulator> {
    private static final long serialVersionUID = -8627988150350160473L;

    @Override
    public List<DataType> getArgumentDataTypes() {
        return Arrays.asList((DataType)DataTypes.STRING().bridgedTo(StringData.class), (DataType)DataTypes.STRING().bridgedTo(StringData.class));
    }

    @Override
    public DataType getAccumulatorDataType() {
        return DataTypes.STRUCTURED(ListAggWsWithRetractAccumulator.class, DataTypes.FIELD("list", ListView.newListViewDataType((DataType)((DataType)DataTypes.STRING().notNull()).bridgedTo(StringData.class))), DataTypes.FIELD("retractList", ListView.newListViewDataType((DataType)((DataType)DataTypes.STRING().notNull()).bridgedTo(StringData.class))), DataTypes.FIELD("delimiter", (DataType)DataTypes.STRING().bridgedTo(StringData.class)));
    }

    @Override
    public DataType getOutputDataType() {
        return (DataType)DataTypes.STRING().bridgedTo(StringData.class);
    }

    @Override
    public ListAggWsWithRetractAccumulator createAccumulator() {
        ListAggWsWithRetractAccumulator acc = new ListAggWsWithRetractAccumulator();
        acc.list = new ListView();
        acc.retractList = new ListView();
        acc.delimiter = StringData.fromString(",");
        return acc;
    }

    public void accumulate(ListAggWsWithRetractAccumulator acc, StringData value, StringData lineDelimiter) throws Exception {
        if (value != null) {
            acc.delimiter = lineDelimiter;
            acc.list.add(value);
        }
    }

    public void retract(ListAggWsWithRetractAccumulator acc, StringData value, StringData lineDelimiter) throws Exception {
        if (value != null) {
            acc.delimiter = lineDelimiter;
            if (!acc.list.remove(value)) {
                acc.retractList.add(value);
            }
        }
    }

    public void merge(ListAggWsWithRetractAccumulator acc, Iterable<ListAggWsWithRetractAccumulator> its) throws Exception {
        for (ListAggWsWithRetractAccumulator otherAcc : its) {
            if (!otherAcc.list.get().iterator().hasNext() && !otherAcc.retractList.get().iterator().hasNext()) continue;
            acc.delimiter = otherAcc.delimiter;
            ArrayList<StringData> buffer = new ArrayList<StringData>();
            for (StringData stringData : acc.list.get()) {
                buffer.add(stringData);
            }
            for (StringData stringData : otherAcc.list.get()) {
                buffer.add(stringData);
            }
            ArrayList<StringData> retractBuffer = new ArrayList<StringData>();
            for (StringData binaryString3 : acc.retractList.get()) {
                retractBuffer.add(binaryString3);
            }
            for (StringData binaryString : otherAcc.retractList.get()) {
                retractBuffer.add(binaryString);
            }
            ArrayList<StringData> arrayList = new ArrayList<StringData>();
            for (StringData binaryString4 : retractBuffer) {
                if (buffer.remove(binaryString4)) continue;
                arrayList.add(binaryString4);
            }
            acc.list.clear();
            acc.list.addAll(buffer);
            acc.retractList.clear();
            acc.retractList.addAll(arrayList);
        }
    }

    @Override
    public StringData getValue(ListAggWsWithRetractAccumulator acc) {
        try {
            Iterable<StringData> accList = acc.list.get();
            if (accList == null || !accList.iterator().hasNext()) {
                return null;
            }
            return BinaryStringDataUtil.concatWs((BinaryStringData)acc.delimiter, accList);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void resetAccumulator(ListAggWsWithRetractAccumulator acc) {
        acc.delimiter = StringData.fromString(",");
        acc.list.clear();
        acc.retractList.clear();
    }

    public static class ListAggWsWithRetractAccumulator {
        public ListView<StringData> list;
        public ListView<StringData> retractList;
        public StringData delimiter;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListAggWsWithRetractAccumulator that = (ListAggWsWithRetractAccumulator)o;
            return Objects.equals(this.list, that.list) && Objects.equals(this.retractList, that.retractList);
        }

        public int hashCode() {
            return Objects.hash(this.list, this.retractList);
        }
    }
}

