/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.delegation.StreamExecutor;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodePlanDumper;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.optimize.StreamCommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTraitDef$;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTraitDef$;
import org.apache.flink.table.planner.plan.trait.UpdateKindTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.DummyStreamExecutionEnvironment;
import org.apache.flink.table.planner.utils.ExecutorUtils;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0001\u0003\u0001=\u0011Qb\u0015;sK\u0006l\u0007\u000b\\1o]\u0016\u0014(BA\u0002\u0005\u0003)!W\r\\3hCRLwN\u001c\u0006\u0003\u000b\u0019\tq\u0001\u001d7b]:,'O\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005-\u0001F.\u00198oKJ\u0014\u0015m]3\t\u0011U\u0001!\u0011!Q\u0001\nY\t\u0001\"\u001a=fGV$xN\u001d\t\u0003/ei\u0011\u0001\u0007\u0006\u0003\u0007\u0019I!A\u0007\r\u0003\u0011\u0015CXmY;u_JD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0007G>tg-[4\u0011\u0005y\tS\"A\u0010\u000b\u0005\u00012\u0011aA1qS&\u0011!e\b\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\rC\u0005%\u0001\t\u0005\t\u0015!\u0003&W\u0005ya-\u001e8di&|gnQ1uC2|w\r\u0005\u0002'S5\tqE\u0003\u0002)\r\u000591-\u0019;bY><\u0017B\u0001\u0016(\u0005=1UO\\2uS>t7)\u0019;bY><\u0017B\u0001\u0013\u0013\u0011%i\u0003A!A!\u0002\u0013q\u0013'\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0011\u0005\u0019z\u0013B\u0001\u0019(\u00059\u0019\u0015\r^1m_\u001el\u0015M\\1hKJL!!\f\n\t\u000bM\u0002A\u0011\u0001\u001b\u0002\rqJg.\u001b;?)\u0015)dg\u000e\u001d:!\t\t\u0002\u0001C\u0003\u0016e\u0001\u0007a\u0003C\u0003\u001de\u0001\u0007Q\u0004C\u0003%e\u0001\u0007Q\u0005C\u0003.e\u0001\u0007a\u0006C\u0003<\u0001\u0011EC(\u0001\u0007hKR$&/Y5u\t\u001647/F\u0001>!\rq\u0014iQ\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t)\u0011I\u001d:bsB\u0012AI\u0014\t\u0004\u000b*cU\"\u0001$\u000b\u0005\u001dC\u0015\u0001\u00029mC:T!!\u0013\u0006\u0002\u000f\r\fGnY5uK&\u00111J\u0012\u0002\f%\u0016dGK]1ji\u0012+g\r\u0005\u0002N\u001d2\u0001A!C(;\u0003\u0003\u0005\tQ!\u0001Q\u0005\ryF%M\t\u0003#R\u0003\"A\u0010*\n\u0005M{$a\u0002(pi\"Lgn\u001a\t\u0003\u000bVK!A\u0016$\u0003\u0011I+G\u000e\u0016:bSRDQ\u0001\u0017\u0001\u0005Re\u000bAbZ3u\u001fB$\u0018.\\5{KJ,\u0012A\u0017\t\u00037~k\u0011\u0001\u0018\u0006\u0003;z\u000b\u0001b\u001c9uS6L'0\u001a\u0006\u0003\u000f\u0012I!\u0001\u0019/\u0003\u0013=\u0003H/[7ju\u0016\u0014\b\"\u00022\u0001\t#\u001a\u0017AG4fi\u0016CXm\u0019(pI\u0016<%/\u00199i!J|7-Z:t_J\u001cX#\u00013\u0011\u0007\u0015l\u0007O\u0004\u0002gW:\u0011qM[\u0007\u0002Q*\u0011\u0011ND\u0001\u0007yI|w\u000e\u001e \n\u0003\u0001K!\u0001\\ \u0002\u000fA\f7m[1hK&\u0011an\u001c\u0002\u0004'\u0016\f(B\u00017@!\t\t\b0D\u0001s\u0015\t\u0019H/A\u0005qe>\u001cWm]:pe*\u0011QO^\u0001\u0005Kb,7M\u0003\u0002x=\u0006)an\u001c3fg&\u0011\u0011P\u001d\u0002\u0017\u000bb,7MT8eK\u001e\u0013\u0018\r\u001d5Qe>\u001cWm]:pe\")1\u0010\u0001C)y\u0006yAO]1og2\fG/\u001a+p!2\fg\u000eF\u0002~\u0003S\u0001RA`A\u0004\u0003\u0017i\u0011a \u0006\u0005\u0003\u0003\t\u0019!\u0001\u0003vi&d'BAA\u0003\u0003\u0011Q\u0017M^1\n\u0007\u0005%qP\u0001\u0003MSN$\b\u0007BA\u0007\u0003;\u0001b!a\u0004\u0002\u0018\u0005mQBAA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u0007\u0011\fwM\u0003\u0002!\u0011%!\u0011\u0011DA\t\u00059!&/\u00198tM>\u0014X.\u0019;j_:\u00042!TA\u000f\t-\tyB_A\u0001\u0002\u0003\u0015\t!!\t\u0003\u0007}##'E\u0002R\u0003G\u00012APA\u0013\u0013\r\t9c\u0010\u0002\u0004\u0003:L\bbBA\u0016u\u0002\u0007\u0011QF\u0001\nKb,7m\u0012:ba\"\u0004B!a\f\u000225\tA/C\u0002\u00024Q\u0014Q\"\u0012=fG:{G-Z$sCBD\u0007bBA\u001c\u0001\u0011\u0005\u0013\u0011H\u0001\bKb\u0004H.Y5o)\u0019\tY$a\u0013\u0002\\A!\u0011QHA#\u001d\u0011\ty$!\u0011\u0011\u0005\u001d|\u0014bAA\"\u007f\u00051\u0001K]3eK\u001aLA!a\u0012\u0002J\t11\u000b\u001e:j]\u001eT1!a\u0011@\u0011!\ti%!\u000eA\u0002\u0005=\u0013AC8qKJ\fG/[8ogB)a0a\u0002\u0002RA!\u00111KA,\u001b\t\t)FC\u0002\u0002N\u0019IA!!\u0017\u0002V\tIq\n]3sCRLwN\u001c\u0005\t\u0003;\n)\u00041\u0001\u0002`\u0005aQ\r\u001f;sC\u0012+G/Y5mgB)a(!\u0019\u0002f%\u0019\u00111M \u0003\u0015q\u0012X\r]3bi\u0016$g\bE\u0002\u001f\u0003OJ1!!\u001b \u00055)\u0005\u0010\u001d7bS:$U\r^1jY\"9\u0011Q\u000e\u0001\u0005\n\u0005=\u0014AE2sK\u0006$X\rR;n[f\u0004F.\u00198oKJ$\u0012!\u000e\u0005\b\u0003g\u0002A\u0011IA;\u0003=)\u0007\u0010\u001d7bS:T5o\u001c8QY\u0006tGCBA\u001e\u0003o\nY\b\u0003\u0005\u0002z\u0005E\u0004\u0019AA\u001e\u0003!Q7o\u001c8QY\u0006t\u0007\u0002CA/\u0003c\u0002\r!a\u0018\t\u000f\u0005}\u0004\u0001\"\u0011\u0002\u0002\u0006\u0001c/\u00197jI\u0006$X-\u00118e\u001fZ,'O]5eK\u000e{gNZ5hkJ\fG/[8o)\t\t\u0019\tE\u0002?\u0003\u000bK1!a\"@\u0005\u0011)f.\u001b;")
public class StreamPlanner
extends PlannerBase {
    private final TableConfig config;

    @Override
    public RelTraitDef<? extends RelTrait>[] getTraitDefs() {
        return (RelTraitDef[])((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), MiniBatchIntervalTraitDef$.MODULE$.INSTANCE(), ModifyKindSetTraitDef$.MODULE$.INSTANCE(), UpdateKindTraitDef$.MODULE$.INSTANCE()});
    }

    @Override
    public Optimizer getOptimizer() {
        return new StreamCommonSubGraphBasedOptimizer(this);
    }

    @Override
    public Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    @Override
    public List<Transformation<?>> translateToPlan(ExecNodeGraph execGraph) {
        this.validateAndOverrideConfiguration();
        StreamPlanner planner = this.createDummyPlanner();
        Buffer transformations = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(execGraph.getRootNodes()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecNode execNode = x0$1;
            if (!(execNode instanceof StreamExecNode)) {
                throw new TableException("Cannot generate DataStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
            }
            StreamExecNode streamExecNode = (StreamExecNode)execNode;
            Transformation transformation = streamExecNode.translateToPlan(planner);
            return transformation;
        }, Buffer$.MODULE$.canBuildFrom());
        this.cleanupInternalConfigurations();
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(transformations);
    }

    public String explain(List<Operation> operations, Seq<ExplainDetail> extraDetails) {
        BoxedUnit boxedUnit;
        Predef$.MODULE$.require(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operations).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "operations should not be empty");
        this.validateAndOverrideConfiguration();
        Buffer sinkRelNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operations).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            RelNode relNode;
            Operation operation = x0$2;
            if (operation instanceof QueryOperation) {
                RelNode relNode2;
                QueryOperation queryOperation = (QueryOperation)operation;
                RelNode relNode3 = this.getRelBuilder().queryOperation(queryOperation).build();
                RelNode relNode4 = relNode3;
                if (relNode4 instanceof LogicalTableModify) {
                    LogicalTableModify logicalTableModify = (LogicalTableModify)relNode4;
                    List<String> qualifiedName = logicalTableModify.getTable().getQualifiedName();
                    Predef$.MODULE$.require(qualifiedName.size() == 3, (Function0 & Serializable & scala.Serializable)() -> "the length of qualified name should be 3.");
                    CatalogSinkModifyOperation modifyOperation = new CatalogSinkModifyOperation(ObjectIdentifier.of(qualifiedName.get(0), qualifiedName.get(1), qualifiedName.get(2)), new PlannerQueryOperation(logicalTableModify.getInput()));
                    relNode2 = this.translateToRel(modifyOperation);
                } else {
                    relNode2 = relNode3;
                }
                relNode = relNode2;
            } else if (operation instanceof ModifyOperation) {
                ModifyOperation modifyOperation = (ModifyOperation)operation;
                relNode = this.translateToRel(modifyOperation);
            } else {
                throw new TableException(new java.lang.StringBuilder(23).append("Unsupported operation: ").append(operation.getClass().getCanonicalName()).toString());
            }
            return relNode;
        }, Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)sinkRelNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes);
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.cleanupInternalConfigurations();
        StreamGraph streamGraph = ExecutorUtils.generateStreamGraph(this.getExecEnv(), transformations);
        StringBuilder sb = new StringBuilder();
        sb.append("== Abstract Syntax Tree ==");
        sb.append(System.lineSeparator());
        sinkRelNodes.foreach((Function1 & Serializable & scala.Serializable)sink -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)sink, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Physical Plan ==");
        sb.append(System.lineSeparator());
        SqlExplainLevel explainLevel = extraDetails.contains((Object)ExplainDetail.ESTIMATED_COST) ? SqlExplainLevel.ALL_ATTRIBUTES : SqlExplainLevel.DIGEST_ATTRIBUTES;
        boolean withChangelogTraits = extraDetails.contains((Object)ExplainDetail.CHANGELOG_MODE);
        optimizedRelNodes.foreach((Function1 & Serializable & scala.Serializable)rel -> {
            RelNode x$1 = rel;
            SqlExplainLevel x$2 = explainLevel;
            boolean x$3 = withChangelogTraits;
            boolean x$4 = FlinkRelOptUtil$.MODULE$.toString$default$3();
            boolean x$5 = FlinkRelOptUtil$.MODULE$.toString$default$5();
            sb.append(FlinkRelOptUtil$.MODULE$.toString(x$1, x$2, x$4, x$3, x$5));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(ExecNodePlanDumper.dagToString(execGraph));
        if (extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN)) {
            sb.append(System.lineSeparator());
            sb.append("== Physical Execution Plan ==");
            sb.append(System.lineSeparator());
            boxedUnit = sb.append(streamGraph.getStreamingPlanAsJSON());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    private StreamPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecEnv());
        StreamExecutor executor = new StreamExecutor(dummyExecEnv);
        return new StreamPlanner(executor, this.config, super.functionCatalog(), super.catalogManager());
    }

    public String explainJsonPlan(String jsonPlan, Seq<ExplainDetail> extraDetails) {
        BoxedUnit boxedUnit;
        this.validateAndOverrideConfiguration();
        ExecNodeGraph execGraph = ExecNodeGraph.createExecNodeGraph(jsonPlan, this.createSerdeContext());
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.cleanupInternalConfigurations();
        StreamGraph streamGraph = ExecutorUtils.generateStreamGraph(this.getExecEnv(), transformations);
        StringBuilder sb = new StringBuilder();
        sb.append("== Optimized Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(ExecNodePlanDumper.dagToString(execGraph));
        if (extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN)) {
            sb.append(System.lineSeparator());
            sb.append("== Physical Execution Plan ==");
            sb.append(System.lineSeparator());
            boxedUnit = sb.append(streamGraph.getStreamingPlanAsJSON());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    @Override
    public void validateAndOverrideConfiguration() {
        super.validateAndOverrideConfiguration();
        if (!((Enum)this.config.getConfiguration().get(ExecutionOptions.RUNTIME_MODE)).equals(RuntimeExecutionMode.STREAMING)) {
            throw new IllegalArgumentException("Mismatch between configured runtime mode and actual runtime mode. Currently, the 'execution.runtime-mode' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
        }
    }

    @Override
    public String explainJsonPlan(String jsonPlan, ExplainDetail[] extraDetails) {
        return this.explainJsonPlan(jsonPlan, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    @Override
    public String explain(List<Operation> operations, ExplainDetail[] extraDetails) {
        return this.explain(operations, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public StreamPlanner(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this.config = config;
        super(executor, config, functionCatalog, catalogManager, true);
    }
}

