/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;
import org.apache.flink.table.types.DataType;

@Internal
public final class ScalaExternalQueryOperation<E>
implements QueryOperation {
    private final ObjectIdentifier identifier;
    private final DataStream<E> dataStream;
    private final DataType physicalDataType;
    private final boolean isTopLevelRecord;
    private final ChangelogMode changelogMode;
    private final ResolvedSchema resolvedSchema;

    public ScalaExternalQueryOperation(ObjectIdentifier identifier, DataStream<E> dataStream, DataType physicalDataType, boolean isTopLevelRecord, ChangelogMode changelogMode, ResolvedSchema resolvedSchema) {
        this.identifier = identifier;
        this.dataStream = dataStream;
        this.physicalDataType = physicalDataType;
        this.isTopLevelRecord = isTopLevelRecord;
        this.changelogMode = changelogMode;
        this.resolvedSchema = resolvedSchema;
    }

    public ObjectIdentifier getIdentifier() {
        return this.identifier;
    }

    public DataStream<E> getDataStream() {
        return this.dataStream;
    }

    public DataType getPhysicalDataType() {
        return this.physicalDataType;
    }

    public boolean isTopLevelRecord() {
        return this.isTopLevelRecord;
    }

    public ChangelogMode getChangelogMode() {
        return this.changelogMode;
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("identifier", this.identifier);
        args.put("stream", this.dataStream.getId());
        args.put("type", this.physicalDataType);
        args.put("isTopLevelRecord", this.isTopLevelRecord);
        args.put("changelogMode", this.changelogMode);
        args.put("fields", this.resolvedSchema.getColumnNames());
        return OperationUtils.formatWithChildren("DataStreamInput", args, this.getChildren(), Operation::asSummaryString);
    }

    @Override
    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    @Override
    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

