/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.filesystem.FileSystemOptions;
import org.apache.flink.table.filesystem.PartitionTimeExtractor;
import org.apache.flink.table.filesystem.stream.PartitionCommitTrigger;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.util.StringUtils;

public class PartitionTimeCommitTrigger
implements PartitionCommitTrigger {
    private static final ListStateDescriptor<List<String>> PENDING_PARTITIONS_STATE_DESC = new ListStateDescriptor("pending-partitions", (TypeSerializer)new ListSerializer((TypeSerializer)StringSerializer.INSTANCE));
    private static final ListStateDescriptor<Map<Long, Long>> WATERMARKS_STATE_DESC = new ListStateDescriptor("checkpoint-id-to-watermark", (TypeSerializer)new MapSerializer((TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)LongSerializer.INSTANCE));
    private final ListState<List<String>> pendingPartitionsState;
    private final Set<String> pendingPartitions;
    private final ListState<Map<Long, Long>> watermarksState;
    private final TreeMap<Long, Long> watermarks;
    private final PartitionTimeExtractor extractor;
    private final long commitDelay;
    private final List<String> partitionKeys;
    private final ZoneId watermarkTimeZone;

    public PartitionTimeCommitTrigger(boolean isRestored, OperatorStateStore stateStore, Configuration conf, ClassLoader cl, List<String> partitionKeys) throws Exception {
        this.pendingPartitionsState = stateStore.getListState(PENDING_PARTITIONS_STATE_DESC);
        this.pendingPartitions = new HashSet<String>();
        if (isRestored) {
            this.pendingPartitions.addAll((Collection)((Iterable)this.pendingPartitionsState.get()).iterator().next());
        }
        this.partitionKeys = partitionKeys;
        this.commitDelay = ((Duration)conf.get(FileSystemOptions.SINK_PARTITION_COMMIT_DELAY)).toMillis();
        this.extractor = PartitionTimeExtractor.create(cl, (String)conf.get(FileSystemOptions.PARTITION_TIME_EXTRACTOR_KIND), (String)conf.get(FileSystemOptions.PARTITION_TIME_EXTRACTOR_CLASS), (String)conf.get(FileSystemOptions.PARTITION_TIME_EXTRACTOR_TIMESTAMP_PATTERN));
        this.watermarksState = stateStore.getListState(WATERMARKS_STATE_DESC);
        this.watermarks = new TreeMap();
        this.watermarkTimeZone = ZoneId.of(conf.getString(FileSystemOptions.SINK_PARTITION_COMMIT_WATERMARK_TIME_ZONE));
        if (isRestored) {
            this.watermarks.putAll((Map)((Iterable)this.watermarksState.get()).iterator().next());
        }
    }

    @Override
    public void addPartition(String partition) {
        if (!StringUtils.isNullOrWhitespaceOnly((String)partition)) {
            this.pendingPartitions.add(partition);
        }
    }

    @Override
    public List<String> committablePartitions(long checkpointId) {
        if (!this.watermarks.containsKey(checkpointId)) {
            throw new IllegalArgumentException(String.format("Checkpoint(%d) has not been snapshot. The watermark information is: %s.", checkpointId, this.watermarks));
        }
        long watermark = this.watermarks.get(checkpointId);
        this.watermarks.headMap(checkpointId, true).clear();
        ArrayList<String> needCommit = new ArrayList<String>();
        Iterator<String> iter = this.pendingPartitions.iterator();
        while (iter.hasNext()) {
            String partition = iter.next();
            LocalDateTime partitionTime = this.extractor.extract(this.partitionKeys, PartitionPathUtils.extractPartitionValues(new Path(partition)));
            if (!this.watermarkHasPassedWithDelay(watermark, partitionTime, this.commitDelay)) continue;
            needCommit.add(partition);
            iter.remove();
        }
        return needCommit;
    }

    private boolean watermarkHasPassedWithDelay(long watermark, LocalDateTime partitionTime, long commitDelay) {
        long epochPartTime = partitionTime.atZone(this.watermarkTimeZone).toInstant().toEpochMilli();
        return watermark > epochPartTime + commitDelay;
    }

    @Override
    public void snapshotState(long checkpointId, long watermark) throws Exception {
        this.pendingPartitionsState.clear();
        this.pendingPartitionsState.add(new ArrayList<String>(this.pendingPartitions));
        this.watermarks.put(checkpointId, watermark);
        this.watermarksState.clear();
        this.watermarksState.add(new HashMap<Long, Long>(this.watermarks));
    }

    @Override
    public List<String> endInput() {
        ArrayList<String> partitions = new ArrayList<String>(this.pendingPartitions);
        this.pendingPartitions.clear();
        return partitions;
    }
}

