/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.RowUtils;

@Internal
public class RowRowConverter
implements DataStructureConverter<RowData, Row> {
    private static final long serialVersionUID = 1L;
    private final DataStructureConverter<Object, Object>[] fieldConverters;
    private final RowData.FieldGetter[] fieldGetters;
    private final LinkedHashMap<String, Integer> positionByName;

    private RowRowConverter(DataStructureConverter<Object, Object>[] fieldConverters, RowData.FieldGetter[] fieldGetters, LinkedHashMap<String, Integer> positionByName) {
        this.fieldConverters = fieldConverters;
        this.fieldGetters = fieldGetters;
        this.positionByName = positionByName;
    }

    @Override
    public void open(ClassLoader classLoader) {
        for (DataStructureConverter<Object, Object> fieldConverter : this.fieldConverters) {
            fieldConverter.open(classLoader);
        }
    }

    @Override
    public RowData toInternal(Row external) {
        int length = this.fieldConverters.length;
        GenericRowData genericRow = new GenericRowData(external.getKind(), length);
        Set fieldNames = external.getFieldNames(false);
        if (fieldNames == null) {
            for (int pos = 0; pos < length; ++pos) {
                Object value = external.getField(pos);
                genericRow.setField(pos, this.fieldConverters[pos].toInternalOrNull(value));
            }
        } else {
            for (String fieldName : fieldNames) {
                Integer targetPos = this.positionByName.get(fieldName);
                if (targetPos == null) {
                    throw new IllegalArgumentException(String.format("Unknown field name '%s' for mapping to a row position. Available names are: %s", fieldName, this.positionByName.keySet()));
                }
                Object value = external.getField(fieldName);
                genericRow.setField(targetPos, this.fieldConverters[targetPos].toInternalOrNull(value));
            }
        }
        return genericRow;
    }

    @Override
    public Row toExternal(RowData internal) {
        int length = this.fieldConverters.length;
        Object[] fieldByPosition = new Object[length];
        for (int pos = 0; pos < length; ++pos) {
            Object value = this.fieldGetters[pos].getFieldOrNull(internal);
            fieldByPosition[pos] = this.fieldConverters[pos].toExternalOrNull(value);
        }
        return RowUtils.createRowWithNamedPositions((RowKind)internal.getRowKind(), (Object[])fieldByPosition, this.positionByName);
    }

    public static RowRowConverter create(DataType dataType) {
        List<DataType> fields = dataType.getChildren();
        DataStructureConverter[] fieldConverters = (DataStructureConverter[])fields.stream().map(dt -> DataStructureConverters.getConverter(dt)).toArray(DataStructureConverter[]::new);
        RowData.FieldGetter[] fieldGetters = (RowData.FieldGetter[])IntStream.range(0, fields.size()).mapToObj(pos -> RowData.createFieldGetter(((DataType)fields.get(pos)).getLogicalType(), pos)).toArray(RowData.FieldGetter[]::new);
        List<String> fieldNames = LogicalTypeChecks.getFieldNames(dataType.getLogicalType());
        LinkedHashMap<String, Integer> positionByName = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < fieldNames.size(); ++i) {
            positionByName.put(fieldNames.get(i), i);
        }
        return new RowRowConverter(fieldConverters, fieldGetters, positionByName);
    }
}

