/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.TableDescriptor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class CatalogTableBuilder
extends TableDescriptor<CatalogTableBuilder> {
    private final TableSchema tableSchema;
    private String comment;
    private List<String> partitionKeys = new ArrayList<String>();
    private Map<String, String> properties = Collections.emptyMap();

    public CatalogTableBuilder(ConnectorDescriptor connectorDescriptor, TableSchema tableSchema) {
        super(connectorDescriptor);
        this.tableSchema = (TableSchema)Preconditions.checkNotNull((Object)tableSchema);
    }

    public CatalogTableBuilder withComment(String comment) {
        this.comment = (String)Preconditions.checkNotNull((Object)comment, (String)"Comment must not be null.");
        return this;
    }

    public CatalogTableBuilder withProperties(Map<String, String> properties) {
        this.properties = (Map)Preconditions.checkNotNull(properties, (String)"Properties must not be null.");
        return this;
    }

    public CatalogTableBuilder withPartitionKeys(List<String> partitionKeys) {
        this.partitionKeys = (List)Preconditions.checkNotNull(partitionKeys, (String)"PartitionKeys must not be null.");
        return this;
    }

    public CatalogTable build() {
        return new CatalogTableImpl(this.tableSchema, this.partitionKeys, this.toProperties(), this.comment);
    }

    @Override
    protected Map<String, String> additionalProperties() {
        DescriptorProperties descriptorProperties = new DescriptorProperties();
        descriptorProperties.putProperties(this.properties);
        return descriptorProperties.asMap();
    }
}

