/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks;

import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.sinks.PartitionableTableSink;
import org.apache.flink.table.sinks.TableSink;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TableSinkUtils$ {
    public static TableSinkUtils$ MODULE$;

    static {
        new TableSinkUtils$();
    }

    public void validateSink(Map<String, String> staticPartitions, QueryOperation query, ObjectIdentifier objectIdentifier, TableSink<?> sink) {
        TypeInformation<?>[] sinkFieldTypes;
        TableSchema schema = TableSchema.fromResolvedSchema(query.getResolvedSchema());
        TypeInformation<?>[] srcFieldTypes = schema.getFieldTypes();
        if (srcFieldTypes.length != (sinkFieldTypes = sink.getTableSchema().getFieldTypes()).length || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])srcFieldTypes)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sinkFieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).exists((Function1 & java.io.Serializable & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TableSinkUtils$.$anonfun$validateSink$1(x0$1)))) {
            String[] srcFieldNames = schema.getFieldNames();
            String[] sinkFieldNames = sink.getTableSchema().getFieldNames();
            String srcSchema = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])srcFieldNames)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])srcFieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & java.io.Serializable & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String n = (String)tuple2._1();
                TypeInformation t = (TypeInformation)tuple2._2();
                String string = new StringBuilder(2).append(n).append(": ").append(t).toString();
                return string;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ", ", "]");
            String sinkSchema = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sinkFieldNames)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sinkFieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & java.io.Serializable & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String n = (String)tuple2._1();
                TypeInformation t = (TypeInformation)tuple2._2();
                String string = new StringBuilder(2).append(n).append(": ").append(t).toString();
                return string;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ", ", "]");
            throw new ValidationException(new StringBuilder(53).append("Field types of query result and registered TableSink ").append(new StringBuilder(15).append(objectIdentifier).append(" do not match.\n").toString()).append(new StringBuilder(22).append("Query result schema: ").append(srcSchema).append("\n").toString()).append(new StringBuilder(21).append("TableSink schema:    ").append(sinkSchema).toString()).toString());
        }
        if (staticPartitions != null && !staticPartitions.isEmpty()) {
            String invalidMsg = "Can't insert static partitions into a non-partitioned table sink. A partitioned sink should implement 'PartitionableTableSink'.";
            TableSink<?> tableSink = sink;
            if (tableSink instanceof PartitionableTableSink) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new ValidationException(invalidMsg);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateSink$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TypeInformation srcF = (TypeInformation)tuple2._1();
        TypeInformation snkF = (TypeInformation)tuple2._2();
        TypeInformation typeInformation = srcF;
        TypeInformation typeInformation2 = snkF;
        boolean bl = typeInformation == null ? typeInformation2 != null : !typeInformation.equals(typeInformation2);
        return bl;
    }

    private TableSinkUtils$() {
        MODULE$ = this;
    }
}

