/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.Iterator;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001=\u0011a\u0006R1uCN+G\u000fV;nE2,7i\\;oi^Kg\u000eZ8x\u0003\u001e<'+\u001a3vG\u0016<%o\\;q\rVt7\r^5p]*\u00111\u0001B\u0001\nC\u001e<'/Z4bi\u0016T!!\u0002\u0004\u0002\u000fI,h\u000e^5nK*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u0011A)\u0002B!\u0005\r\u001b55\t!C\u0003\u0002\u0014)\u0005Ia-\u001e8di&|gn\u001d\u0006\u0003+Y\taaY8n[>t'BA\f\t\u0003\r\t\u0007/[\u0005\u00033I\u0011qCU5dQ\u001e\u0013x.\u001e9SK\u0012,8-\u001a$v]\u000e$\u0018n\u001c8\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011!\u0002;za\u0016\u001c\u0018BA\u0010\u001d\u0005\r\u0011vn\u001e\t\u0004C\u00112S\"\u0001\u0012\u000b\u0005\r2\u0011aB2pI\u0016<WM\\\u0005\u0003K\t\u0012\u0001bQ8na&dWM\u001d\t\u0003O!j\u0011AA\u0005\u0003S\t\u0011QcR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7\u000f\u0005\u0002,]5\tAF\u0003\u0002.\r\u0005!Q\u000f^5m\u0013\tyCFA\u0004M_\u001e<\u0017N\\4\t\u0011E\u0002!Q1A\u0005\nI\nqbZ3o\u0003\u001e<'/Z4bi&|gn]\u000b\u0002gA\u0011\u0011\u0005N\u0005\u0003k\t\u0012QdR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7OR;oGRLwN\u001c\u0005\to\u0001\u0011\t\u0011)A\u0005g\u0005\u0001r-\u001a8BO\u001e\u0014XmZ1uS>t7\u000f\t\u0005\ts\u0001\u0011)\u0019!C\u0005u\u0005Qq/\u001b8e_^\u001c\u0016N_3\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012A\u0001T8oO\"A!\t\u0001B\u0001B\u0003%1(A\u0006xS:$wn^*ju\u0016\u0004\u0003\"\u0002#\u0001\t\u0003)\u0015A\u0002\u001fj]&$h\bF\u0002G\u000f\"\u0003\"a\n\u0001\t\u000bE\u001a\u0005\u0019A\u001a\t\u000be\u001a\u0005\u0019A\u001e\t\u0013)\u0003\u0001\u0019!a\u0001\n\u0013Y\u0015AB8viB,H/F\u0001\u001b\u0011%i\u0005\u00011AA\u0002\u0013%a*\u0001\u0006pkR\u0004X\u000f^0%KF$\"a\u0014*\u0011\u0005q\u0002\u0016BA)>\u0005\u0011)f.\u001b;\t\u000fMc\u0015\u0011!a\u00015\u0005\u0019\u0001\u0010J\u0019\t\u0013U\u0003\u0001\u0019!A!B\u0013Q\u0012aB8viB,H\u000f\t\u0005\n/\u0002\u0001\r\u00111A\u0005\n-\u000bA\"Y2dk6,H.\u0019;peND\u0011\"\u0017\u0001A\u0002\u0003\u0007I\u0011\u0002.\u0002!\u0005\u001c7-^7vY\u0006$xN]:`I\u0015\fHCA(\\\u0011\u001d\u0019\u0006,!AA\u0002iA\u0011\"\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u000e\u0002\u001b\u0005\u001c7-^7vY\u0006$xN]:!\u0011%y\u0006\u00011AA\u0002\u0013%\u0001-\u0001\u0005gk:\u001cG/[8o+\u00051\u0003\"\u00032\u0001\u0001\u0004\u0005\r\u0011\"\u0003d\u000311WO\\2uS>tw\fJ3r)\tyE\rC\u0004TC\u0006\u0005\t\u0019\u0001\u0014\t\u0013\u0019\u0004\u0001\u0019!A!B\u00131\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011\u0015A\u0007\u0001\"\u0011j\u0003\u0011y\u0007/\u001a8\u0015\u0005=S\u0007\"B6h\u0001\u0004a\u0017AB2p]\u001aLw\r\u0005\u0002na6\taN\u0003\u0002p\u0011\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\u001d8\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015\u0019\b\u0001\"\u0011u\u0003\u0019\u0011X\rZ;dKR\u0019q*^@\t\u000bY\u0014\b\u0019A<\u0002\u000fI,7m\u001c:egB\u0019\u00010 \u000e\u000e\u0003eT!A_>\u0002\t1\fgn\u001a\u0006\u0002y\u0006!!.\u0019<b\u0013\tq\u0018P\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\t\tA\u001da\u0001\u0003\u0007\t1a\\;u!\u0015\t)!!\u0003\u001b\u001b\t\t9A\u0003\u0002.\u0011%!\u00111BA\u0004\u0005%\u0019u\u000e\u001c7fGR|'\u000f")
public class DataSetTumbleCountWindowAggReduceGroupFunction
extends RichGroupReduceFunction<Row, Row>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final long windowSize;
    private Row output;
    private Row accumulators;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        DataSetTumbleCountWindowAggReduceGroupFunction dataSetTumbleCountWindowAggReduceGroupFunction = this;
        synchronized (dataSetTumbleCountWindowAggReduceGroupFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private GeneratedAggregationsFunction genAggregations() {
        return this.genAggregations;
    }

    private long windowSize() {
        return this.windowSize;
    }

    private Row output() {
        return this.output;
    }

    private void output_$eq(Row x$1) {
        this.output = x$1;
    }

    private Row accumulators() {
        return this.accumulators;
    }

    private void accumulators_$eq(Row x$1) {
        this.accumulators = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(36).append("Compiling AggregateHelper: ").append(this.genAggregations()).append(".name \n\n ").append(new StringBuilder(11).append("Code:\n").append(this.genAggregations()).append(".code").toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations().name(), this.genAggregations().code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.output_$eq(this.function().createOutputRow());
        this.accumulators_$eq(this.function().createAccumulators());
    }

    public void reduce(Iterable<Row> records, Collector<Row> out) {
        long count = 0L;
        Iterator<Row> iterator = records.iterator();
        while (iterator.hasNext()) {
            if (count == 0L) {
                this.function().resetAccumulator(this.accumulators());
            }
            Row record = iterator.next();
            this.accumulators_$eq(this.function().mergeAccumulatorsPair(this.accumulators(), record));
            if (this.windowSize() != ++count) continue;
            this.function().setForwardedFields(record, this.output());
            this.function().setAggregationResults(this.accumulators(), this.output());
            out.collect((Object)this.output());
            count = 0L;
        }
    }

    public DataSetTumbleCountWindowAggReduceGroupFunction(GeneratedAggregationsFunction genAggregations, long windowSize) {
        this.genAggregations = genAggregations;
        this.windowSize = windowSize;
        Compiler.$init$(this);
        Logging.$init$(this);
    }
}

