/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u0001=\u0011\u0011\u0006R1uCN+GoU3tg&|gnV5oI><\u0018iZ4sK\u001e\fG/\u001a)sKB\u0013xnY3tg>\u0014(BA\u0002\u0005\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002\u0006\r\u00059!/\u001e8uS6,'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\b\u0001AQ2E\n\u00189!\t\t\u0002$D\u0001\u0013\u0015\t\u0019B#A\u0005gk:\u001cG/[8og*\u0011QCF\u0001\u0007G>lWn\u001c8\u000b\u0005]A\u0011aA1qS&\u0011\u0011D\u0005\u0002\u0015\u0003\n\u001cHO]1diJK7\r\u001b$v]\u000e$\u0018n\u001c8\u0011\tEYR$H\u0005\u00039I\u0011A#T1q!\u0006\u0014H/\u001b;j_:4UO\\2uS>t\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\t\u0003\u0015!\u0018\u0010]3t\u0013\t\u0011sDA\u0002S_^\u0004B!\u0005\u0013\u001e;%\u0011QE\u0005\u0002\u0015\u000fJ|W\u000f]\"p[\nLg.\u001a$v]\u000e$\u0018n\u001c8\u0011\u0007\u001dbS$D\u0001)\u0015\tI#&A\u0005usB,W\u000f^5mg*\u00111FF\u0001\u0005U\u00064\u0018-\u0003\u0002.Q\t\u0019\"+Z:vYR$\u0016\u0010]3Rk\u0016\u0014\u00180\u00192mKB\u0019qF\r\u001b\u000e\u0003AR!!\r\u0004\u0002\u000f\r|G-Z4f]&\u00111\u0007\r\u0002\t\u0007>l\u0007/\u001b7feB\u0011QGN\u0007\u0002\u0005%\u0011qG\u0001\u0002\u0016\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t!\tID(D\u0001;\u0015\tYd!\u0001\u0003vi&d\u0017BA\u001f;\u0005\u001daunZ4j]\u001eD\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001Q\u0001\u0010O\u0016t\u0017iZ4sK\u001e\fG/[8ogB\u0011q&Q\u0005\u0003\u0005B\u0012QdR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7OR;oGRLwN\u001c\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\u000612.Z=t\u0003:$\u0017iZ4sK\u001e\fG/Z:Be&$\u0018\u0010\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuIA\u0002J]RD\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!T\u0001\u0004O\u0006\u0004\bC\u0001$O\u0013\tyuI\u0001\u0003M_:<\u0007\u0002C)\u0001\u0005\u0003\u0007I\u0011\u0001*\u0002'%tG/\u001a:nK\u0012L\u0017\r^3S_^$\u0016\u0010]3\u0016\u0003M\u00032\u0001V,\u001e\u001b\u0005)&B\u0001,\u0015\u0003!!\u0018\u0010]3j]\u001a|\u0017B\u0001-V\u0005=!\u0016\u0010]3J]\u001a|'/\\1uS>t\u0007\u0002\u0003.\u0001\u0005\u0003\u0007I\u0011A.\u0002/%tG/\u001a:nK\u0012L\u0017\r^3S_^$\u0016\u0010]3`I\u0015\fHC\u0001/`!\t1U,\u0003\u0002_\u000f\n!QK\\5u\u0011\u001d\u0001\u0017,!AA\u0002M\u000b1\u0001\u001f\u00132\u0011!\u0011\u0007A!A!B\u0013\u0019\u0016\u0001F5oi\u0016\u0014X.\u001a3jCR,'k\\<UsB,\u0007\u0005\u000b\u0002bIB\u0011a)Z\u0005\u0003M\u001e\u0013\u0011\u0002\u001e:b]NLWM\u001c;\t\u000b!\u0004A\u0011A5\u0002\rqJg.\u001b;?)\u0015Q7\u000e\\7o!\t)\u0004\u0001C\u0003@O\u0002\u0007\u0001\tC\u0003EO\u0002\u0007Q\tC\u0003MO\u0002\u0007Q\nC\u0003RO\u0002\u00071\u000bC\u0005q\u0001\u0001\u0007\t\u0019!C\u0005c\u00061q.\u001e;qkR,\u0012!\b\u0005\ng\u0002\u0001\r\u00111A\u0005\nQ\f!b\\;uaV$x\fJ3r)\taV\u000fC\u0004ae\u0006\u0005\t\u0019A\u000f\t\u0013]\u0004\u0001\u0019!A!B\u0013i\u0012aB8viB,H\u000f\t\u0005\bs\u0002\u0011\r\u0011\"\u0003{\u0003=\u0011xn\u001e+j[\u00164\u0015.\u001a7e!>\u001cX#A#\t\rq\u0004\u0001\u0015!\u0003F\u0003A\u0011xn\u001e+j[\u00164\u0015.\u001a7e!>\u001c\b\u0005C\u0005\u007f\u0001\u0001\u0007\t\u0019!C\u0005c\u0006a\u0011mY2v[Vd\u0017\r^8sg\"Y\u0011\u0011\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0002\u0003A\t7mY;nk2\fGo\u001c:t?\u0012*\u0017\u000fF\u0002]\u0003\u000bAq\u0001Y@\u0002\u0002\u0003\u0007Q\u0004\u0003\u0006\u0002\n\u0001\u0001\r\u0011!Q!\nu\tQ\"Y2dk6,H.\u0019;peN\u0004\u0003bCA\u0007\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001f\t\u0001BZ;oGRLwN\\\u000b\u0002i!Y\u00111\u0003\u0001A\u0002\u0003\u0007I\u0011BA\u000b\u000311WO\\2uS>tw\fJ3r)\ra\u0016q\u0003\u0005\tA\u0006E\u0011\u0011!a\u0001i!Q\u00111\u0004\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001b\u0002\u0013\u0019,hn\u0019;j_:\u0004\u0003bBA\u0010\u0001\u0011\u0005\u0013\u0011E\u0001\u0005_B,g\u000eF\u0002]\u0003GA\u0001\"!\n\u0002\u001e\u0001\u0007\u0011qE\u0001\u0007G>tg-[4\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f\t\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&!\u0011\u0011GA\u0016\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u0011Q\u0007\u0001\u0005B\u0005]\u0012aB2p[\nLg.\u001a\u000b\u00069\u0006e\u00121\n\u0005\t\u0003w\t\u0019\u00041\u0001\u0002>\u00059!/Z2pe\u0012\u001c\b#BA \u0003\u000fjRBAA!\u0015\u0011\t\u0019%!\u0012\u0002\t1\fgn\u001a\u0006\u0002W%!\u0011\u0011JA!\u0005!IE/\u001a:bE2,\u0007\u0002CA'\u0003g\u0001\r!a\u0014\u0002\u0007=,H\u000fE\u0003\u0002R\u0005US$\u0004\u0002\u0002T)\u00111\bC\u0005\u0005\u0003/\n\u0019FA\u0005D_2dWm\u0019;pe\"9\u00111\f\u0001\u0005B\u0005u\u0013\u0001D7baB\u000b'\u000f^5uS>tG#\u0002/\u0002`\u0005\u0005\u0004\u0002CA\u001e\u00033\u0002\r!!\u0010\t\u0011\u00055\u0013\u0011\fa\u0001\u0003\u001fBq!!\u001a\u0001\t\u0003\t9'A\u0005e_\u000e{G\u000e\\3diR9A,!\u001b\u0002l\u0005=\u0004\u0002CA'\u0003G\u0002\r!a\u0014\t\u000f\u00055\u00141\ra\u0001\u001b\u0006Yq/\u001b8e_^\u001cF/\u0019:u\u0011\u001d\t\t(a\u0019A\u00025\u000b\u0011b^5oI><XI\u001c3\t\u000f\u0005U\u0004\u0001\"\u0011\u0002x\u0005yq-\u001a;Qe>$WoY3e)f\u0004X\rF\u0001T\u0001")
public class DataSetSessionWindowAggregatePreProcessor
extends AbstractRichFunction
implements MapPartitionFunction<Row, Row>,
GroupCombineFunction<Row, Row>,
ResultTypeQueryable<Row>,
Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final long gap;
    private transient TypeInformation<Row> intermediateRowType;
    private Row output;
    private final int rowTimeFieldPos;
    private Row accumulators;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        DataSetSessionWindowAggregatePreProcessor dataSetSessionWindowAggregatePreProcessor = this;
        synchronized (dataSetSessionWindowAggregatePreProcessor) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    public TypeInformation<Row> intermediateRowType() {
        return this.intermediateRowType;
    }

    public void intermediateRowType_$eq(TypeInformation<Row> x$1) {
        this.intermediateRowType = x$1;
    }

    private Row output() {
        return this.output;
    }

    private void output_$eq(Row x$1) {
        this.output = x$1;
    }

    private int rowTimeFieldPos() {
        return this.rowTimeFieldPos;
    }

    private Row accumulators() {
        return this.accumulators;
    }

    private void accumulators_$eq(Row x$1) {
        this.accumulators = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(36).append("Compiling AggregateHelper: ").append(this.genAggregations).append(".name \n\n ").append(new StringBuilder(11).append("Code:\n").append(this.genAggregations).append(".code").toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.accumulators_$eq(this.function().createAccumulators());
        this.output_$eq(this.function().createOutputRow());
    }

    public void combine(Iterable<Row> records, Collector<Row> out) {
        Long windowStart = null;
        Long windowEnd = null;
        Long currentRowTime = null;
        this.function().resetAccumulator(this.accumulators());
        for (Row record : records) {
            currentRowTime = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)record.getField(this.rowTimeFieldPos())));
            if (windowEnd == null || windowEnd != null && Predef$.MODULE$.Long2long(currentRowTime) > Predef$.MODULE$.Long2long(windowEnd)) {
                if (windowEnd != null) {
                    this.doCollect(out, Predef$.MODULE$.Long2long(windowStart), Predef$.MODULE$.Long2long(windowEnd));
                    this.function().resetAccumulator(this.accumulators());
                } else {
                    this.function().setForwardedFields(record, this.output());
                }
                windowStart = Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)record.getField(this.rowTimeFieldPos())));
            }
            this.function().mergeAccumulatorsPair(this.accumulators(), record);
            windowEnd = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(currentRowTime) + this.gap);
        }
        this.doCollect(out, Predef$.MODULE$.Long2long(windowStart), Predef$.MODULE$.Long2long(windowEnd));
    }

    public void mapPartition(Iterable<Row> records, Collector<Row> out) {
        this.combine(records, out);
    }

    public void doCollect(Collector<Row> out, long windowStart, long windowEnd) {
        this.function().setAggregationResults(this.accumulators(), this.output());
        this.output().setField(this.rowTimeFieldPos(), (Object)BoxesRunTime.boxToLong((long)windowStart));
        this.output().setField(this.rowTimeFieldPos() + 1, (Object)BoxesRunTime.boxToLong((long)windowEnd));
        out.collect((Object)this.output());
    }

    public TypeInformation<Row> getProducedType() {
        return this.intermediateRowType();
    }

    public DataSetSessionWindowAggregatePreProcessor(GeneratedAggregationsFunction genAggregations, int keysAndAggregatesArity, long gap, TypeInformation<Row> intermediateRowType) {
        this.genAggregations = genAggregations;
        this.gap = gap;
        this.intermediateRowType = intermediateRowType;
        Compiler.$init$(this);
        Logging.$init$(this);
        this.rowTimeFieldPos = keysAndAggregatesArity;
    }
}

