/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.advise.SqlAdvisor;
import org.apache.calcite.sql.advise.SqlAdvisorValidator;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.parse.CalciteParser;
import org.apache.flink.table.parse.ExtendedParser;
import org.apache.flink.table.sqlexec.SqlToOperationConverter;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class ParserImpl
implements Parser {
    private final CatalogManager catalogManager;
    private final Supplier<FlinkPlannerImpl> validatorSupplier;
    private final Supplier<CalciteParser> calciteParserSupplier;
    private static final ExtendedParser EXTENDED_PARSER = ExtendedParser.INSTANCE;

    public ParserImpl(CatalogManager catalogManager, Supplier<FlinkPlannerImpl> validatorSupplier, Supplier<CalciteParser> calciteParserSupplier) {
        this.catalogManager = catalogManager;
        this.validatorSupplier = validatorSupplier;
        this.calciteParserSupplier = calciteParserSupplier;
    }

    @Override
    public List<Operation> parse(String statement) {
        CalciteParser parser = this.calciteParserSupplier.get();
        FlinkPlannerImpl planner = this.validatorSupplier.get();
        Optional<Operation> command = EXTENDED_PARSER.parse(statement);
        if (command.isPresent()) {
            return Collections.singletonList(command.get());
        }
        SqlNode parsed = parser.parse(statement);
        Operation operation = SqlToOperationConverter.convert(planner, this.catalogManager, parsed).orElseThrow(() -> new TableException("Unsupported SQL query! parse() only accepts SQL queries of type SELECT, UNION, INTERSECT, EXCEPT, VALUES, ORDER_BY or INSERT;and SQL DDLs of type CREATE TABLE"));
        return Collections.singletonList(operation);
    }

    @Override
    public UnresolvedIdentifier parseIdentifier(String identifier) {
        CalciteParser parser = this.calciteParserSupplier.get();
        SqlIdentifier sqlIdentifier = parser.parseIdentifier(identifier);
        return UnresolvedIdentifier.of(sqlIdentifier.names);
    }

    @Override
    public ResolvedExpression parseSqlExpression(String sqlExpression, RowType inputRowType, @Nullable LogicalType outputType) {
        throw new UnsupportedOperationException("Computed columns is only supported by the Blink planner.");
    }

    @Override
    public String[] getCompletionHints(String statement, int position) {
        ArrayList<String> candidates = new ArrayList<String>(Arrays.asList(EXTENDED_PARSER.getCompletionHints(statement, position)));
        SqlAdvisorValidator validator = this.validatorSupplier.get().getSqlAdvisorValidator();
        SqlAdvisor advisor = new SqlAdvisor(validator, this.validatorSupplier.get().config().getParserConfig());
        String[] replaced = new String[1];
        List sqlHints = advisor.getCompletionHints(statement, position, replaced).stream().map(item -> item.toIdentifier().toString()).collect(Collectors.toList());
        candidates.addAll(sqlHints);
        return candidates.toArray(new String[0]);
    }
}

