/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.schema;

import java.io.Serializable;
import java.util.function.Function;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.plan.stats.FlinkStatistic;
import org.apache.flink.table.sources.DefinedFieldMapping;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.table.utils.TypeMappingUtils;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001=\u0011\u0001\u0003V1cY\u0016\u001cv.\u001e:dKR\u000b'\r\\3\u000b\u0005\r!\u0011AB:dQ\u0016l\u0017M\u0003\u0002\u0006\r\u0005!\u0001\u000f\\1o\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001)\"\u0001\u0005\u0019\u0014\u0005\u0001\t\u0002C\u0001\n\u0019\u001b\u0005\u0019\"B\u0001\u000b\u0016\u0003\u0011IW\u000e\u001d7\u000b\u0005\r1\"BA\f\u000b\u0003\u001d\u0019\u0017\r\\2ji\u0016L!!G\n\u0003\u001b\u0005\u00137\u000f\u001e:bGR$\u0016M\u00197f\u0011!Y\u0002A!b\u0001\n\u0003a\u0012a\u0003;bE2,7k\u00195f[\u0006,\u0012!\b\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\t1!\u00199j\u0013\t\u0011sDA\u0006UC\ndWmU2iK6\f\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u000f\u0002\u0019Q\f'\r\\3TG\",W.\u0019\u0011\t\u0011\u0019\u0002!Q1A\u0005\u0002\u001d\n1\u0002^1cY\u0016\u001cv.\u001e:dKV\t\u0001\u0006E\u0002*Y9j\u0011A\u000b\u0006\u0003W\u0019\tqa]8ve\u000e,7/\u0003\u0002.U\tYA+\u00192mKN{WO]2f!\ty\u0003\u0007\u0004\u0001\u0005\u000bE\u0002!\u0019\u0001\u001a\u0003\u0003Q\u000b\"aM\u001d\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\u000f9{G\u000f[5oOB\u0011AGO\u0005\u0003wU\u00121!\u00118z\u0011!i\u0004A!A!\u0002\u0013A\u0013\u0001\u0004;bE2,7k\\;sG\u0016\u0004\u0003\u0002C \u0001\u0005\u000b\u0007I\u0011\u0001!\u0002\u001f%\u001c8\u000b\u001e:fC6LgnZ'pI\u0016,\u0012!\u0011\t\u0003i\tK!aQ\u001b\u0003\u000f\t{w\u000e\\3b]\"AQ\t\u0001B\u0001B\u0003%\u0011)\u0001\tjgN#(/Z1nS:<Wj\u001c3fA!Aq\t\u0001BC\u0002\u0013\u0005\u0001*A\u0005ti\u0006$\u0018n\u001d;jGV\t\u0011\n\u0005\u0002K\u001b6\t1J\u0003\u0002M\t\u0005)1\u000f^1ug&\u0011aj\u0013\u0002\u000f\r2Lgn[*uCRL7\u000f^5d\u0011!\u0001\u0006A!A!\u0002\u0013I\u0015AC:uCRL7\u000f^5dA!)!\u000b\u0001C\u0001'\u00061A(\u001b8jiz\"R\u0001\u0016,X1f\u00032!\u0016\u0001/\u001b\u0005\u0011\u0001\"B\u000eR\u0001\u0004i\u0002\"\u0002\u0014R\u0001\u0004A\u0003\"B R\u0001\u0004\t\u0005\"B$R\u0001\u0004I\u0005\"B.\u0001\t\u0003b\u0016\u0001D4fiN#\u0018\r^5ti&\u001cG#A/\u0011\u0005y{V\"A\u000b\n\u0005\u0001,\"!C*uCRL7\u000f^5d\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003)9W\r\u001e*poRK\b/\u001a\u000b\u0003I2\u0004\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\tQL\b/\u001a\u0006\u0003SZ\t1A]3m\u0013\tYgMA\u0006SK2$\u0015\r^1UsB,\u0007\"B7b\u0001\u0004q\u0017a\u0003;za\u00164\u0015m\u0019;pef\u0004\"!Z8\n\u0005A4'A\u0005*fY\u0012\u000bG/\u0019+za\u00164\u0015m\u0019;pefDQA\u001d\u0001\u0005\u0002M\f\u0001\"\\1q\u0013:$W\r\u001f\u000b\u0006i\u0006\r\u0011Q\u0002\u0019\u0003k~\u00042A\u001e?\u007f\u001b\u00059(B\u0001=z\u0003!!\u0018\u0010]3j]\u001a|'B\u0001>|\u0003\u0019\u0019w.\\7p]*\u0011\u0001\u0005C\u0005\u0003{^\u0014q\u0002V=qK&sgm\u001c:nCRLwN\u001c\t\u0003_}$!\"!\u0001r\u0003\u0003\u0005\tQ!\u00013\u0005\ryFE\r\u0005\b\u0003\u000b\t\b\u0019AA\u0004\u0003\rIG\r\u001f\t\u0004i\u0005%\u0011bAA\u0006k\t\u0019\u0011J\u001c;\t\u000f\u0005=\u0011\u000f1\u0001\u0002\u0012\u0005aQ.\u00199O_:l\u0015M]6feB9A'a\u0005\u0002\b\u0005]\u0011bAA\u000bk\tIa)\u001e8di&|g.\r\u0019\u0005\u00033\ti\u0002\u0005\u0003wy\u0006m\u0001cA\u0018\u0002\u001e\u0011Y\u0011qDA\u0007\u0003\u0003\u0005\tQ!\u00013\u0005\ryF%\r")
public class TableSourceTable<T>
extends AbstractTable {
    private final TableSchema tableSchema;
    private final TableSource<T> tableSource;
    private final boolean isStreamingMode;
    private final FlinkStatistic statistic;

    public TableSchema tableSchema() {
        return this.tableSchema;
    }

    public TableSource<T> tableSource() {
        return this.tableSource;
    }

    public boolean isStreamingMode() {
        return this.isStreamingMode;
    }

    public FlinkStatistic statistic() {
        return this.statistic;
    }

    @Override
    public Statistic getStatistic() {
        return this.statistic();
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        TypeInformation[] typeInformationArray;
        TableSource<T> tableSource;
        FlinkTypeFactory flinkTypeFactory = (FlinkTypeFactory)typeFactory;
        String[] fieldNames = this.tableSchema().getFieldNames();
        TableSource<T> tableSource2 = this.tableSource();
        Function<String, String> function = tableSource2 instanceof DefinedFieldMapping && ((DefinedFieldMapping)((Object)(tableSource = tableSource2))).getFieldMapping() != null ? new Function<String, String>(null, tableSource){
            private final TableSource x2$1;

            public <V> Function<V, String> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super String, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public String apply(String t) {
                return ((DefinedFieldMapping)((Object)this.x2$1)).getFieldMapping().get(t);
            }
            {
                this.x2$1 = x2$1;
            }
        } : Function.identity();
        Function<String, String> nameMapping = function;
        DataType producedDataType = this.tableSource().getProducedDataType();
        int[] fieldIndexes = TypeMappingUtils.computePhysicalIndicesOrTimeAttributeMarkers(this.tableSource(), this.tableSchema().getTableColumns(), this.isStreamingMode(), nameMapping);
        if (LogicalTypeChecks.isCompositeType(producedDataType.getLogicalType())) {
            ResolvedSchema physicalSchema = DataTypeUtils.expandCompositeTypeToSchema(producedDataType);
            typeInformationArray = (TypeInformation[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(fieldIndexes)).map((Function1 & Serializable & scala.Serializable)x$1 -> this.mapIndex(BoxesRunTime.unboxToInt((Object)x$1), (Function1 & Serializable & scala.Serializable)idx -> TableSourceTable.$anonfun$getRowType$2(physicalSchema$1, BoxesRunTime.unboxToInt((Object)idx))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)));
        } else {
            typeInformationArray = (TypeInformation[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(fieldIndexes)).map((Function1 & Serializable & scala.Serializable)x$2 -> this.mapIndex(BoxesRunTime.unboxToInt((Object)x$2), (Function1 & Serializable & scala.Serializable)x$3 -> TableSourceTable.$anonfun$getRowType$4(producedDataType$1, BoxesRunTime.unboxToInt((Object)x$3))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)));
        }
        TypeInformation[] typeInfos = typeInformationArray;
        return flinkTypeFactory.buildLogicalRowType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])fieldNames), (Seq<TypeInformation<?>>)Predef$.MODULE$.wrapRefArray((Object[])typeInfos));
    }

    public TypeInformation<?> mapIndex(int idx, Function1<Object, TypeInformation<?>> mapNonMarker) {
        Object object;
        int n = idx;
        switch (n) {
            case -3: {
                object = Types.SQL_TIMESTAMP();
                break;
            }
            case -4: {
                object = Types.SQL_TIMESTAMP();
                break;
            }
            case -2: {
                object = TimeIndicatorTypeInfo.PROCTIME_INDICATOR;
                break;
            }
            case -1: {
                object = TimeIndicatorTypeInfo.ROWTIME_INDICATOR;
                break;
            }
            default: {
                object = (TypeInformation)mapNonMarker.apply((Object)BoxesRunTime.boxToInteger((int)idx));
                break;
            }
        }
        return object;
    }

    public static final /* synthetic */ TypeInformation $anonfun$getRowType$2(ResolvedSchema physicalSchema$1, int idx) {
        return TypeConversions.fromDataTypeToLegacyInfo(physicalSchema$1.getColumnDataTypes().get(idx));
    }

    public static final /* synthetic */ TypeInformation $anonfun$getRowType$4(DataType producedDataType$1, int x$3) {
        return TypeConversions.fromDataTypeToLegacyInfo(producedDataType$1);
    }

    public TableSourceTable(TableSchema tableSchema, TableSource<T> tableSource, boolean isStreamingMode, FlinkStatistic statistic) {
        this.tableSchema = tableSchema;
        this.tableSource = tableSource;
        this.isStreamingMode = isStreamingMode;
        this.statistic = statistic;
        TableSourceValidation.validateTableSource(tableSource, tableSchema);
    }
}

